/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.lrmi;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.reflection.IMethod;
import com.gigaspaces.lrmi.LRMIUtilities;

@InternalApi
public class LRMIMethod {
    public final boolean isOneWay;
    public final int orderId;
    public final IMethod realMethod;
    public final boolean isCallBack;
    public final boolean isAsync;
    public final boolean useStubCache;
    public final boolean supported;
    public final boolean isLivenessPriority;
    public final boolean isMonitoringPriority;
    public final boolean isCustomTracking;
    public final Class<?>[] methodTypes;
    public final String realMethodString;

    public LRMIMethod(IMethod realMethod, boolean isOneWay, boolean isCallBack, boolean isAsync, boolean useStubCache, boolean livenessPriority, boolean monitoringPriority, boolean isCustomTracking, int orderId) {
        this(realMethod, isOneWay, isCallBack, isAsync, useStubCache, livenessPriority, monitoringPriority, isCustomTracking, orderId, true);
    }

    private LRMIMethod(IMethod realMethod, boolean isOneWay, boolean isCallBack, boolean isAsync, boolean useStubCache, boolean livenessPriority, boolean monitoringPriority, boolean isCustomTracking, int orderId, boolean supported) {
        this.realMethod = realMethod;
        this.isOneWay = isOneWay;
        this.isCallBack = isCallBack;
        this.useStubCache = useStubCache;
        this.isCustomTracking = isCustomTracking;
        this.orderId = orderId;
        this.isAsync = isAsync;
        this.supported = supported;
        this.isLivenessPriority = livenessPriority;
        this.isMonitoringPriority = monitoringPriority;
        this.methodTypes = this.realMethod == null ? null : this.realMethod.getParameterTypes();
        this.realMethodString = LRMIUtilities.getMethodDisplayString(this.realMethod);
    }

    public static LRMIMethod wrapAsUnsupported(IMethod<?> realMethod) {
        return new LRMIMethod(realMethod, false, false, false, false, false, false, false, -1, false);
    }

    public String toString() {
        return "Method = " + this.realMethod + ", IsOneWay = " + this.isOneWay + ", IsAsync = " + this.isAsync + ", IsCallBack = " + this.isCallBack + ", UseStubCache = " + this.useStubCache + ", IsLivenessPriority=" + this.isLivenessPriority + ", IsMonitoringPriority=" + this.isMonitoringPriority + ", IsCustomTracking=" + this.isCustomTracking;
    }

    public boolean isSupported() {
        return this.supported;
    }
}

