/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.lrmi;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.config.ConfigurationException;
import com.gigaspaces.config.lrmi.ITransportConfig;
import com.gigaspaces.config.lrmi.nio.NIOConfiguration;
import com.gigaspaces.exception.lrmi.ApplicationException;
import com.gigaspaces.exception.lrmi.RMIShutDownException;
import com.gigaspaces.internal.reflection.IMethod;
import com.gigaspaces.internal.reflection.ReflectionUtil;
import com.gigaspaces.internal.stubcache.StubCache;
import com.gigaspaces.internal.version.PlatformLogicalVersion;
import com.gigaspaces.lrmi.ClientPeerInvocationHandler;
import com.gigaspaces.lrmi.DefaultNetworkMapper;
import com.gigaspaces.lrmi.DynamicSmartStub;
import com.gigaspaces.lrmi.INetworkMapper;
import com.gigaspaces.lrmi.LRMIMonitoringDetails;
import com.gigaspaces.lrmi.LRMIUtilities;
import com.gigaspaces.lrmi.ObjectRegistry;
import com.gigaspaces.lrmi.ProtocolAdapter;
import com.gigaspaces.lrmi.ProtocolRegistry;
import com.gigaspaces.lrmi.ServerPeer;
import com.gigaspaces.lrmi.UIDGen;
import com.gigaspaces.lrmi.nio.Pivot;
import com.gigaspaces.lrmi.nio.async.LRMIThreadPoolExecutor;
import com.gigaspaces.lrmi.nio.watchdog.Watchdog;
import com.gigaspaces.management.transport.ITransportConnection;
import com.j_spaces.core.service.ServiceConfigLoader;
import com.j_spaces.kernel.ClassLoaderHelper;
import com.j_spaces.kernel.threadpool.DynamicThreadPoolExecutor;
import java.lang.reflect.InvocationTargetException;
import java.rmi.NoSuchObjectException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.security.SecureRandom;
import java.util.List;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;

@InternalApi
public class LRMIRuntime {
    private static final Logger _logger = Logger.getLogger("com.gigaspaces.lrmi");
    private static final Logger _exporterLogger = Logger.getLogger("com.gigaspaces.lrmi.exporter");
    private static final LRMIRuntime _runtime = new LRMIRuntime();
    private final ProtocolRegistry _protocolRegistry;
    private final ObjectRegistry _objectRegistry;
    private final long _id;
    private final LRMIThreadPoolExecutor _lrmiThreadPool;
    private final LRMIThreadPoolExecutor _livenessPriorityThreadPool;
    private final LRMIThreadPoolExecutor _monitoringPriorityThreadPool;
    private final LRMIThreadPoolExecutor _customThreadPool;
    private final StubCache _stubCache;
    private final INetworkMapper _networkMapper = LRMIRuntime.constructNetworkMapper();
    private final boolean _shutdownOnLastRegistrar = Boolean.getBoolean("com.gs.transport_protocol.lrmi.shutdownLastRegistrar");
    private boolean _monitorActivity = Boolean.getBoolean("com.gs.transport_protocol.lrmi.monitorActivity");
    private final Object _monitorActivityMemoryBarrier = new Object();
    private boolean _useNetworkInJVM = Boolean.parseBoolean(System.getProperty("com.gs.transport_protocol.lrmi.useNetworkInJVM", "true"));
    private volatile boolean _isShutdown;
    public static final int DUMMY_OBJECT_ID = -1;

    private LRMIRuntime() {
        this._protocolRegistry = new ProtocolRegistry();
        this._objectRegistry = new ObjectRegistry();
        this._stubCache = new StubCache();
        boolean useSecureRandom = Boolean.getBoolean("com.gs.transport_protocol.lrme.use_secure_random");
        Random random = useSecureRandom ? new SecureRandom() : new Random();
        this._id = random.nextLong();
        ITransportConfig config = ServiceConfigLoader.getTransportConfiguration();
        this._lrmiThreadPool = new LRMIThreadPoolExecutor(config.getMinThreads(), config.getMaxThreads(), config.getThreadPoolIdleTimeout(), config.getThreadsQueueSize(), Long.MAX_VALUE, 5, "LRMI Connection", true, true);
        NIOConfiguration nioConfig = (NIOConfiguration)config;
        this._livenessPriorityThreadPool = new LRMIThreadPoolExecutor(nioConfig.getSystemPriorityMinThreads(), nioConfig.getSystemPriorityMaxThreads(), config.getSystemPriorityThreadIdleTimeout(), config.getSystemPriorityQueueCapacity(), Long.MAX_VALUE, 10, "LRMI Liveness Pool", true, true);
        this._monitoringPriorityThreadPool = new LRMIThreadPoolExecutor(nioConfig.getSystemPriorityMinThreads(), nioConfig.getSystemPriorityMaxThreads(), config.getSystemPriorityThreadIdleTimeout(), config.getSystemPriorityQueueCapacity(), Long.MAX_VALUE, 5, "LRMI Monitoring Pool", true, true);
        this._customThreadPool = new LRMIThreadPoolExecutor(nioConfig.getCustomMinThreads(), nioConfig.getCustomMaxThreads(), nioConfig.getCustomThreadIdleTimeout(), nioConfig.getCustomQueueCapacity(), Long.MAX_VALUE, 5, "LRMI Custom Pool", true, true);
    }

    private static INetworkMapper constructNetworkMapper() {
        String networkMapperName = System.getProperty("com.gs.transport_protocol.lrmi.network-mapper");
        if (networkMapperName == null) {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("Creating default network mapper");
            }
            return new DefaultNetworkMapper();
        }
        try {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("Creating custom network mapper provider " + networkMapperName);
            }
            Class loadClass = ClassLoaderHelper.loadClass(networkMapperName, true);
            return (INetworkMapper)loadClass.newInstance();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("The specified network mapper [" + networkMapperName + "] could not be created", e);
        }
    }

    public static LRMIRuntime getRuntime() {
        return _runtime;
    }

    public static LRMIRuntime getRuntime(ITransportConfig config, ProtocolAdapter.Side initSide) throws ConfigurationException {
        if (config != null) {
            _runtime.init(config, initSide);
        }
        return _runtime;
    }

    public long getID() {
        return this._id;
    }

    private void init(ITransportConfig config, ProtocolAdapter.Side initSide) throws ConfigurationException {
        this._protocolRegistry.init(config, initSide);
    }

    public DynamicThreadPoolExecutor getThreadPool() {
        return this._lrmiThreadPool;
    }

    public DynamicThreadPoolExecutor getMonitoringPriorityThreadPool() {
        return this._monitoringPriorityThreadPool;
    }

    public DynamicThreadPoolExecutor getLivenessPriorityThreadPool() {
        return this._livenessPriorityThreadPool;
    }

    public DynamicThreadPoolExecutor getCustomThreadPool() {
        return this._customThreadPool;
    }

    public boolean isUseNetworkInJVM() {
        return this._useNetworkInJVM;
    }

    public void setUseNetworkInJVM(boolean useNetworkInJVM) {
        this._useNetworkInJVM = useNetworkInJVM;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMonitorActivity(boolean trackActivity) {
        Object object = this._monitorActivityMemoryBarrier;
        synchronized (object) {
            this._monitorActivity = trackActivity;
        }
    }

    public boolean isMonitorActivity() {
        return this._monitorActivity;
    }

    public ProtocolRegistry getProtocolRegistry() {
        return this._protocolRegistry;
    }

    public int getPort(ITransportConfig config) {
        return LRMIRuntime.getRuntime().getProtocolRegistry().getPort(config);
    }

    public LRMIMonitoringDetails getMonitoringDetails(ITransportConfig config) {
        if (!this.isMonitorActivity()) {
            throw new IllegalStateException("LRMI monitoring must be enabled in order to get monitoring details");
        }
        return LRMIRuntime.getRuntime().getProtocolRegistry().getMonitoringDetails(config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ServerPeer export(Remote object, ITransportConfig config) throws RemoteException, ConfigurationException {
        if (this._isShutdown) {
            throw new RMIShutDownException("LRMIRuntime was shutdown");
        }
        if (_exporterLogger.isLoggable(Level.FINE)) {
            _exporterLogger.log(Level.FINE, "Trying to export class=" + object.getClass());
        }
        String protocol = config.getProtocolName();
        ObjectRegistry objectRegistry = this._objectRegistry;
        synchronized (objectRegistry) {
            ProtocolAdapter protocolAdapter;
            if (config != null) {
                this.init(config, ProtocolAdapter.Side.SERVER);
            }
            if ((protocolAdapter = (ProtocolAdapter)this._protocolRegistry.get(protocol)) == null) {
                throw new RemoteException("Failed to export object: protocol " + protocol + " is not registered in protocol registry");
            }
            ObjectRegistry.Entry orEntry = this._objectRegistry.getEntryFromObject(object);
            if (orEntry == null) {
                orEntry = this._objectRegistry.createEntry(object, UIDGen.nextId(), LRMIUtilities.getSortedLRMIMethodList(object.getClass()));
                ServerPeer serverPeer = protocolAdapter.newServerPeer(orEntry.m_ObjectId, orEntry.getExportedThreadClassLoader(), Pivot.getServiceDetails(object));
                serverPeer.beforeExport(config);
                orEntry.setProtocol(protocol);
                orEntry.setServerPeer(serverPeer);
                if (_exporterLogger.isLoggable(Level.FINE)) {
                    _exporterLogger.log(Level.FINE, "LRMIRuntime exported remote object [localObj=" + object.getClass().getName() + "@" + Integer.toHexString(System.identityHashCode(object)) + ", protocol=" + protocol + ", remoteObjID=" + orEntry.m_ObjectId + ", RemoteObjectClassLoader=" + object.getClass().getClassLoader() + ", ExportedThreadClassLoader: " + orEntry.getExportedThreadClassLoader() + "]");
                }
            }
            return orEntry.getServerPeer();
        }
    }

    public Remote createDynamicProxy(Remote remoteObj, ITransportConfig config, boolean allowCache) {
        DynamicSmartStub genericStub = new DynamicSmartStub(remoteObj, config);
        Class<?>[] remoteInterfaces = LRMIUtilities.getProxyInterfaces(remoteObj.getClass());
        return (Remote)ReflectionUtil.createProxy(remoteObj.getClass().getClassLoader(), remoteInterfaces, genericStub, allowCache);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unexport(Remote object, String protocol, boolean force) throws RemoteException, NoSuchObjectException {
        if (this._isShutdown) {
            return;
        }
        ObjectRegistry objectRegistry = this._objectRegistry;
        synchronized (objectRegistry) {
            ObjectRegistry.Entry orEntry = this._objectRegistry.getEntryFromObject(object);
            if (orEntry == null) {
                throw new NoSuchObjectException("Failed to unexport object: object is not exported");
            }
            if (!orEntry.getProtocol().equals(protocol)) {
                throw new NoSuchObjectException("Failed to unexport object: " + object.getClass().getName() + " object is not exported on protocol " + protocol);
            }
            this._objectRegistry.removeEntry(object);
            ServerPeer serverPeer = orEntry.getServerPeer();
            serverPeer.afterUnexport(force);
            if (this._shutdownOnLastRegistrar && this._objectRegistry.isLastRegistrar(protocol)) {
                this._protocolRegistry.remove(protocol);
                serverPeer.getProtocolAdapter().shutdown();
            }
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "LRMIRuntime unexported remote object [localObj=" + object.getClass().getName() + "@" + System.identityHashCode(object) + ", protocol=" + protocol + ", remoteObjID=" + orEntry.m_ObjectId + "]");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ClientPeerInvocationHandler getClientInvocationHandler(String connectionURL, ITransportConfig config, PlatformLogicalVersion serviceVersion) throws RemoteException, ConfigurationException {
        if (this._isShutdown) {
            throw new RMIShutDownException("LRMIRuntime was shutdown");
        }
        String protocolName = config.getProtocolName();
        ObjectRegistry objectRegistry = this._objectRegistry;
        synchronized (objectRegistry) {
            this.init(config, ProtocolAdapter.Side.CLIENT);
            ProtocolAdapter pa = (ProtocolAdapter)this._protocolRegistry.get(protocolName);
            if (pa == null) {
                throw new RemoteException("Protocol " + protocolName + " not found in protocol registry");
            }
            return pa.getClientInvocationHandler(connectionURL, config, serviceVersion);
        }
    }

    public ObjectRegistry.Entry getRegistryObject(long objectId) {
        return this._objectRegistry.getEntryFromObjectIdIfExists(objectId);
    }

    public Object invoked(long objectId, IMethod method, Object[] args) throws RemoteException, ApplicationException {
        ObjectRegistry.Entry orEntry = this._objectRegistry.getEntryFromObjectId(objectId);
        Remote targetObject = orEntry.m_Object;
        ClassLoader orgThreadClassLoader = Thread.currentThread().getContextClassLoader();
        boolean changeCL = orgThreadClassLoader != orEntry.getExportedThreadClassLoader();
        try {
            if (changeCL) {
                ClassLoaderHelper.setContextClassLoader(orEntry.getExportedThreadClassLoader(), true);
            }
            if (_logger.isLoggable(Level.FINER)) {
                _logger.entering("LRMIRuntime - " + targetObject.getClass().getName() + "#" + objectId, method.getName(), args);
            }
            Object resultInv = method.invoke(targetObject, args);
            if (_logger.isLoggable(Level.FINER)) {
                _logger.exiting("LRMIRuntime - " + targetObject.getClass().getName() + "#" + objectId, method.getName(), resultInv);
            }
            Object object = resultInv;
            return object;
        }
        catch (IllegalArgumentException ex) {
            String exMsg = "LRMIRuntime - Failed to invoke RemoteMethod: [" + method + "] on [" + targetObject + "] Reason: " + ex.toString();
            if (_logger.isLoggable(Level.SEVERE)) {
                _logger.log(Level.SEVERE, exMsg, ex);
            }
            throw new ApplicationException(exMsg, ex);
        }
        catch (IllegalAccessException ex) {
            String exMsg = "LRMIRuntime - Failed to invoke RemoteMethod: [" + method + "] on [" + targetObject + "] Reason: " + ex.toString();
            if (_logger.isLoggable(Level.SEVERE)) {
                _logger.log(Level.SEVERE, exMsg, ex);
            }
            throw new ApplicationException(exMsg, ex);
        }
        catch (InvocationTargetException ex) {
            if (_logger.isLoggable(Level.FINER)) {
                String exMsg = "LRMIRuntime - Failed to invoke RemoteMethod: " + method + " Reason: " + ex.toString();
                _logger.log(Level.FINER, exMsg, ex.getTargetException());
            }
            throw new ApplicationException(null, ex.getTargetException());
        }
        finally {
            if (changeCL) {
                ClassLoaderHelper.setContextClassLoader(orgThreadClassLoader, true);
            }
        }
    }

    public List<ITransportConnection> getRemoteObjectConnectionsList(long remoteObjID) throws NoSuchObjectException {
        return this._objectRegistry.getEntryFromObjectId(remoteObjID).getServerPeer().getProtocolAdapter().getRemoteObjectConnectionsList(remoteObjID);
    }

    public int countRemoteObjectConnections(long remoteObjID) throws NoSuchObjectException {
        return this._objectRegistry.getEntryFromObjectId(remoteObjID).getServerPeer().getProtocolAdapter().countRemoteObjectConnections(remoteObjID);
    }

    public StubCache getStubCache() {
        return this._stubCache;
    }

    public synchronized void shutdown() {
        if (this._isShutdown) {
            return;
        }
        this._isShutdown = true;
        for (ProtocolAdapter protocolAdapter : this._protocolRegistry.values()) {
            protocolAdapter.shutdown();
        }
        this._protocolRegistry.clear();
        this._objectRegistry.clear();
        this._stubCache.clear();
        this._lrmiThreadPool.shutdownNow();
        this._monitoringPriorityThreadPool.shutdownNow();
        this._livenessPriorityThreadPool.shutdownNow();
        this._customThreadPool.shutdown();
        DynamicSmartStub.shutdown();
        Watchdog.shutdown();
    }

    public INetworkMapper getNetworkMapper() {
        return this._networkMapper;
    }

    public void simulatedDisconnectionByPID(int pid) {
        DynamicSmartStub.simulatedDisconnectionByPID(pid);
    }

    public void simulatedReconnectionByPID(int pid) {
        DynamicSmartStub.simulatedReconnectionByPID(pid);
    }
}

