/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.lrmi;

import com.gigaspaces.annotation.lrmi.AsyncRemoteCall;
import com.gigaspaces.annotation.lrmi.CallBackRemoteCall;
import com.gigaspaces.annotation.lrmi.CustomTracking;
import com.gigaspaces.annotation.lrmi.LivenessPriority;
import com.gigaspaces.annotation.lrmi.MonitoringPriority;
import com.gigaspaces.annotation.lrmi.OneWayRemoteCall;
import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.io.GSByteArrayInputStream;
import com.gigaspaces.internal.io.GSByteArrayOutputStream;
import com.gigaspaces.internal.io.MarshalInputStream;
import com.gigaspaces.internal.io.MarshalOutputStream;
import com.gigaspaces.internal.reflection.IMethod;
import com.gigaspaces.internal.reflection.ReflectionUtil;
import com.gigaspaces.internal.version.PlatformLogicalVersion;
import com.gigaspaces.lrmi.ILRMIProxy;
import com.gigaspaces.lrmi.LRMIMethod;
import com.gigaspaces.lrmi.LRMIMethodMetadata;
import com.gigaspaces.lrmi.OneWayMethodRepository;
import com.gigaspaces.lrmi.RemoteMethodCache;
import com.gigaspaces.management.transport.ConnectionEndpointDetails;
import com.j_spaces.kernel.ClassLoaderHelper;
import java.io.IOException;
import java.net.SocketException;
import java.nio.channels.SocketChannel;
import java.rmi.Remote;
import java.security.PrivilegedAction;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.export.UseStubCache;
import net.jini.security.Security;

@InternalApi
public class LRMIUtilities {
    private static final Logger _logger = Logger.getLogger("com.gigaspaces.lrmi");
    private static final Comparator<IMethod> _methodComparator = new MethodComparator();
    public static final int SEND_BUFFER_SIZE = Integer.getInteger("com.gs.transport_protocol.lrmi.tcp-send-buffer-size", 0);
    public static final int RECEIVE_BUFFER_SIZE = Integer.getInteger("com.gs.transport_protocol.lrmi.tcp-receive-buffer-size", 0);
    public static final boolean KEEP_ALIVE_MODE = Boolean.valueOf(System.getProperty("com.gs.transport_protocol.lrmi.tcp-keep-alive", String.valueOf(true)));
    public static final boolean TCP_NO_DELAY_MODE = Boolean.valueOf(System.getProperty("com.gs.transport_protocol.lrmi.tcp-no-delay", String.valueOf(true)));
    public static final Integer TRAFFIC_CLASS = Integer.getInteger("com.gs.transport_protocol.lrmi.tcp-traffic-class");
    private static final long KILO = 1024L;
    private static final long MEGA = 0x100000L;
    private static final long GIGA = 0x40000000L;
    private static final long TERA = 0x10000000000L;
    private static boolean _hadSetSendBufferSizeError = false;
    private static boolean _hadSetReceiveBufferSizeError = false;
    private static boolean _hadSetKeepAliveError = false;
    private static boolean _hadSetTcpNoDelayError = false;
    private static boolean _hadSetTrafficClassError = false;
    private static final DecimalFormat DECIMAL_FORMAT = new DecimalFormat("#.##");

    public static Class<?>[] getProxyInterfaces(Class<?> claz) {
        List<Class<?>> declaredInterfaces = LRMIUtilities.getDeclaredRemoteInterfaces(claz);
        declaredInterfaces.add(ILRMIProxy.class);
        return declaredInterfaces.toArray(new Class[declaredInterfaces.size()]);
    }

    public static List<Class<?>> getDeclaredRemoteInterfaces(Class<?> claz) {
        return LRMIUtilities.getDeclaredInterfaces(claz, Remote.class);
    }

    public static List<Class<?>> getDeclaredInterfaces(Class claz, Class ... assignableClasses) {
        ArrayList interfList = new ArrayList();
        while (!claz.equals(Object.class)) {
            for (Class<?> cl : claz.getInterfaces()) {
                if (assignableClasses.length > 0) {
                    for (Class assignClaz : assignableClasses) {
                        if (!assignClaz.isAssignableFrom(cl)) continue;
                        interfList.add(cl);
                    }
                    continue;
                }
                interfList.add(cl);
            }
            claz = claz.getSuperclass();
        }
        return interfList;
    }

    public static RemoteMethodCache createRemoteMethodCache(List<Class<?>> remoteInterfaces, Map<String, Integer> methodMapping, Map<String, LRMIMethodMetadata> overrideMethodsMetadata) {
        List<IMethod> sortedMethodList = LRMIUtilities.getSortedMethodList(remoteInterfaces);
        LRMIMethod[] lrmiMethodList = LRMIUtilities.wrapAsRemoteLRMIMethods(methodMapping, overrideMethodsMetadata, sortedMethodList);
        return new RemoteMethodCache(lrmiMethodList);
    }

    private static LRMIMethod[] wrapAsRemoteLRMIMethods(Map<String, Integer> methodMapping, Map<String, LRMIMethodMetadata> overrideMethodsMetadata, List<IMethod> sortedMethodList) {
        int methodListSize = sortedMethodList.size();
        LRMIMethod[] lrmiMethodList = new LRMIMethod[methodListSize];
        for (int i = 0; i < methodListSize; ++i) {
            Integer methodOrder;
            IMethod interfMethod = sortedMethodList.get(i);
            boolean isOneWay = interfMethod.isAnnotationPresent(OneWayRemoteCall.class) ? true : OneWayMethodRepository.isOneWay(interfMethod);
            boolean isAsync = interfMethod.isAnnotationPresent(AsyncRemoteCall.class);
            boolean isCallBack = interfMethod.isAnnotationPresent(CallBackRemoteCall.class);
            boolean useStubCache = interfMethod.isAnnotationPresent(UseStubCache.class);
            boolean livenessPriority = interfMethod.isAnnotationPresent(LivenessPriority.class);
            boolean monitoringPriority = interfMethod.isAnnotationPresent(MonitoringPriority.class);
            boolean isCustomTracking = interfMethod.isAnnotationPresent(CustomTracking.class);
            String methodNameAndDescriptor = LRMIUtilities.getMethodNameAndDescriptor(interfMethod);
            if (overrideMethodsMetadata != null && overrideMethodsMetadata.containsKey(methodNameAndDescriptor)) {
                LRMIMethodMetadata lrmiMethodMetadata = overrideMethodsMetadata.get(methodNameAndDescriptor);
                if (lrmiMethodMetadata.isOneWayPresence()) {
                    isOneWay = lrmiMethodMetadata.isOneWay();
                    _logger.fine("LRMI override metadata one-way [" + isOneWay + "] : " + interfMethod);
                }
                if (lrmiMethodMetadata.isAsyncPresence()) {
                    isAsync = lrmiMethodMetadata.isAsync();
                }
            }
            if (isOneWay && _logger.isLoggable(Level.FINE)) {
                _logger.fine("LRMI @OneWayRemoteCallAnnotation - registered one-way method : " + interfMethod);
            }
            lrmiMethodList[i] = (methodOrder = methodMapping.get(methodNameAndDescriptor)) == null ? LRMIMethod.wrapAsUnsupported(interfMethod) : new LRMIMethod(interfMethod, isOneWay, isCallBack, isAsync, useStubCache, livenessPriority, monitoringPriority, isCustomTracking, methodOrder);
        }
        return lrmiMethodList;
    }

    static List<IMethod> getSortedMethodList(List<Class<?>> remoteInterfaces) {
        ArrayList<IMethod> methodList = new ArrayList<IMethod>();
        for (Class<?> cl : remoteInterfaces) {
            methodList.addAll(Arrays.asList(ReflectionUtil.createMethods(cl.getMethods())));
        }
        methodList.trimToSize();
        LRMIUtilities.setAccessible(methodList.toArray(new IMethod[methodList.size()]));
        Collections.sort(methodList, _methodComparator);
        return methodList;
    }

    static LRMIMethod[] getSortedLRMIMethodList(Class<?> invokeObjClass) {
        List<Class<?>> interf = LRMIUtilities.getDeclaredRemoteInterfaces(invokeObjClass);
        if (interf.isEmpty()) {
            throw new IllegalArgumentException("This class : " + invokeObjClass + " must implement at least one java.rmi.Remote interface.");
        }
        List<IMethod> sortedMethodList = LRMIUtilities.getSortedMethodList(interf);
        ArrayList<LRMIMethod> sortedLrmiMethodList = new ArrayList<LRMIMethod>();
        for (int i = 0; i < sortedMethodList.size(); ++i) {
            IMethod interfMethod = sortedMethodList.get(i);
            boolean isOneWay = interfMethod.isAnnotationPresent(OneWayRemoteCall.class) ? true : OneWayMethodRepository.isOneWay(interfMethod);
            boolean isCallBack = interfMethod.isAnnotationPresent(CallBackRemoteCall.class);
            boolean isAsync = interfMethod.isAnnotationPresent(AsyncRemoteCall.class);
            boolean useStubCache = interfMethod.isAnnotationPresent(UseStubCache.class);
            boolean livenessPriority = interfMethod.isAnnotationPresent(LivenessPriority.class);
            boolean monitoringPriority = interfMethod.isAnnotationPresent(MonitoringPriority.class);
            boolean isCustomTracking = interfMethod.isAnnotationPresent(CustomTracking.class);
            LRMIMethod lrmiMethod = new LRMIMethod(interfMethod, isOneWay, isCallBack, isAsync, useStubCache, livenessPriority, monitoringPriority, isCustomTracking, i);
            sortedLrmiMethodList.add(lrmiMethod);
        }
        return sortedLrmiMethodList.toArray(new LRMIMethod[sortedLrmiMethodList.size()]);
    }

    private static void setAccessible(final IMethod[] methods) {
        Security.doPrivileged((PrivilegedAction)new PrivilegedAction(){

            public Object run() {
                for (IMethod method : methods) {
                    method.setAccessible(true);
                }
                return null;
            }
        });
    }

    public static String getMethodNameAndDescriptor(IMethod m) {
        Class<?>[] paramTypes;
        StringBuilder desc = new StringBuilder(m.getName());
        desc.append('(');
        for (Class<?> paramType : paramTypes = m.getParameterTypes()) {
            desc.append(LRMIUtilities.getTypeDescriptor(paramType));
        }
        desc.append(')');
        Class<?> returnType = m.getReturnType();
        if (returnType == Void.TYPE) {
            desc.append('V');
        } else {
            desc.append(LRMIUtilities.getTypeDescriptor(returnType));
        }
        return desc.toString();
    }

    public static String getMethodDisplayString(IMethod m) {
        if (m == null) {
            return null;
        }
        return m.getDeclaringClass().getName() + "." + m.getName();
    }

    private static String getTypeDescriptor(Class type) {
        if (type.isPrimitive()) {
            if (type == Integer.TYPE) {
                return "I";
            }
            if (type == Boolean.TYPE) {
                return "Z";
            }
            if (type == Byte.TYPE) {
                return "B";
            }
            if (type == Character.TYPE) {
                return "C";
            }
            if (type == Short.TYPE) {
                return "S";
            }
            if (type == Long.TYPE) {
                return "J";
            }
            if (type == Float.TYPE) {
                return "F";
            }
            if (type == Double.TYPE) {
                return "D";
            }
            if (type == Void.TYPE) {
                return "V";
            }
            throw new Error("unrecognized primitive type: " + type);
        }
        if (type.isArray()) {
            return type.getName().replace('.', '/');
        }
        return "L" + type.getName().replace('.', '/') + ";";
    }

    public static Map<String, IMethod> getMappingMethodDescriptor(Class clazz) {
        List<Class<?>> interfClazzes = LRMIUtilities.getDeclaredInterfaces(clazz, new Class[0]);
        HashMap<String, IMethod> implObjMap = new HashMap<String, IMethod>();
        for (Class<?> interfClass : interfClazzes) {
            IMethod[] implObjMethods = ReflectionUtil.createMethods(interfClass.getMethods());
            LRMIUtilities.setAccessible(implObjMethods);
            for (IMethod m : implObjMethods) {
                String methodDesc = LRMIUtilities.getMethodNameAndDescriptor(m);
                implObjMap.put(methodDesc, m);
            }
        }
        return implObjMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object convertToAssignableClassLoader(Object obj, ClassLoader classLoader) throws IOException, ClassNotFoundException {
        GSByteArrayOutputStream oos = new GSByteArrayOutputStream();
        MarshalOutputStream mos = new MarshalOutputStream(oos);
        mos.writeObject(obj);
        oos.flush();
        GSByteArrayInputStream bais = new GSByteArrayInputStream(oos.toByteArray());
        ClassLoader origCL = Thread.currentThread().getContextClassLoader();
        try {
            ClassLoaderHelper.setContextClassLoader(classLoader, true);
            MarshalInputStream mis = new MarshalInputStream(bais);
            Object object = mis.readObject();
            return object;
        }
        finally {
            ClassLoaderHelper.setContextClassLoader(origCL, true);
        }
    }

    public static boolean isRemoteProxy(Object obj) {
        if (obj instanceof ILRMIProxy) {
            return ((ILRMIProxy)obj).isRemote();
        }
        return false;
    }

    public static PlatformLogicalVersion getServicePlatformLogicalVersion(Object obj) {
        if (obj instanceof ILRMIProxy) {
            return ((ILRMIProxy)obj).getServicePlatformLogicalVersion();
        }
        return PlatformLogicalVersion.getLogicalVersion();
    }

    public static ConnectionEndpointDetails getConnectionEndpointDetails(Object obj) {
        if (obj instanceof ILRMIProxy) {
            ILRMIProxy proxy = (ILRMIProxy)obj;
            return new ConnectionEndpointDetails(proxy.getRemoteHostName(), proxy.getRemoteHostAddress(), proxy.getRemoteProcessId(), proxy.getServicePlatformLogicalVersion());
        }
        return null;
    }

    public static void initNewSocketProperties(SocketChannel sockChannel) throws SocketException {
        block17: {
            block16: {
                block15: {
                    block14: {
                        block13: {
                            if (SEND_BUFFER_SIZE > 0) {
                                try {
                                    sockChannel.socket().setSendBufferSize(SEND_BUFFER_SIZE);
                                }
                                catch (Exception e) {
                                    if (_hadSetSendBufferSizeError) break block13;
                                    _hadSetSendBufferSizeError = true;
                                    _logger.log(Level.WARNING, "Failed setting send buffer size [" + SEND_BUFFER_SIZE + "]", e);
                                }
                            }
                        }
                        if (RECEIVE_BUFFER_SIZE > 0) {
                            try {
                                sockChannel.socket().setReceiveBufferSize(RECEIVE_BUFFER_SIZE);
                            }
                            catch (Exception e) {
                                if (_hadSetReceiveBufferSizeError) break block14;
                                _hadSetReceiveBufferSizeError = true;
                                _logger.log(Level.WARNING, "Failed setting receive buffer size [" + RECEIVE_BUFFER_SIZE + "]", e);
                            }
                        }
                    }
                    try {
                        sockChannel.socket().setKeepAlive(KEEP_ALIVE_MODE);
                    }
                    catch (Exception e) {
                        if (_hadSetKeepAliveError) break block15;
                        _hadSetKeepAliveError = true;
                        _logger.log(Level.WARNING, "Failed setting keep alive mode [" + KEEP_ALIVE_MODE + "]", e);
                    }
                }
                try {
                    sockChannel.socket().setTcpNoDelay(TCP_NO_DELAY_MODE);
                }
                catch (Exception e) {
                    if (_hadSetTcpNoDelayError) break block16;
                    _hadSetTcpNoDelayError = true;
                    _logger.log(Level.WARNING, "Failed setting tcp no delay mode [" + TCP_NO_DELAY_MODE + "]", e);
                }
            }
            if (TRAFFIC_CLASS != null) {
                try {
                    sockChannel.socket().setTrafficClass(TRAFFIC_CLASS);
                }
                catch (Exception e) {
                    if (_hadSetTrafficClassError) break block17;
                    _hadSetTrafficClassError = true;
                    _logger.log(Level.WARNING, "Failed setting traffic class [" + TRAFFIC_CLASS + "]", e);
                }
            }
        }
    }

    public static String getTrafficString(long bytes) {
        if (bytes < 1024L) {
            return bytes + " bytes";
        }
        if (bytes < 0x100000L) {
            return DECIMAL_FORMAT.format((double)bytes / 1024.0) + " kilobytes";
        }
        if (bytes < 0x40000000L) {
            return DECIMAL_FORMAT.format((double)bytes / 1048576.0) + " megabytes";
        }
        if (bytes < 0x10000000000L) {
            return DECIMAL_FORMAT.format((double)bytes / 1.073741824E9) + " gigabytes";
        }
        return DECIMAL_FORMAT.format((double)bytes / 1.099511627776E12) + " terabytes";
    }

    private static final class MethodComparator
    implements Comparator<IMethod> {
        private MethodComparator() {
        }

        @Override
        public int compare(IMethod o1, IMethod o2) {
            String method1 = o1.toString();
            String method2 = o2.toString();
            return method1.compareTo(method2);
        }
    }
}

