/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.lrmi;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.lrmi.LRMIProxyMonitoringDetailsImpl;
import com.gigaspaces.internal.reflection.IMethod;
import com.gigaspaces.internal.reflection.ProxyInvocationHandler;
import com.gigaspaces.internal.stubcache.MissingCachedStubException;
import com.gigaspaces.internal.stubcache.StubId;
import com.gigaspaces.internal.version.PlatformLogicalVersion;
import com.gigaspaces.internal.version.PlatformVersion;
import com.gigaspaces.lrmi.ClientPeerInvocationHandler;
import com.gigaspaces.lrmi.LRMIInvocationContext;
import com.gigaspaces.lrmi.LRMIInvocationTrace;
import com.gigaspaces.lrmi.LRMIMethod;
import com.gigaspaces.lrmi.LRMIUtilities;
import com.gigaspaces.lrmi.RemoteMethodCache;
import com.gigaspaces.lrmi.ServiceUnsupportedOperationException;
import com.j_spaces.core.exception.internal.InterruptedSpaceException;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

@InternalApi
public class MethodCachedInvocationHandler
implements ProxyInvocationHandler {
    private static final Logger _contextLogger = Logger.getLogger("com.gigaspaces.lrmi.context");
    static final boolean DISABLE_STUB_CACHE = Boolean.getBoolean("com.gs.transport_protocol.lrmi.disable-stub-cache");
    private final RemoteMethodCache _cache;
    private final ClientPeerInvocationHandler _invocationHandler;
    private final String _serverPlatformVersion;
    private final PlatformLogicalVersion _serverPlatformLogicalVersion;
    private final String _connectionURL;
    private int _referencesCount = 1;

    public MethodCachedInvocationHandler(RemoteMethodCache cache, ClientPeerInvocationHandler invocationHandler, String serverPlatformVersion, PlatformLogicalVersion serverPlatformLogicalVersion, String connectionURL) {
        this._cache = cache;
        this._invocationHandler = invocationHandler;
        this._serverPlatformVersion = serverPlatformVersion;
        this._serverPlatformLogicalVersion = serverPlatformLogicalVersion;
        this._connectionURL = connectionURL;
    }

    @Override
    public Object invoke(Object proxy, IMethod method, Object[] args) throws Throwable {
        LRMIMethod lrmiMethod = this._cache.getLRMIMethod(method);
        if (!lrmiMethod.isSupported()) {
            throw new ServiceUnsupportedOperationException("current method [" + method.toString() + "] is not supported by the remote stub, possibly due to older version of the stub. local version [OfficialVersion=" + PlatformVersion.getOfficialVersion() + " " + PlatformLogicalVersion.getLogicalVersion() + "] remote stub version [OfficialVersion=" + this._serverPlatformVersion + " " + this._serverPlatformLogicalVersion + "] connectionURL=" + this._connectionURL, PlatformVersion.getOfficialVersion(), this._serverPlatformVersion, PlatformLogicalVersion.getLogicalVersion(), this._serverPlatformLogicalVersion);
        }
        try {
            this.setLRMIInvocationContext(method, args, lrmiMethod);
            try {
                Object object = this._invocationHandler.invoke(proxy, lrmiMethod, args);
                return object;
            }
            catch (MissingCachedStubException ex) {
                Object object;
                try {
                    LRMIInvocationContext.updateContext(null, (LRMIInvocationContext.ProxyWriteType)LRMIInvocationContext.ProxyWriteType.CACHED_FULL, (LRMIInvocationContext.InvocationStage)LRMIInvocationContext.InvocationStage.CLIENT_SEND_REQUEST, null, null, (boolean)false, null, null);
                    object = this._invocationHandler.invoke(proxy, lrmiMethod, args);
                }
                catch (IOException ex2) {
                    if (Thread.interrupted()) {
                        String exMessage = "Thread was interrupted while waiting on the network";
                        InterruptedException ie = new InterruptedException(exMessage);
                        ie.initCause(ex2);
                        if (MethodCachedInvocationHandler.throwsException(lrmiMethod.realMethod, InterruptedException.class)) {
                            throw ie;
                        }
                        throw new InterruptedSpaceException(exMessage, ie);
                    }
                    throw ex2;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                LRMIInvocationContext.restoreContext();
                return object;
            }
        }
        finally {
            LRMIInvocationContext.restoreContext();
        }
    }

    private void setLRMIInvocationContext(IMethod method, Object[] args, LRMIMethod lrmiMethod) {
        LRMIInvocationTrace trace = _contextLogger.isLoggable(Level.FINE) ? new LRMIInvocationTrace(LRMIUtilities.getMethodDisplayString(method), args, null, true) : null;
        LRMIInvocationContext.ProxyWriteType proxyWriteType = DISABLE_STUB_CACHE ? LRMIInvocationContext.ProxyWriteType.UNCACHED : LRMIInvocationContext.ProxyWriteType.CACHED_LIGHT;
        Boolean useStubCache = lrmiMethod.useStubCache ? Boolean.TRUE : Boolean.FALSE;
        LRMIInvocationContext.updateContext((LRMIInvocationTrace)trace, (LRMIInvocationContext.ProxyWriteType)proxyWriteType, (LRMIInvocationContext.InvocationStage)LRMIInvocationContext.InvocationStage.CLIENT_SEND_REQUEST, null, (PlatformLogicalVersion)this._serverPlatformLogicalVersion, (boolean)true, (Boolean)useStubCache, null);
    }

    private static boolean throwsException(IMethod method, Class<?> exceptionClass) {
        Class[] exceptionClasses;
        for (Class c : exceptionClasses = method.getExceptionTypes()) {
            if (!exceptionClass.isAssignableFrom(c)) continue;
            return true;
        }
        return false;
    }

    public StubId getStubId() {
        throw new UnsupportedOperationException();
    }

    public ClientPeerInvocationHandler getInvocationHandler() {
        return this._invocationHandler;
    }

    public void disable() {
        this._invocationHandler.disable();
    }

    public void enable() {
        this._invocationHandler.enable();
    }

    public boolean decrementReference() {
        boolean lastReferent;
        boolean bl = lastReferent = --this._referencesCount == 0;
        if (lastReferent) {
            this._invocationHandler.close();
        }
        return lastReferent;
    }

    public void incrementReference() {
        ++this._referencesCount;
    }

    public LRMIProxyMonitoringDetailsImpl getMonitoringDetails() {
        return this._invocationHandler.getMonitoringDetails();
    }

    public String getConnectionURL() {
        return this._connectionURL;
    }
}

