/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.lrmi;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.lrmi.LRMIMethod;
import com.gigaspaces.lrmi.ServerPeer;
import java.rmi.NoSuchObjectException;
import java.rmi.Remote;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentHashMap;

@InternalApi
public class ObjectRegistry {
    private final ConcurrentHashMap<Remote, Entry> _objMap = new ConcurrentHashMap();
    private final ConcurrentHashMap<Long, Entry> _objIdMap = new ConcurrentHashMap();

    public boolean isLastRegistrar(String protocol) {
        if (this._objMap.isEmpty()) {
            return true;
        }
        ArrayList<Entry> entryValue = new ArrayList<Entry>(this._objMap.values());
        for (Entry e : entryValue) {
            if (!e._protocol.equals(protocol)) continue;
            return false;
        }
        return true;
    }

    public Entry createEntry(Remote object, long objectId, LRMIMethod[] lrmiMethods) {
        Entry entry = new Entry(object, objectId, lrmiMethods);
        this._objMap.put(object, entry);
        this._objIdMap.put(objectId, entry);
        return entry;
    }

    public Entry getEntryFromObject(Object object) {
        return this._objMap.get(object);
    }

    public Entry getEntryFromObjectIdIfExists(long objectId) {
        return this._objIdMap.get(objectId);
    }

    public Entry getEntryFromObjectId(long objectId) throws NoSuchObjectException {
        Entry entry = this._objIdMap.get(objectId);
        if (entry == null) {
            throw new NoSuchObjectException("Object " + objectId + " not found in object registry");
        }
        return entry;
    }

    public void removeEntry(Remote object) {
        Entry entry = this._objMap.remove(object);
        this._objIdMap.remove(entry.m_ObjectId);
    }

    public void clear() {
        this._objMap.clear();
        this._objIdMap.clear();
    }

    public static class Entry {
        public final Remote m_Object;
        public final long m_ObjectId;
        private String _protocol;
        private ServerPeer _serverPeer;
        private final ClassLoader _exportedThreadClassLoader;
        private final LRMIMethod[] _methodList;

        public Entry(Remote object, long objectId, LRMIMethod[] lrmiMethods) {
            this.m_Object = object;
            this.m_ObjectId = objectId;
            this._methodList = lrmiMethods;
            this._exportedThreadClassLoader = Thread.currentThread().getContextClassLoader();
        }

        public void setProtocol(String protocol) {
            this._protocol = protocol;
        }

        public void setServerPeer(ServerPeer serverPeer) {
            this._serverPeer = serverPeer;
        }

        public ServerPeer getServerPeer() {
            return this._serverPeer;
        }

        public String getProtocol() {
            return this._protocol;
        }

        public final ClassLoader getExportedThreadClassLoader() {
            return this._exportedThreadClassLoader;
        }

        public final Remote getObject() {
            return this.m_Object;
        }

        public LRMIMethod[] getMethodList() {
            return this._methodList;
        }

        public String toString() {
            return "Entry [ExportedThreadClassLoader=" + this._exportedThreadClassLoader + ", Object=" + this.m_Object + ", ObjectId=" + this.m_ObjectId + ", Protocol=" + this._protocol + ", ServerPeer=" + this._serverPeer + ", methodList=" + this._methodList + "]";
        }
    }
}

