/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.lrmi;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.reflection.IMethod;
import java.rmi.Remote;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

@InternalApi
public class OneWayMethodRepository {
    private static final Logger _logger = Logger.getLogger("com.gigaspaces.lrmi");
    private static final Set<IMethod> _repositoryTable = Collections.synchronizedSet(new HashSet());

    public static void register(IMethod method) throws IllegalArgumentException {
        if (!method.getDeclaringClass().isInterface()) {
            throw new IllegalArgumentException("The declaring class [" + method.getDeclaringClass() + "] of [" + method + "] method must be Remote interface.");
        }
        if (!Remote.class.isAssignableFrom(method.getDeclaringClass())) {
            throw new IllegalArgumentException("The declaring class [" + method.getDeclaringClass() + "] of [" + method + "] method must extends from java.rmi.Remote interface.");
        }
        _repositoryTable.add(method);
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("OneWayMethodRepository - registered one-way method: " + method);
        }
    }

    public static boolean isOneWay(IMethod method) {
        return _repositoryTable.contains(method);
    }
}

