/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.lrmi;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.config.ConfigurationException;
import com.gigaspaces.config.lrmi.ITransportConfig;
import com.gigaspaces.lrmi.LRMIMonitoringDetails;
import com.gigaspaces.lrmi.ProtocolAdapter;
import com.j_spaces.kernel.ClassLoaderHelper;
import java.util.HashMap;

@InternalApi
public class ProtocolRegistry
extends HashMap<String, ProtocolAdapter<?>> {
    private static final long serialVersionUID = 1L;

    public synchronized void init(ITransportConfig config, ProtocolAdapter.Side initSide) throws ConfigurationException {
        String adapterName = config.getProtocolName();
        String adapterClass = config.getProtocolAdaptorClass();
        try {
            ProtocolAdapter adapter = (ProtocolAdapter)this.get(adapterName);
            if (adapter == null) {
                adapter = (ProtocolAdapter)ClassLoaderHelper.loadClass(adapterClass).newInstance();
                adapter.init(config, initSide);
                this.put(adapterName, adapter);
            } else {
                adapter.init(config, initSide);
            }
        }
        catch (Exception ex) {
            throw new ConfigurationException("Failed to init. Protocol Registry: " + adapterClass, ex);
        }
    }

    public int getPort(ITransportConfig config) {
        return ((ProtocolAdapter)this.get(config.getProtocolName())).getPort();
    }

    public LRMIMonitoringDetails getMonitoringDetails(ITransportConfig config) {
        return ((ProtocolAdapter)this.get(config.getProtocolName())).getMonitoringDetails();
    }
}

