/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.lrmi;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.reflection.IMethod;
import com.gigaspaces.lrmi.LRMIMethod;
import com.gigaspaces.lrmi.LRMIUtilities;
import java.rmi.UnexpectedException;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;

@InternalApi
public class RemoteMethodCache {
    private final HashMap<IMethod, LRMIMethod> methodMap;
    private IdentityHashMap<IMethod, LRMIMethod> identityMethodMap = new IdentityHashMap();

    public RemoteMethodCache(LRMIMethod[] lrmiMethodList) {
        this.methodMap = new HashMap(lrmiMethodList.length);
        for (int i = 0; i < lrmiMethodList.length; ++i) {
            this.methodMap.put(lrmiMethodList[i].realMethod, lrmiMethodList[i]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LRMIMethod getLRMIMethod(IMethod method) {
        LRMIMethod lrmiMethod = this.identityMethodMap.get(method);
        if (lrmiMethod != null) {
            return lrmiMethod;
        }
        RemoteMethodCache remoteMethodCache = this;
        synchronized (remoteMethodCache) {
            lrmiMethod = this.identityMethodMap.get(method);
            if (lrmiMethod != null) {
                return lrmiMethod;
            }
            lrmiMethod = this.methodMap.get(method);
            if (lrmiMethod == null) {
                String invokedMethod = LRMIUtilities.getMethodNameAndDescriptor(method);
                for (Map.Entry<IMethod, LRMIMethod> cacheMethod : this.methodMap.entrySet()) {
                    String cachedMethodDesc = LRMIUtilities.getMethodNameAndDescriptor(cacheMethod.getKey());
                    if (!cachedMethodDesc.equals(invokedMethod)) continue;
                    lrmiMethod = cacheMethod.getValue();
                    break;
                }
                if (lrmiMethod == null) {
                    UnexpectedException ex = new UnexpectedException("Failed to invoke remote method: [" + method + "]. This method was never introduced by transport protocol. \nMethod ClassLoader: " + method.getDeclaringClass().getClassLoader());
                    throw new RuntimeException(ex);
                }
            }
            IdentityHashMap cloneMap = (IdentityHashMap)this.identityMethodMap.clone();
            cloneMap.put(method, lrmiMethod);
            this.identityMethodMap = cloneMap;
        }
        return lrmiMethod;
    }
}

