/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.lrmi;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.stubcache.StubId;
import com.gigaspaces.internal.version.PlatformLogicalVersion;
import com.gigaspaces.lrmi.DynamicSmartStub;
import com.gigaspaces.lrmi.ILRMIProxy;
import com.gigaspaces.lrmi.LRMIMethodMetadata;
import com.gigaspaces.lrmi.LRMIUtilities;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.net.InetSocketAddress;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;

@InternalApi
public class RemoteStub<T>
implements Remote,
Externalizable,
ILRMIProxy {
    static final long serialVersionUID = 1L;
    private static final Logger _logger = Logger.getLogger("com.gigaspaces.lrmi");
    private T _dynamicProxy;
    private transient T _directObjRef;

    public RemoteStub() {
    }

    public RemoteStub(T directObjRef, T dynamicProxy) {
        if (dynamicProxy == null) {
            throw new IllegalArgumentException("Failed to initialize " + this.getClass() + " stub. DynamicProxy argument can not be null");
        }
        this._directObjRef = directObjRef;
        this._dynamicProxy = dynamicProxy;
    }

    public T getProxy() {
        return this._directObjRef != null ? this._directObjRef : this._dynamicProxy;
    }

    public T getDynamicProxy() {
        return this._dynamicProxy;
    }

    public boolean isDirect() {
        return this._directObjRef != null;
    }

    protected static void init(Callable initCall) {
        block2: {
            try {
                initCall.call();
            }
            catch (Exception ex) {
                if (!_logger.isLoggable(Level.SEVERE)) break block2;
                _logger.log(Level.SEVERE, "Failed to initialize remote stub.", ex);
            }
        }
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof RemoteStub) {
            RemoteStub targetRemoteStub = (RemoteStub)obj;
            return this.getProxy().equals(targetRemoteStub.getProxy());
        }
        return false;
    }

    public int hashCode() {
        return this.getProxy().hashCode();
    }

    public String toString() {
        return this.getProxy().toString();
    }

    public static boolean isStub(Object obj) {
        return obj instanceof RemoteStub;
    }

    public boolean isCollocated() {
        if (this._directObjRef != null) {
            return true;
        }
        DynamicSmartStub dynSmartStub = DynamicSmartStub.extractDynamicSmartStubFrom(this._dynamicProxy);
        if (dynSmartStub != null) {
            return dynSmartStub.isCollocated();
        }
        return false;
    }

    public static boolean isCollocatedStub(Object obj) {
        return RemoteStub.isStub(obj) ? ((RemoteStub)obj).isCollocated() : false;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this._dynamicProxy);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this._dynamicProxy = in.readObject();
        DynamicSmartStub dynSmartStub = DynamicSmartStub.extractDynamicSmartStubFrom(this._dynamicProxy);
        if (dynSmartStub != null) {
            this._directObjRef = dynSmartStub.getLocalObjImpl();
        }
    }

    @Override
    public PlatformLogicalVersion getServicePlatformLogicalVersion() {
        if (this._directObjRef != null) {
            return PlatformLogicalVersion.getLogicalVersion();
        }
        return LRMIUtilities.getServicePlatformLogicalVersion(this._dynamicProxy);
    }

    @Override
    public boolean isRemote() {
        return !this.isDirect();
    }

    @Override
    public StubId getStubId() {
        if (this._dynamicProxy != null && this._dynamicProxy instanceof ILRMIProxy) {
            return ((ILRMIProxy)this._dynamicProxy).getStubId();
        }
        return null;
    }

    @Override
    public long getGeneratedTraffic() {
        if (this._dynamicProxy != null && this._dynamicProxy instanceof ILRMIProxy) {
            return ((ILRMIProxy)this._dynamicProxy).getGeneratedTraffic();
        }
        return 0L;
    }

    @Override
    public long getReceivedTraffic() {
        if (this._dynamicProxy != null && this._dynamicProxy instanceof ILRMIProxy) {
            return ((ILRMIProxy)this._dynamicProxy).getReceivedTraffic();
        }
        return 0L;
    }

    @Override
    public String getConnectionUrl() {
        if (this._dynamicProxy != null && this._dynamicProxy instanceof ILRMIProxy) {
            return ((ILRMIProxy)this._dynamicProxy).getConnectionUrl();
        }
        return null;
    }

    @Override
    public long getRemoteProcessId() {
        if (this._dynamicProxy != null && this._dynamicProxy instanceof ILRMIProxy) {
            return ((ILRMIProxy)this._dynamicProxy).getRemoteProcessId();
        }
        return -1L;
    }

    @Override
    public String getRemoteHostName() {
        if (this._dynamicProxy != null && this._dynamicProxy instanceof ILRMIProxy) {
            return ((ILRMIProxy)this._dynamicProxy).getRemoteHostName();
        }
        return null;
    }

    @Override
    public String getRemoteHostAddress() {
        if (this._dynamicProxy != null && this._dynamicProxy instanceof ILRMIProxy) {
            return ((ILRMIProxy)this._dynamicProxy).getRemoteHostAddress();
        }
        return null;
    }

    @Override
    public InetSocketAddress getRemoteNetworkAddress() {
        if (this._dynamicProxy != null && this._dynamicProxy instanceof ILRMIProxy) {
            return ((ILRMIProxy)this._dynamicProxy).getRemoteNetworkAddress();
        }
        return null;
    }

    @Override
    public void disable() throws RemoteException {
        if (this._dynamicProxy != null && this._dynamicProxy instanceof ILRMIProxy) {
            ((ILRMIProxy)this._dynamicProxy).disable();
        }
    }

    @Override
    public void enable() throws RemoteException {
        if (this._dynamicProxy != null && this._dynamicProxy instanceof ILRMIProxy) {
            ((ILRMIProxy)this._dynamicProxy).enable();
        }
    }

    @Override
    public void overrideMethodsMetadata(Map<String, LRMIMethodMetadata> methodsMetadata) {
        if (this._dynamicProxy != null && this._dynamicProxy instanceof ILRMIProxy) {
            ((ILRMIProxy)this._dynamicProxy).overrideMethodsMetadata(methodsMetadata);
        }
    }

    @Override
    public void closeProxy() {
        if (this._dynamicProxy != null && this._dynamicProxy instanceof ILRMIProxy) {
            ((ILRMIProxy)this._dynamicProxy).closeProxy();
        }
    }

    @Override
    public boolean isClosed() {
        if (this._dynamicProxy != null && this._dynamicProxy instanceof ILRMIProxy) {
            return ((ILRMIProxy)this._dynamicProxy).isClosed();
        }
        return true;
    }
}

