/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.lrmi;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.io.ISmartLengthBasedCacheCallback;
import com.gigaspaces.internal.io.SmartLengthBasedCache;
import java.nio.ByteBuffer;

@InternalApi
public class SmartByteBufferCache
extends SmartLengthBasedCache<ByteBuffer> {
    private static final int DEFAULT_BUFFER_LENGTH = 32;

    public static SmartByteBufferCache getDefaultSmartByteBufferCache() {
        int maxCachedBufferLength = Integer.getInteger("com.gs.transport_protocol.lrmi.cache.buffer-size", 0x3200000);
        double expungeRatio = Double.parseDouble(System.getProperty("com.gs.transport_protocol.lrmi.cache.buffer-expunge-ratio", String.valueOf(0.5)));
        int expungeCount = Integer.getInteger("com.gs.transport_protocol.lrmi.cache.buffer-expunge-times-threshold", 20);
        return new SmartByteBufferCache(maxCachedBufferLength, expungeRatio, expungeCount, null);
    }

    public SmartByteBufferCache(int maxCachedBufferLength, double expungeRatio, int expungeCount, ISmartLengthBasedCacheCallback callback) {
        super(maxCachedBufferLength, expungeRatio, expungeCount, 32, callback);
    }

    @Override
    protected ByteBuffer createResource(int length) {
        return ByteBuffer.allocate(length);
    }

    @Override
    protected void prepareResource(ByteBuffer resource) {
        resource.clear();
    }

    @Override
    protected void prepareResource(ByteBuffer resource, int length) {
        resource.clear();
        resource.limit(length);
    }

    @Override
    protected int getResourceCapacity(ByteBuffer resource) {
        return resource.capacity();
    }
}

