/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.lrmi.classloading;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.classloader.ClassLoaderCache;
import com.gigaspaces.internal.reflection.ReflectionUtil;
import com.gigaspaces.logger.TraceableLogger;
import com.gigaspaces.lrmi.classloading.IClassProvider;
import com.gigaspaces.lrmi.classloading.LRMIClassLoadersHolder;
import com.gigaspaces.lrmi.classloading.ServiceClassLoaderContext;
import com.j_spaces.kernel.ClassLoaderHelper;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.rmi.RemoteException;
import java.util.logging.Level;

@InternalApi
public class DefaultClassProvider
implements IClassProvider {
    private static final TraceableLogger _logger = TraceableLogger.getLogger((String)"com.gigaspaces.lrmi.classloading");
    private static final long EXPORT_DISABLED_MARKER = -1L;
    private static final long NULL_CLASS_LOADER_MARKER = -2L;
    private final String _identifier;
    private final boolean _enabled;

    public DefaultClassProvider(String identifier) {
        this._identifier = identifier;
        boolean bl = this._enabled = Boolean.parseBoolean(System.getProperty("com.gs.transport_protocol.lrmi.classloading", "true")) && Boolean.parseBoolean(System.getProperty("com.gs.transport_protocol.lrmi.classloading.export", "true"));
        if (this._enabled) {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine(this.toString() + " LRMI class exporting enabled");
            }
        } else if (_logger.isLoggable(Level.FINE)) {
            _logger.fine(this.toString() + " LRMI class exporting disabled");
        }
        if (this._enabled && _logger.isLoggable(Level.FINEST)) {
            _logger.finest(this.toString() + " class provider initialized");
        }
    }

    @Override
    public byte[] getClassDefinition(long id, String className) throws ClassNotFoundException {
        try {
            ServiceClassLoaderContext serviceClassLoaderContext;
            ClassLoader loader;
            if (!this._enabled) {
                throw new ClassNotFoundException(this.toString() + " LRMI class exporting is disabled");
            }
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine(this.toString() + " retrieving class definition [" + className + "] from class loader id " + id);
            }
            if ((loader = this.getClassLoaderInternal(id)) == null) {
                throw new ClassNotFoundException(this.toString() + " unknown class loader id [" + id + "]");
            }
            String resourceName = className.replace('.', '/').concat(".class");
            InputStream stream = loader.getResourceAsStream(resourceName);
            if (stream != null) {
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.fine(this.toString() + " class definition [" + className + "] found at class loader id " + id);
                }
                return this.toByteArray(stream);
            }
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.finest(this.toString() + " class definition [" + className + "] not found at class loader id " + id + ", trying lrmi class loaders that belong to the specified class loader");
            }
            if ((serviceClassLoaderContext = LRMIClassLoadersHolder.getServiceClassLoaderContext(loader)) != null) {
                byte[] classBytes = serviceClassLoaderContext.getClassBytes(className);
                if (classBytes != null) {
                    if (_logger.isLoggable(Level.FINE)) {
                        _logger.fine(this.toString() + " class definition [" + className + "] found at LRMIClassLoaders decedents of class loader id " + id);
                    }
                    return classBytes;
                }
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.fine(this.toString() + " could not locate required class [" + className + "] at the specified class loader [" + id + "]");
                }
            } else if (_logger.isLoggable(Level.FINE)) {
                _logger.fine(this.toString() + " could not locate required class [" + className + "], no service context class loader exists for the specified class loader id [" + id + "]");
            }
            throw new ClassNotFoundException(this.toString() + " could not locate required class [" + className + "] at the specified class loader [" + id + "]");
        }
        catch (IOException e) {
            throw new ClassNotFoundException(this.toString() + " class definition of " + className + " was not found at the specified class loader [" + id + "]", e);
        }
    }

    @Override
    public byte[] getResource(long id, String resourceName) throws RemoteException {
        try {
            ServiceClassLoaderContext serviceClassLoaderContext;
            ClassLoader loader;
            if (!this._enabled) {
                throw new RemoteException(this.toString() + " LRMI class exporting is disabled");
            }
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine(this.toString() + " retrieving resource [" + resourceName + "] class loader id " + id);
            }
            if ((loader = this.getClassLoaderInternal(id)) == null) {
                throw new RemoteException(this.toString() + " unknown class loader id [" + id + "]");
            }
            InputStream stream = loader.getResourceAsStream(resourceName);
            if (stream != null) {
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.fine(this.toString() + " resource [" + resourceName + "] found at class loader id " + id);
                }
                return this.toByteArray(stream);
            }
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.finest(this.toString() + " resource [" + resourceName + "] not found at class loader id " + id + ", trying lrmi class loaders that belong to the specified class loader");
            }
            if ((serviceClassLoaderContext = LRMIClassLoadersHolder.getServiceClassLoaderContext(loader)) != null) {
                byte[] classBytes = serviceClassLoaderContext.getClassBytes(resourceName);
                if (classBytes != null) {
                    if (_logger.isLoggable(Level.FINE)) {
                        _logger.fine(this.toString() + " resource [" + resourceName + "] found at LRMIClassLoader's descendant of class loader id " + id);
                    }
                    return classBytes;
                }
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.fine(this.toString() + " could not locate required resource [" + resourceName + "] at the specified class loader [" + id);
                }
            } else if (_logger.isLoggable(Level.FINE)) {
                _logger.fine(this.toString() + " could not locate required resource [" + resourceName + "], no service context class loader exists for the specified class loader id [" + id + "]");
            }
            return null;
        }
        catch (IOException e) {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, this.toString() + " exception caught while locating resource [" + resourceName + "] at the specified class loader [" + id + "]", (Throwable)e);
            }
            return null;
        }
    }

    @Override
    public long putClassLoader(ClassLoader classLoader) {
        if (!this._enabled) {
            return -1L;
        }
        if (classLoader == null) {
            return -2L;
        }
        return ClassLoaderCache.getCache().putClassLoader(classLoader);
    }

    public String toString() {
        return "DefaultClassProvider [" + this._identifier + "]";
    }

    private ClassLoader getClassLoaderInternal(long id) {
        ClassLoader contextClassLoader;
        if (!this._enabled) {
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.finest(this.toString() + " class exporting is disabled");
            }
            return null;
        }
        if (id == -2L) {
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.finest(this.toString() + " using DefaultClassProvider class loading class loader as the class loader");
            }
            return DefaultClassProvider.class.getClassLoader();
        }
        ClassLoader classLoader = ClassLoaderCache.getCache().getClassLoader(id);
        if (classLoader != null) {
            return classLoader;
        }
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest(this.toString() + " no class loader found with id [" + id + "], using context class loader instead");
        }
        if ((contextClassLoader = ClassLoaderHelper.getContextClassLoader()) != null) {
            return contextClassLoader;
        }
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest(this.toString() + " no context class loader found, using default class loader");
        }
        return ReflectionUtil.class.getClassLoader();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] toByteArray(InputStream stream) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream(4096);
        try {
            byte[] buffer = new byte[4096];
            int bytesRead = -1;
            while ((bytesRead = stream.read(buffer)) != -1) {
                out.write(buffer, 0, bytesRead);
            }
            out.flush();
        }
        finally {
            try {
                stream.close();
            }
            catch (IOException iOException) {}
            try {
                out.close();
            }
            catch (IOException iOException) {}
        }
        return out.toByteArray();
    }

    public void clearClassLoader(ClassLoader classLoader) throws RemoteException {
    }
}

