/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.lrmi.classloading;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.logger.TraceableLogger;
import com.gigaspaces.lrmi.classloading.ClassLoaderUtility;
import com.gigaspaces.lrmi.classloading.IClassProvider;
import com.gigaspaces.lrmi.classloading.IRemoteClassProviderProvider;
import com.gigaspaces.lrmi.classloading.LRMIRemoteClassLoaderIdentifier;
import com.gigaspaces.lrmi.classloading.ServiceClassLoaderContext;
import com.gigaspaces.lrmi.classloading.protocol.lrmi.LRMIConnection;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.rmi.ConnectException;
import java.rmi.RemoteException;
import java.util.logging.Level;
import org.jini.rio.boot.LoggableClassLoader;

@InternalApi
public class LRMIClassLoader
extends URLClassLoader
implements LoggableClassLoader {
    private static final TraceableLogger _logger = TraceableLogger.getLogger((String)"com.gigaspaces.lrmi.classloading");
    public static final boolean FAIL_TO_CURRENT_CONNECTION_CLASS_LOADER = Boolean.valueOf(System.getProperty("com.gs.lrmi.failToGetClassBytesFromActiveConnection", String.valueOf(true)));
    private final IClassProvider _remoteClassProvider;
    private final long _remoteClassLoaderId;
    private final long _remoteRemoteLrmiId;
    private final ServiceClassLoaderContext _serviceClassLoaderContext;

    public LRMIClassLoader(IClassProvider classProvider, ClassLoader parent, ServiceClassLoaderContext serviceClassLoaderContext, long remoteRemoteLrmiId, long remoteClassLoaderId) {
        super(new URL[0], parent);
        this._remoteClassProvider = classProvider;
        this._serviceClassLoaderContext = serviceClassLoaderContext;
        this._remoteRemoteLrmiId = remoteRemoteLrmiId;
        this._remoteClassLoaderId = remoteClassLoaderId;
    }

    @Override
    protected Class<?> findClass(String className) throws ClassNotFoundException {
        ServiceClassLoaderContext serviceClassLoaderContext = this._serviceClassLoaderContext;
        synchronized (serviceClassLoaderContext) {
            try {
                byte[] definition;
                LRMIClassLoader brotherClassLoader;
                Class<?> loadedClass;
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.fine(this.toString() + " trying to find class: " + className);
                }
                if (_logger.isLoggable(Level.FINEST)) {
                    _logger.finest(this.toString() + " trying to find class locally: " + className);
                }
                if ((loadedClass = this.findLoadedClass(className)) != null) {
                    if (_logger.isLoggable(Level.FINE)) {
                        _logger.fine(this.toString() + " class found locally: " + className);
                    }
                    return loadedClass;
                }
                if (_logger.isLoggable(Level.FINEST)) {
                    _logger.finest(this.toString() + " failed previous attempt, trying to find class at the service context class loaders: " + className);
                }
                if ((brotherClassLoader = this._serviceClassLoaderContext.getClassLoaderByClassName(className)) != null) {
                    if (_logger.isLoggable(Level.FINE)) {
                        _logger.fine(this.toString() + " class found at the service context class loader [" + brotherClassLoader + "]: " + className);
                    }
                    return brotherClassLoader.findClass(className);
                }
                if (_logger.isLoggable(Level.FINEST)) {
                    _logger.finest(this.toString() + " failed previous attempt, trying to retrieve class remotely using the class provider class: " + className);
                }
                try {
                    definition = this._remoteClassProvider.getClassDefinition(this._remoteClassLoaderId, className);
                }
                catch (ConnectException e) {
                    _logger.finest(this.toString() + " failed to retrieve class [" + className + "] remotely from [" + this._remoteClassProvider + "] with _remoteClassLoaderId [" + this._remoteClassLoaderId + "] due to connection exception");
                    definition = this.loadBytesFromCurrentConnection(className);
                }
                catch (ClassNotFoundException e) {
                    _logger.finest(this.toString() + " failed to retrieve class [" + className + "] remotely from [" + this._remoteClassProvider + "] with _remoteClassLoaderId [" + this._remoteClassLoaderId + "] due to class not found exception");
                    definition = this.loadBytesFromCurrentConnection(className);
                }
                if (definition == null) {
                    if (_logger.isLoggable(Level.FINE)) {
                        _logger.fine(this.toString() + " failed to get class definition from its remote class provider: " + className);
                    }
                    throw new ClassNotFoundException("class " + className + " not found");
                }
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.fine(this.toString() + " class found remotely using the class provider class: " + className);
                }
                return this.defineClass(className, definition);
            }
            catch (RemoteException e) {
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.log(Level.FINE, this.toString() + " exception caught while retrieving class definition from remote class provider: " + className, (Throwable)e);
                }
                throw new ClassNotFoundException("class " + className + " not found", e);
            }
            catch (ClassNotFoundException e) {
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.log(Level.FINE, this.toString() + " ClassNotFoundException caught while retrieving class definition from remote class provider: " + className, (Throwable)e);
                }
                throw e;
            }
        }
    }

    private byte[] loadBytesFromCurrentConnection(String className) {
        try {
            if (!FAIL_TO_CURRENT_CONNECTION_CLASS_LOADER) {
                return null;
            }
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine(this.toString() + " attempting to load class: " + className + " from current connection remote class provider");
            }
            IRemoteClassProviderProvider classProviderProvider = LRMIConnection.getClassProviderProvider();
            LRMIRemoteClassLoaderIdentifier id = classProviderProvider.getRemoteClassLoaderIdentifier();
            IClassProvider classProvider = classProviderProvider.getClassProvider();
            return classProvider.getClassDefinition(id.getRemoteClassLoaderId(), className);
        }
        catch (Exception e) {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine(this.toString() + " failed to get class definition from current remote class provider: " + className);
            }
            return null;
        }
    }

    private Class<?> defineClass(String className, byte[] definition) throws ClassFormatError {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine(this.toString() + " defining class: " + className);
        }
        try {
            Class<?> defineClass = this.defineClass(className, definition, 0, definition.length);
            LRMIClassLoader previousClassLoader = this._serviceClassLoaderContext.putClassBytesAndLoader(className, this, definition);
            if (previousClassLoader != null) {
                throw new IllegalStateException("Class: " + className + " is already loaded in this service by LRMIClassLoader " + previousClassLoader);
            }
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.finest("Defined class [" + className + "], it's class-loader hierarchy is " + ClassLoaderUtility.getClassLoaderHierarchy(defineClass.getClassLoader()));
            }
            return defineClass;
        }
        catch (ClassFormatError e) {
            if (_logger.isLoggable(Level.SEVERE)) {
                _logger.log(Level.SEVERE, this.toString() + " class format error caught while defining class: " + className, (Throwable)e);
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream getResourceAsStream(String resourceName) {
        ServiceClassLoaderContext serviceClassLoaderContext = this._serviceClassLoaderContext;
        synchronized (serviceClassLoaderContext) {
            block15: {
                try {
                    byte[] resource;
                    if (_logger.isLoggable(Level.FINE)) {
                        _logger.fine(this.toString() + " trying to get resource as stream from service context: " + resourceName);
                    }
                    if ((resource = this._serviceClassLoaderContext.getClassBytes(resourceName)) == null) {
                        if (_logger.isLoggable(Level.FINE)) {
                            _logger.fine(this.toString() + " failed previous attempt, trying to get resource remotely from class provider class: " + resourceName);
                        }
                        if ((resource = this._remoteClassProvider.getResource(this._remoteClassLoaderId, resourceName)) != null) {
                            if (_logger.isLoggable(Level.FINE)) {
                                _logger.fine(this.toString() + " resource stream found at service context: " + resourceName);
                            }
                            this._serviceClassLoaderContext.storeClassBytes(resourceName, resource);
                        }
                    }
                    if (resource != null) {
                        if (_logger.isLoggable(Level.FINE)) {
                            _logger.fine(this.toString() + " resource stream found locally: " + resourceName);
                        }
                        return new ByteArrayInputStream(resource);
                    }
                    resource = this.loadResourceFromCurrentConnection(resourceName);
                    if (resource != null) {
                        if (_logger.isLoggable(Level.FINE)) {
                            _logger.fine(this.toString() + " resource stream found using current lrmi connection: " + resourceName);
                        }
                        this._serviceClassLoaderContext.storeClassBytes(resourceName, resource);
                        return new ByteArrayInputStream(resource);
                    }
                    if (_logger.isLoggable(Level.FINE)) {
                        _logger.fine(this.toString() + " Failed getting resource from remote class provider: " + resourceName);
                    }
                }
                catch (RemoteException e) {
                    if (!_logger.isLoggable(Level.FINE)) break block15;
                    _logger.log(Level.FINE, this.toString() + " Exception caught while getting resource from remote class provider: " + resourceName, (Throwable)e);
                }
            }
            return null;
        }
    }

    private byte[] loadResourceFromCurrentConnection(String resourceName) {
        try {
            if (!FAIL_TO_CURRENT_CONNECTION_CLASS_LOADER) {
                return null;
            }
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine(this.toString() + " attempting to load resource: " + resourceName + " from current connection remote class provider");
            }
            IRemoteClassProviderProvider classProviderProvider = LRMIConnection.getClassProviderProvider();
            LRMIRemoteClassLoaderIdentifier id = classProviderProvider.getRemoteClassLoaderIdentifier();
            IClassProvider classProvider = classProviderProvider.getClassProvider();
            return classProvider.getResource(id.getRemoteClassLoaderId(), resourceName);
        }
        catch (Exception e) {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine(this.toString() + " failed to get resource definition from current remote class provider: " + resourceName);
            }
            return null;
        }
    }

    public String toString() {
        return this.getLogName();
    }

    public String getLogName() {
        return "LRMIClassLoader [remote lrmi runtime id = " + this._remoteRemoteLrmiId + ", remote class loader id = " + this._remoteClassLoaderId + "] " + super.toString();
    }

    public Class<?> getLoadedClass(String className) throws ClassNotFoundException {
        Class<?> loadedClass = null;
        for (int i = 0; i < 10; ++i) {
            try {
                loadedClass = this.findLoadedClass(className);
                break;
            }
            catch (Throwable t) {
                _logger.log(Level.WARNING, this.toString() + " Failed to find loaded class [" + className + "] attempt = " + i, t);
                continue;
            }
        }
        if (loadedClass != null) {
            return loadedClass;
        }
        throw new ClassNotFoundException("Attempting to get a loaded class which was not previously loaded [" + className + "]");
    }
}

