/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.lrmi.classloading;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.classloader.ClassLoaderCache;
import com.gigaspaces.internal.classloader.IClassLoaderCacheStateListener;
import com.gigaspaces.internal.utils.collections.CopyOnUpdateMap;
import com.gigaspaces.logger.TraceableLogger;
import com.gigaspaces.lrmi.LRMIInvocationContext;
import com.gigaspaces.lrmi.LRMIRuntime;
import com.gigaspaces.lrmi.classloading.IClassProvider;
import com.gigaspaces.lrmi.classloading.LRMIClassLoader;
import com.gigaspaces.lrmi.classloading.LRMIClassLoaderCreationException;
import com.gigaspaces.lrmi.classloading.LRMIRemoteClassLoaderIdentifier;
import com.gigaspaces.lrmi.classloading.ServiceClassLoaderContext;
import com.gigaspaces.lrmi.classloading.protocol.lrmi.LRMIConnection;
import com.gigaspaces.lrmi.nio.filters.IOFilterException;
import com.j_spaces.kernel.ClassLoaderHelper;
import java.io.IOException;
import java.util.logging.Level;
import org.jini.rio.boot.AdditionalClassProviderFactory;
import org.jini.rio.boot.IAdditionalClassProvider;

@InternalApi
public class LRMIClassLoadersHolder {
    private static final CopyOnUpdateMap<Long, ServiceClassLoaderContext> serviceClassLoaderContextMap;
    private static final TraceableLogger _logger;
    private static final boolean enabled;
    private static final Object loadClassLock;
    private static final IClassLoaderCacheStateListener listener;
    private static final ThreadLocal<String> _currentLoadingClass;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Class<?> loadClass(String className) throws ClassNotFoundException {
        Class<?> clazz;
        LRMIClassLoader cl;
        try {
            if (className.equals(_currentLoadingClass.get())) {
                throw new ClassNotFoundException("Could not load " + className + " using LRMI remote class loading");
            }
            _currentLoadingClass.set(className);
            Object object = loadClassLock;
            synchronized (object) {
                if (!enabled) {
                    throw new ClassNotFoundException("LRMI class loading is disabled. Class [" + className + "] not loaded");
                }
                if (_logger.isLoggable(Level.FINE)) {
                    LRMIClassLoadersHolder.logFine("Trying to get class loader for class: " + className + ", context class loader is " + ClassLoaderHelper.getClassLoaderLogName(ClassLoaderHelper.getContextClassLoader()));
                }
                if ((cl = LRMIClassLoadersHolder.getClassLoader(className)) == null) {
                    try {
                        if (_logger.isLoggable(Level.FINEST)) {
                            LRMIClassLoadersHolder.logFinest("no previously created LRMIClassLoader found for class: " + className + " creating new one");
                        }
                        cl = LRMIClassLoadersHolder.createClassLoader(className);
                        if (_logger.isLoggable(Level.FINE)) {
                            LRMIClassLoadersHolder.logFine("trying to load " + className + " using classloader: " + cl);
                        }
                        Class<?> clazz2 = Class.forName(className, true, cl);
                        // MONITOREXIT @DISABLED, blocks:[0, 2, 5, 15] lbl19 : MonitorExitStatement: MONITOREXIT : var1_1
                        _currentLoadingClass.remove();
                        return clazz2;
                    }
                    catch (LRMIClassLoaderCreationException e) {
                        throw new ClassNotFoundException("Exception caught while trying to create LRMIClassLoader for class [" + className + "]", e);
                    }
                }
            }
        }
        catch (Throwable throwable) {
            _currentLoadingClass.remove();
            throw throwable;
        }
        {
            if (_logger.isLoggable(Level.FINEST)) {
                LRMIClassLoadersHolder.logFinest("Found previously created LRMIClassLoader for class: " + className + " using classloader: " + cl);
            }
            if (_logger.isLoggable(Level.FINE)) {
                LRMIClassLoadersHolder.logFine("trying to load " + className + " using classloader: " + cl);
            }
            clazz = Class.forName(className, true, cl);
        }
        _currentLoadingClass.remove();
        return clazz;
    }

    public static Class<?> loadClassFromExistingOnly(String className) throws ClassNotFoundException {
        if (!enabled) {
            throw new ClassNotFoundException("LRMI class loading is disabled. Class [" + className + "] not loaded");
        }
        ServiceClassLoaderContext classLoaderContext = LRMIClassLoadersHolder.getServiceClassLoaderContextExistingOnly();
        if (classLoaderContext == null) {
            throw new ClassNotFoundException("No service class loader context associated with the current class loader " + ClassLoaderHelper.getClassLoaderLogName(Thread.currentThread().getContextClassLoader()) + ". Class [" + className + "] not loaded");
        }
        LRMIClassLoader lrmiClassLoader = classLoaderContext.getClassLoaderByClassNameNonBlocking(className);
        if (lrmiClassLoader == null) {
            throw new ClassNotFoundException("No LRMI class loader associated with the specified class [" + className + "]");
        }
        return lrmiClassLoader.getLoadedClass(className);
    }

    private static synchronized LRMIClassLoader createClassLoader(String className) throws LRMIClassLoaderCreationException {
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        if (contextClassLoader == null) {
            throw new LRMIClassLoaderCreationException("attempt to create a LRMIClassLoader when there is no context class loader");
        }
        ServiceClassLoaderContext serviceClassLoaderContext = LRMIClassLoadersHolder.getServiceClassLoaderContext();
        if (serviceClassLoaderContext == null) {
            if (_logger.isLoggable(Level.FINEST)) {
                LRMIClassLoadersHolder.logFinest("creating service class loader context [" + ClassLoaderHelper.getClassLoaderLogName(contextClassLoader) + "]");
            }
            serviceClassLoaderContext = new ServiceClassLoaderContext(ClassLoaderHelper.getClassLoaderLogName(contextClassLoader));
            long classLoaderKey = ClassLoaderCache.getCache().putClassLoader(contextClassLoader);
            serviceClassLoaderContextMap.put(classLoaderKey, serviceClassLoaderContext);
        }
        LRMIRemoteClassLoaderIdentifier identifier = null;
        try {
            LRMIClassLoader previousClassLoader;
            IClassProvider classProvider;
            identifier = LRMIConnection.getRemoteClassLoaderIdentifier();
            if (identifier == null) {
                throw new LRMIClassLoaderCreationException("attempt to create a LRMIClassLoader when there is no remote class loader context");
            }
            LRMIClassLoader cl = serviceClassLoaderContext.getClassLoaderByRemoteId(identifier);
            if (cl != null) {
                if (_logger.isLoggable(Level.FINEST)) {
                    LRMIClassLoadersHolder.logFinest("current target has already associated LRMIClassLoader, using it");
                }
                return cl;
            }
            if (_logger.isLoggable(Level.FINEST)) {
                LRMIClassLoadersHolder.logFinest("retrieving remote class provider [" + identifier.getRemoteLrmiRuntimeId() + "]");
            }
            if ((classProvider = LRMIConnection.getClassProvider()) == null) {
                if (_logger.isLoggable(Level.FINE)) {
                    LRMIClassLoadersHolder.logFine("could not get LRMIClassLoader for remote class loader [" + identifier.toString() + "]");
                }
                throw new LRMIClassLoaderCreationException("could not get LRMIClassLoader for remote class loader [" + identifier.toString() + "]");
            }
            if (_logger.isLoggable(Level.FINE)) {
                LRMIClassLoadersHolder.logFine("creating new LRMIClassLoader connected to remote class loader [" + identifier.toString() + "]");
            }
            if ((previousClassLoader = serviceClassLoaderContext.putClassLoaderByRemoteId(identifier, cl = new LRMIClassLoader(classProvider, contextClassLoader, serviceClassLoaderContext, identifier.getRemoteLrmiRuntimeId(), identifier.getRemoteClassLoaderId()))) != null) {
                cl = previousClassLoader;
            }
            return cl;
        }
        catch (IOException e) {
            LRMIClassLoadersHolder.logWarningOnExceptionCreatingLRMIClassLoader(className, identifier, e);
            throw new LRMIClassLoaderCreationException("exception caught while creating LRMIClassLoader", e);
        }
        catch (IOFilterException e) {
            LRMIClassLoadersHolder.logWarningOnExceptionCreatingLRMIClassLoader(className, identifier, e);
            throw new LRMIClassLoaderCreationException("exception caught while creating LRMIClassLoader", e);
        }
    }

    protected static void logWarningOnExceptionCreatingLRMIClassLoader(String className, LRMIRemoteClassLoaderIdentifier identifier, Exception e) {
        if (_logger.isLoggable(Level.WARNING)) {
            _logger.log(Level.WARNING, "Failed creating an LRMIClassLoader [" + identifier + "] to client [" + LRMIInvocationContext.getEndpointAddress() + "] when trying to load class [" + className + "].\nMake sure the server is able to create a connection to the client (firewall, ip address mapping and binding).\nReason - " + e.getMessage(), (Throwable)e);
        }
    }

    private static synchronized ServiceClassLoaderContext getServiceClassLoaderContext() {
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        if (contextClassLoader == null) {
            throw new IllegalStateException("cannot get service class loader context without context class loader");
        }
        Long classLoaderKey = ClassLoaderCache.getCache().getClassLoaderKey(contextClassLoader);
        if (classLoaderKey == null) {
            return null;
        }
        return serviceClassLoaderContextMap.get(classLoaderKey);
    }

    private static ServiceClassLoaderContext getServiceClassLoaderContextExistingOnly() {
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        if (contextClassLoader == null) {
            throw new IllegalStateException("cannot get service class loader context without context class loader");
        }
        Long classLoaderKey = ClassLoaderCache.getCache().getClassLoaderKey(contextClassLoader);
        if (classLoaderKey == null) {
            return null;
        }
        return serviceClassLoaderContextMap.get(classLoaderKey);
    }

    public static synchronized void dropAllClasses() {
        if (!enabled) {
            return;
        }
        ServiceClassLoaderContext serviceClassLoaderContext = LRMIClassLoadersHolder.getServiceClassLoaderContext();
        if (serviceClassLoaderContext != null) {
            if (_logger.isLoggable(Level.FINE)) {
                LRMIClassLoadersHolder.logFine("dropping all classes from service class loader context [" + serviceClassLoaderContext + "]");
            }
            serviceClassLoaderContext.clear();
        } else if (_logger.isLoggable(Level.FINE)) {
            LRMIClassLoadersHolder.logFine("drop all classes: context class loader [" + ClassLoaderHelper.getClassLoaderLogName(Thread.currentThread().getContextClassLoader()) + "] has no service context, skipping dropping all classes");
        }
    }

    public static synchronized void dropClass(String className) {
        ServiceClassLoaderContext serviceClassLoaderContext;
        if (!enabled) {
            return;
        }
        if (_logger.isLoggable(Level.FINE)) {
            LRMIClassLoadersHolder.logFine("dropping class " + className);
        }
        if ((serviceClassLoaderContext = LRMIClassLoadersHolder.getServiceClassLoaderContext()) != null) {
            if (_logger.isLoggable(Level.FINE)) {
                LRMIClassLoadersHolder.logFine("dropping class [ " + className + "] from service class loader context [" + serviceClassLoaderContext + "]");
            }
            serviceClassLoaderContext.removeClass(className);
        } else if (_logger.isLoggable(Level.FINE)) {
            LRMIClassLoadersHolder.logFine("drop class [ " + className + "]: context class loader [" + ClassLoaderHelper.getClassLoaderLogName(Thread.currentThread().getContextClassLoader()) + "] has no service context, skipping dropping class");
        }
    }

    private static synchronized LRMIClassLoader getClassLoader(String className) {
        ServiceClassLoaderContext serviceClassLoaderContext = LRMIClassLoadersHolder.getServiceClassLoaderContext();
        if (serviceClassLoaderContext == null) {
            return null;
        }
        return serviceClassLoaderContext.getClassLoaderByClassName(className);
    }

    private static void logFinest(String message) {
        _logger.finest("LRMIClassLoadersHolder [" + LRMIRuntime.getRuntime().getID() + "]: " + message);
    }

    private static void logFine(String message) {
        _logger.fine("LRMIClassLoadersHolder [" + LRMIRuntime.getRuntime().getID() + "]: " + message);
    }

    public static synchronized ServiceClassLoaderContext getServiceClassLoaderContext(ClassLoader classLoader) {
        Long classLoaderKey;
        if (_logger.isLoggable(Level.FINEST)) {
            LRMIClassLoadersHolder.logFinest("getting service class loader context of class loader " + ClassLoaderHelper.getClassLoaderLogName(classLoader));
        }
        if ((classLoaderKey = ClassLoaderCache.getCache().getClassLoaderKey(classLoader)) != null) {
            return serviceClassLoaderContextMap.get(classLoaderKey);
        }
        return null;
    }

    static {
        _logger = TraceableLogger.getLogger((String)"com.gigaspaces.lrmi.classloading");
        loadClassLock = new Object();
        listener = new IClassLoaderCacheStateListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onClassLoaderRemoved(Long classLoaderKey, boolean explicit) {
                Class<LRMIClassLoadersHolder> clazz = LRMIClassLoadersHolder.class;
                synchronized (LRMIClassLoadersHolder.class) {
                    serviceClassLoaderContextMap.remove(classLoaderKey);
                    // ** MonitorExit[var3_3] (shouldn't be in output)
                    return;
                }
            }
        };
        boolean bl = enabled = Boolean.parseBoolean(System.getProperty("com.gs.transport_protocol.lrmi.classloading", "true")) && Boolean.parseBoolean(System.getProperty("com.gs.transport_protocol.lrmi.classloading.import", "true"));
        if (enabled) {
            serviceClassLoaderContextMap = new CopyOnUpdateMap();
            ClassLoaderCache.getCache().registerCacheStateListener(listener);
            AdditionalClassProviderFactory.setClassProvider((IAdditionalClassProvider)new IAdditionalClassProvider(){

                public Class<?> loadClass(String className, boolean fastPathOnly) throws ClassNotFoundException {
                    if (fastPathOnly) {
                        return LRMIClassLoadersHolder.loadClassFromExistingOnly(className);
                    }
                    return LRMIClassLoadersHolder.loadClass(className);
                }
            });
            if (_logger.isLoggable(Level.FINE)) {
                LRMIClassLoadersHolder.logFine("LRMI class loading enabled");
            }
        } else {
            serviceClassLoaderContextMap = null;
            if (_logger.isLoggable(Level.FINE)) {
                LRMIClassLoadersHolder.logFine("LRMI class loading disabled");
            }
        }
        _currentLoadingClass = new ThreadLocal();
    }
}

