/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.lrmi.classloading;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.utils.collections.CopyOnUpdateMap;
import com.gigaspaces.logger.TraceableLogger;
import com.gigaspaces.lrmi.classloading.LRMIClassLoader;
import com.gigaspaces.lrmi.classloading.LRMIRemoteClassLoaderIdentifier;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.logging.Level;

@InternalApi
public class ServiceClassLoaderContext {
    private static final TraceableLogger _logger = TraceableLogger.getLogger((String)"com.gigaspaces.lrmi.classloading");
    private final CopyOnUpdateMap<String, WeakReference<LRMIClassLoader>> _classLoaderByName = new CopyOnUpdateMap();
    private final HashMap<LRMIRemoteClassLoaderIdentifier, WeakReference<LRMIClassLoader>> _classLoaderByRemoteId = new HashMap();
    private final HashMap<String, byte[]> _classBytesByName = new HashMap();
    private final String _name;
    private final Object _stateLock = new Object();
    private static final boolean _disableDuplicateLoadProtection = Boolean.getBoolean("com.gs.transport_protocol.lrmi.classloading.disable-duplicate-protection");

    public ServiceClassLoaderContext(String name) {
        this._name = name;
    }

    public LRMIClassLoader getClassLoaderByClassNameNonBlocking(String className) {
        WeakReference<LRMIClassLoader> lrmiClassLoaderRef = this._classLoaderByName.get(className);
        if (lrmiClassLoaderRef == null) {
            return null;
        }
        return (LRMIClassLoader)lrmiClassLoaderRef.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LRMIClassLoader getClassLoaderByClassName(String className) {
        Object object = this._stateLock;
        synchronized (object) {
            WeakReference<LRMIClassLoader> lrmiClassLoaderRef = this._classLoaderByName.get(className);
            if (lrmiClassLoaderRef == null) {
                return null;
            }
            LRMIClassLoader loader = (LRMIClassLoader)lrmiClassLoaderRef.get();
            if (loader == null) {
                if (_logger.isLoggable(Level.FINEST)) {
                    _logger.finest("LRMIClassLoader of class: " + className + " had no strong reference and was weakly removed");
                }
                this.removeClass(className);
            }
            return loader;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LRMIClassLoader getClassLoaderByRemoteId(LRMIRemoteClassLoaderIdentifier identifier) {
        Object object = this._stateLock;
        synchronized (object) {
            WeakReference<LRMIClassLoader> lrmiClassLoaderRef = this._classLoaderByRemoteId.get(identifier);
            if (lrmiClassLoaderRef == null) {
                return null;
            }
            LRMIClassLoader loader = (LRMIClassLoader)lrmiClassLoaderRef.get();
            if (loader == null) {
                if (_logger.isLoggable(Level.FINEST)) {
                    _logger.finest("LRMIClassLoader connected to: " + identifier + " had no strong reference and was weakly removed");
                }
                this._classLoaderByRemoteId.remove(identifier);
            }
            return loader;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LRMIClassLoader putClassLoaderByRemoteId(LRMIRemoteClassLoaderIdentifier identifier, LRMIClassLoader lrmiClassLoader) {
        Object object = this._stateLock;
        synchronized (object) {
            LRMIClassLoader previousClassLoader = this.getClassLoaderByRemoteId(identifier);
            if (previousClassLoader != null) {
                return previousClassLoader;
            }
            WeakReference<LRMIClassLoader> lrmiClassLoaderRef = new WeakReference<LRMIClassLoader>(lrmiClassLoader);
            this._classLoaderByRemoteId.put(identifier, lrmiClassLoaderRef);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LRMIClassLoader putClassBytesAndLoader(String className, LRMIClassLoader lrmiClassLoader, byte[] definition) {
        Object object = this._stateLock;
        synchronized (object) {
            WeakReference<LRMIClassLoader> previousClassLoaderRef = this._classLoaderByName.get(className);
            if (previousClassLoaderRef != null) {
                LRMIClassLoader previousLRMIClassLoader = (LRMIClassLoader)previousClassLoaderRef.get();
                if (previousLRMIClassLoader != null) {
                    return previousLRMIClassLoader;
                }
                if (_logger.isLoggable(Level.FINEST)) {
                    _logger.finest("previous LRMIClassLoader of class: " + className + " had no strong reference and was weakly removed");
                }
            }
            WeakReference<LRMIClassLoader> lrmiClassLoaderRef = new WeakReference<LRMIClassLoader>(lrmiClassLoader);
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.finest("Associating class: " + className + " to class loader " + lrmiClassLoader);
            }
            this._classLoaderByName.put(className, lrmiClassLoaderRef);
            try {
                this.storeClassBytes(className, definition);
            }
            catch (RuntimeException e) {
                if (_logger.isLoggable(Level.FINEST)) {
                    _logger.finest("error occurred while storing class bytes of class: " + className + " in " + this + ", removing class loader " + lrmiClassLoader + " association");
                }
                this._classLoaderByName.remove(className);
                throw e;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getClassBytes(String className) {
        Object object = this._stateLock;
        synchronized (object) {
            return this._classBytesByName.get(className);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeClassBytes(String className, byte[] definition) {
        Object object = this._stateLock;
        synchronized (object) {
            if (this._classBytesByName.containsKey(className)) {
                String msg = this.toString() + ": attempting to add class bytes for class name " + className + " which already has mapped class bytes";
                if (_logger.isLoggable(Level.SEVERE)) {
                    _logger.severe(msg);
                    _logger.showGlobalTrace();
                }
                if (_disableDuplicateLoadProtection) {
                    _logger.warning(this.toString() + ": duplicate remote class loading protection is disabled, exception ignored");
                } else {
                    throw new IllegalArgumentException(msg);
                }
            }
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.finest("Storing class bytes of class: " + className + " in " + this);
            }
            this._classBytesByName.put(className, definition);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeClass(String className) {
        Object object = this._stateLock;
        synchronized (object) {
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.finest("Removing class: " + className + " from " + this);
            }
            this._classBytesByName.remove(className);
            this._classLoaderByName.remove(className);
        }
    }

    public String toString() {
        return "ServiceClassLoaderContext [" + this._name + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Object object = this._stateLock;
        synchronized (object) {
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.finest("Clearing " + this);
            }
            this._classBytesByName.clear();
            this._classLoaderByName.clear();
            this._classLoaderByRemoteId.clear();
        }
    }
}

