/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.lrmi.classloading.protocol.lrmi;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.version.PlatformLogicalVersion;
import com.gigaspaces.internal.version.PlatformVersion;
import com.gigaspaces.start.SystemInfo;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.rmi.UnmarshalException;

@InternalApi
public class HandshakeRequest
implements Externalizable {
    private static final long serialVersionUID = 1L;
    private static final byte SERIAL_VERSION = -128;
    private PlatformLogicalVersion _logicalVersion;
    private long _pid;

    public HandshakeRequest() {
    }

    public HandshakeRequest(PlatformLogicalVersion logicalVersion) {
        this._logicalVersion = logicalVersion;
        this._pid = SystemInfo.singleton().os().processId();
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        byte serialVersion = in.readByte();
        if (serialVersion != -128) {
            throw new UnmarshalException("Requested version [" + serialVersion + "] does not match local version [" + -128 + "]. Please make sure you are using the same version on both ends, service version is " + PlatformVersion.getOfficialVersion());
        }
        this._logicalVersion = (PlatformLogicalVersion)in.readObject();
        if (this._logicalVersion.greaterOrEquals(PlatformLogicalVersion.v9_1_0)) {
            this._pid = in.readLong();
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeByte(-128);
        out.writeObject(this._logicalVersion);
        out.writeLong(this._pid);
    }

    public PlatformLogicalVersion getSourcePlatformLogicalVersion() {
        return this._logicalVersion;
    }

    public long getSourcePid() {
        return this._pid;
    }
}

