/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.lrmi.classloading.protocol.lrmi;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.lrmi.classloading.IClassProvider;
import com.gigaspaces.lrmi.classloading.IRemoteClassProviderProvider;
import com.gigaspaces.lrmi.classloading.LRMIRemoteClassLoaderIdentifier;
import com.gigaspaces.lrmi.nio.filters.IOFilterException;
import java.io.IOException;

@InternalApi
public class LRMIConnection {
    private static final ThreadLocal<IRemoteClassProviderProvider> _connectionHolder = new ThreadLocal();

    public static IRemoteClassProviderProvider putConnection(IRemoteClassProviderProvider conn) {
        IRemoteClassProviderProvider previous = _connectionHolder.get();
        _connectionHolder.set(conn);
        return previous;
    }

    public static void setConnection(IRemoteClassProviderProvider conn) {
        _connectionHolder.set(conn);
    }

    public static void clearConnection() {
        _connectionHolder.set(null);
    }

    public static LRMIRemoteClassLoaderIdentifier getRemoteClassLoaderIdentifier() {
        IRemoteClassProviderProvider connection = _connectionHolder.get();
        if (connection != null) {
            return connection.getRemoteClassLoaderIdentifier();
        }
        return null;
    }

    public static LRMIRemoteClassLoaderIdentifier setRemoteClassLoaderIdentifier(LRMIRemoteClassLoaderIdentifier remoteClassLoaderIdentifier) {
        IRemoteClassProviderProvider connection = _connectionHolder.get();
        if (connection != null) {
            return connection.setRemoteClassLoaderIdentifier(remoteClassLoaderIdentifier);
        }
        return null;
    }

    public static IClassProvider getClassProvider() throws IOException, IOFilterException {
        IRemoteClassProviderProvider connection = _connectionHolder.get();
        if (connection != null) {
            return connection.getClassProvider();
        }
        return null;
    }

    public static IRemoteClassProviderProvider getClassProviderProvider() {
        return _connectionHolder.get();
    }
}

