/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.lrmi.nio;

import com.gigaspaces.internal.version.PlatformLogicalVersion;
import com.gigaspaces.lrmi.LRMIInvocationContext;
import com.gigaspaces.lrmi.LRMIInvocationTrace;
import com.gigaspaces.lrmi.OperationPriority;
import com.gigaspaces.lrmi.nio.IResponseContext;
import com.gigaspaces.lrmi.nio.IResponseHandler;
import com.gigaspaces.lrmi.nio.ReplyPacket;

public abstract class AbstractResponseContext
implements IResponseContext {
    private boolean _sendResponse = true;
    private boolean _responseSent = false;
    private IResponseHandler _respHandler;
    private final PlatformLogicalVersion _sourcePlatformLogicalVersion;
    private final LRMIInvocationTrace _trace;
    private final OperationPriority _operationPriority;
    private final String _lrmiMonitoringId;
    private boolean _invokedFromNewRouter;

    public AbstractResponseContext(PlatformLogicalVersion sourcePlatformLogicalVersion, OperationPriority operationPriority, String lrmiMonitoringId, LRMIInvocationTrace trace) {
        this._sourcePlatformLogicalVersion = sourcePlatformLogicalVersion;
        this._operationPriority = operationPriority;
        this._lrmiMonitoringId = lrmiMonitoringId;
        this._trace = trace;
    }

    @Override
    public synchronized boolean markAsSentResponse() {
        return this._responseSent ? false : (this._responseSent = true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendResponse(Object response, Exception exp) {
        try {
            LRMIInvocationContext.updateContext((LRMIInvocationTrace)this._trace, (LRMIInvocationContext.ProxyWriteType)LRMIInvocationContext.ProxyWriteType.UNCACHED, (LRMIInvocationContext.InvocationStage)LRMIInvocationContext.InvocationStage.SERVER_MARSHAL_REPLY, (PlatformLogicalVersion)this._sourcePlatformLogicalVersion, null, (boolean)true, null, null);
            ReplyPacket<Object> respPacket = new ReplyPacket<Object>(response, exp);
            this._respHandler.handleResponse(this, respPacket);
        }
        finally {
            LRMIInvocationContext.restoreContext();
        }
    }

    @Override
    public void setResponseHandler(IResponseHandler handler) {
        this._respHandler = handler;
    }

    @Override
    public void setSendResponse(boolean sendResp) {
        this._sendResponse = sendResp;
    }

    @Override
    public boolean shouldSendResponse() {
        return this._sendResponse;
    }

    @Override
    public PlatformLogicalVersion getSourcePlatformLogicalVersion() {
        return this._sourcePlatformLogicalVersion;
    }

    @Override
    public OperationPriority getOperationPriority() {
        return this._operationPriority;
    }

    @Override
    public LRMIInvocationTrace getTrace() {
        return this._trace;
    }

    @Override
    public boolean isInvokedFromNewRouter() {
        return this._invokedFromNewRouter;
    }

    @Override
    public void setInvokedFromNewRouter(boolean invokedFromNewRouter) {
        this._invokedFromNewRouter = invokedFromNewRouter;
    }

    @Override
    public String getLRMIMonitoringId() {
        return this._lrmiMonitoringId;
    }
}

