/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.lrmi.nio;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.async.SettableFuture;
import com.gigaspaces.config.lrmi.ITransportConfig;
import com.gigaspaces.config.lrmi.nio.NIOConfiguration;
import com.gigaspaces.exception.lrmi.ApplicationException;
import com.gigaspaces.exception.lrmi.LRMINoSuchObjectException;
import com.gigaspaces.exception.lrmi.LRMIUnhandledException;
import com.gigaspaces.exception.lrmi.ProtocolException;
import com.gigaspaces.internal.backport.java.util.concurrent.atomic.LongAdder;
import com.gigaspaces.internal.io.MarshalContextClearedException;
import com.gigaspaces.internal.lrmi.ConnectionUrlDescriptor;
import com.gigaspaces.internal.lrmi.LRMIMonitoringModule;
import com.gigaspaces.internal.reflection.ReflectionUtil;
import com.gigaspaces.internal.utils.StringUtils;
import com.gigaspaces.internal.version.PlatformLogicalVersion;
import com.gigaspaces.lrmi.BaseClientPeer;
import com.gigaspaces.lrmi.ConnectionPool;
import com.gigaspaces.lrmi.DynamicSmartStub;
import com.gigaspaces.lrmi.LRMIInvocationContext;
import com.gigaspaces.lrmi.LRMIInvocationTrace;
import com.gigaspaces.lrmi.LRMIMethod;
import com.gigaspaces.lrmi.LRMIRuntime;
import com.gigaspaces.lrmi.LRMIUtilities;
import com.gigaspaces.lrmi.OperationPriority;
import com.gigaspaces.lrmi.ServerAddress;
import com.gigaspaces.lrmi.classloading.ClassProviderRequest;
import com.gigaspaces.lrmi.classloading.IClassProvider;
import com.gigaspaces.lrmi.classloading.IRemoteClassProviderProvider;
import com.gigaspaces.lrmi.classloading.LRMIRemoteClassLoaderIdentifier;
import com.gigaspaces.lrmi.classloading.protocol.lrmi.HandshakeRequest;
import com.gigaspaces.lrmi.classloading.protocol.lrmi.LRMIConnection;
import com.gigaspaces.lrmi.nio.ClientPeerWatchedObjectsContext;
import com.gigaspaces.lrmi.nio.NIOUtils;
import com.gigaspaces.lrmi.nio.PAdapter;
import com.gigaspaces.lrmi.nio.Pivot;
import com.gigaspaces.lrmi.nio.ProtocolValidation;
import com.gigaspaces.lrmi.nio.Reader;
import com.gigaspaces.lrmi.nio.RemoteClassLoaderContext;
import com.gigaspaces.lrmi.nio.ReplyPacket;
import com.gigaspaces.lrmi.nio.RequestPacket;
import com.gigaspaces.lrmi.nio.Writer;
import com.gigaspaces.lrmi.nio.async.AsyncContext;
import com.gigaspaces.lrmi.nio.async.FutureContext;
import com.gigaspaces.lrmi.nio.async.LRMIFuture;
import com.gigaspaces.lrmi.nio.filters.IOBlockFilterManager;
import com.gigaspaces.lrmi.nio.filters.IOFilterException;
import com.gigaspaces.lrmi.nio.filters.IOFilterManager;
import com.gigaspaces.lrmi.nio.selector.handler.client.ClientConversationRunner;
import com.gigaspaces.lrmi.nio.selector.handler.client.ClientHandler;
import com.gigaspaces.lrmi.nio.selector.handler.client.Conversation;
import com.gigaspaces.lrmi.nio.selector.handler.client.LRMIChat;
import com.gigaspaces.lrmi.nio.selector.handler.client.WriteBytesChat;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedSelectorException;
import java.nio.channels.SocketChannel;
import java.rmi.ConnectException;
import java.rmi.ConnectIOException;
import java.rmi.NoSuchObjectException;
import java.rmi.RemoteException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.space.InternalSpaceException;

@InternalApi
public class CPeer
extends BaseClientPeer {
    private static final Logger _logger = Logger.getLogger("com.gigaspaces.lrmi");
    private static final Logger _contextLogger = Logger.getLogger("com.gigaspaces.lrmi.context");
    private static final int SELECTOR_BUG_CONNECT_RETRY = Integer.getInteger("com.gs.lrmi.connect.selector.retry", 5);
    private static final boolean CHANGE_THREAD_NAME_ON_INVOCATION = Boolean.getBoolean("com.gs.lrmi.change.thread.name");
    private static final LongAdder connections = new LongAdder();
    private long _generatedTraffic;
    private long _receivedTraffic;
    private final AtomicBoolean disconnected = new AtomicBoolean(false);
    private static final LRMIMethod _dummyMethod;
    private volatile SocketChannel m_SockChannel;
    private String _socketDisplayString;
    private Writer _writer;
    private Reader _reader;
    private final RequestPacket _requestPacket;
    private final ReplyPacket<Object> _replayPacket;
    private final IRemoteClassProviderProvider _remoteConnection = new ClientRemoteClassProviderProvider();
    private long _objectClassLoaderId;
    private long _remoteLrmiRuntimeId;
    private LRMIRemoteClassLoaderIdentifier _remoteClassLoaderIdentifier;
    private ClientPeerWatchedObjectsContext _watchdogContext;
    private boolean _blocking = true;
    private int _slowConsumerThroughput;
    private int _slowConsumerLatency;
    private int _slowConsumerRetries;
    private ITransportConfig _config;
    private InetSocketAddress m_Address;
    private final ClientHandler _handler;
    private final ClientConversationRunner clientConversationRunner;
    private final PlatformLogicalVersion _serviceVersion;
    private IOFilterManager _filterManager;
    private final Object _closedLock = new Object();
    private volatile boolean _closed;
    private boolean _protocolValidationEnabled;
    private final LRMIMonitoringModule _monitoringModule = new LRMIMonitoringModule();
    private final Object _memoryBarrierLock = new Object();
    private AsyncContext _asyncContext = null;
    private boolean _asyncConnect;

    public static LongAdder getConnectionsCounter() {
        return connections;
    }

    public CPeer(PAdapter pAdapter, ClientHandler handler, ClientConversationRunner clientConversationRunner, PlatformLogicalVersion serviceVersion) {
        super(pAdapter);
        this._handler = handler;
        this.clientConversationRunner = clientConversationRunner;
        this._serviceVersion = serviceVersion;
        this._requestPacket = new RequestPacket();
        this._replayPacket = new ReplyPacket();
        connections.increment();
    }

    @Override
    public void init(ITransportConfig config) {
        this._config = config;
        this._blocking = config.isBlockingConnection();
        this._slowConsumerThroughput = config.getSlowConsumerThroughput();
        this._slowConsumerLatency = config.getSlowConsumerLatency();
        this._slowConsumerRetries = config.getSlowConsumerRetries();
        this._protocolValidationEnabled = ((NIOConfiguration)config).isProtocolValidationEnabled();
        this._asyncConnect = System.getProperty("com.gs.transport_protocol.lrmi.use_async_connect") == null || Boolean.getBoolean("com.gs.transport_protocol.lrmi.use_async_connect");
    }

    @Override
    public LRMIMonitoringModule getMonitoringModule() {
        return this._monitoringModule;
    }

    @Override
    public synchronized void connect(String connectionURL, LRMIMethod lrmiMethod) throws MalformedURLException, RemoteException {
        if (this._asyncConnect && IOBlockFilterManager.getFilterFactory() == null && this._slowConsumerThroughput == 0 && this.clientConversationRunner != null) {
            this.connectAsync(connectionURL, lrmiMethod);
        } else {
            this.connectSync(connectionURL, lrmiMethod);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void connectAsync(String connectionURL, LRMIMethod lrmiMethod) throws MalformedURLException, RemoteException {
        Object object = this._closedLock;
        synchronized (object) {
            if (this._closed) {
                DynamicSmartStub.throwProxyClosedExeption(connectionURL);
            }
        }
        if (_logger.isLoggable(Level.FINER)) {
            this.detailedLogging("CPeer.connect", "trying to connect using connection url [" + connectionURL + "], calling method [" + lrmiMethod.realMethod.getDeclaringClass().getSimpleName() + "." + lrmiMethod.realMethod.getName() + "]");
        }
        ConnectionUrlDescriptor connectionUrlDescriptor = ConnectionUrlDescriptor.fromUrl(connectionURL);
        String host = connectionUrlDescriptor.getHostname();
        this._objectClassLoaderId = connectionUrlDescriptor.getObjectClassLoaderId();
        this._remoteLrmiRuntimeId = connectionUrlDescriptor.getLrmiRuntimeId();
        this._remoteClassLoaderIdentifier = new LRMIRemoteClassLoaderIdentifier(this._remoteLrmiRuntimeId, this._objectClassLoaderId);
        try {
            ServerAddress transformedAddress = this.mapAddress(host, connectionUrlDescriptor.getPort());
            this.m_SockChannel = this.createAsyncChannel(transformedAddress.getHost(), transformedAddress.getPort(), lrmiMethod);
            this._socketDisplayString = NIOUtils.getSocketDisplayString(this.m_SockChannel);
            if (this._writer != null) {
                this._generatedTraffic += this._writer.getGeneratedTraffic();
            }
            this._writer = new Writer(this.m_SockChannel, this._slowConsumerThroughput, this._slowConsumerLatency, this._slowConsumerRetries, null);
            if (this._reader != null) {
                this._receivedTraffic += this._reader.getReceivedTraffic();
            }
            this._reader = new Reader(this.m_SockChannel, this._slowConsumerRetries);
            this.setConnectionURL(connectionURL);
            this.setObjectId(connectionUrlDescriptor.getObjectId());
            this._watchdogContext = new ClientPeerWatchedObjectsContext(this);
        }
        catch (Exception ex) {
            this.disconnect();
            throw new ConnectException("Connect Failed to [" + connectionURL + "]", ex);
        }
        this.setConnected(true);
        this._watchdogContext.watchIdle();
    }

    private SocketChannel createAsyncChannel(String host, int port, LRMIMethod lrmiMethod) throws IOException {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("connecting new socket channel to " + host + ":" + port + ", connect timeout=" + this._config.getSocketConnectTimeout() + " keepalive=" + LRMIUtilities.KEEP_ALIVE_MODE);
        }
        Conversation conversation = new Conversation(new InetSocketAddress(host, port));
        if (this._protocolValidationEnabled) {
            conversation.addChat(new WriteBytesChat(ProtocolValidation.getProtocolHeaderBytes()));
        }
        RequestPacket requestPacket = new RequestPacket(new HandshakeRequest(PlatformLogicalVersion.getLogicalVersion()));
        requestPacket.operationPriority = this.getOperationPriority(lrmiMethod, LRMIInvocationContext.getCurrentContext());
        conversation.addChat(new LRMIChat(requestPacket));
        try {
            SettableFuture<Conversation> future = this.clientConversationRunner.addConversation(conversation);
            if (this._config.getSocketConnectTimeout() == 0L) {
                future.get();
            } else {
                future.get(this._config.getSocketConnectTimeout(), TimeUnit.MILLISECONDS);
            }
            conversation.channel().configureBlocking(true);
            return conversation.channel();
        }
        catch (Throwable t) {
            conversation.close(t);
            throw new IOException(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void connectSync(String connectionURL, LRMIMethod lrmiMethod) throws MalformedURLException, RemoteException {
        block17: {
            Object object = this._closedLock;
            synchronized (object) {
                if (this._closed) {
                    DynamicSmartStub.throwProxyClosedExeption(connectionURL);
                }
            }
            if (_logger.isLoggable(Level.FINER)) {
                this.detailedLogging("CPeer.connect", "trying to connect using connection url [" + connectionURL + "], calling method [" + lrmiMethod.realMethod.getDeclaringClass().getSimpleName() + "." + lrmiMethod.realMethod.getName() + "]");
            }
            ConnectionUrlDescriptor connectionUrlDescriptor = ConnectionUrlDescriptor.fromUrl(connectionURL);
            String host = connectionUrlDescriptor.getHostname();
            this._objectClassLoaderId = connectionUrlDescriptor.getObjectClassLoaderId();
            this._remoteLrmiRuntimeId = connectionUrlDescriptor.getLrmiRuntimeId();
            this._remoteClassLoaderIdentifier = new LRMIRemoteClassLoaderIdentifier(this._remoteLrmiRuntimeId, this._objectClassLoaderId);
            try {
                ServerAddress transformedAddress = this.mapAddress(host, connectionUrlDescriptor.getPort());
                this.m_SockChannel = this.createChannel(transformedAddress.getHost(), transformedAddress.getPort());
                this._socketDisplayString = NIOUtils.getSocketDisplayString(this.m_SockChannel);
                if (this._writer != null) {
                    this._generatedTraffic += this._writer.getGeneratedTraffic();
                }
                this._writer = new Writer(this.m_SockChannel, this._slowConsumerThroughput, this._slowConsumerLatency, this._slowConsumerRetries, null);
                if (this._reader != null) {
                    this._receivedTraffic += this._reader.getReceivedTraffic();
                }
                this._reader = new Reader(this.m_SockChannel, this._slowConsumerRetries);
                this.setConnectionURL(connectionURL);
                this.setObjectId(connectionUrlDescriptor.getObjectId());
                this._watchdogContext = new ClientPeerWatchedObjectsContext(this);
                if (this._protocolValidationEnabled) {
                    this.validateProtocol();
                }
                try {
                    this._filterManager = IOBlockFilterManager.createFilter(this._reader, this._writer, true, this.m_SockChannel);
                }
                catch (Exception e) {
                    if (_logger.isLoggable(Level.SEVERE)) {
                        _logger.log(Level.SEVERE, "Failed to load communication filter " + System.getProperty("com.gs.lrmi.filter.factory"), e);
                    }
                    throw new InternalSpaceException("Failed to load communication filter " + System.getProperty("com.gs.lrmi.filter.factory"), e);
                }
                if (this._filterManager == null) break block17;
                try {
                    this._filterManager.beginHandshake();
                }
                catch (Exception e) {
                    throw new ConnectException("Failed to perform communication filter handshake using " + System.getProperty("com.gs.lrmi.filter.factory") + " filter", e);
                }
            }
            catch (Exception ex) {
                this.disconnect();
                throw new ConnectException("Connect Failed to [" + connectionURL + "]", ex);
            }
        }
        this.setConnected(true);
        try {
            this.doHandshake(lrmiMethod);
        }
        catch (Exception ex) {
            this.disconnect();
            throw new ConnectException("Connect Failed to [" + connectionURL + "], handshake failure", ex);
        }
        this._watchdogContext.watchIdle();
    }

    private void validateProtocol() throws IOException {
        this._watchdogContext.watchRequest("protocol-validation");
        try {
            this._writer.writeProtocolValidationHeader();
        }
        finally {
            this._watchdogContext.watchNone();
        }
    }

    private ServerAddress mapAddress(String host, int port) {
        return LRMIRuntime.getRuntime().getNetworkMapper().map(new ServerAddress(host, port));
    }

    private void detailedLogging(String methodName, String description) {
        if (_logger.isLoggable(Level.FINER)) {
            SocketAddress localSocketAddress;
            Socket socket;
            String localAddress = "not connected";
            if (this.m_SockChannel != null && (socket = this.m_SockChannel.socket()) != null && (localSocketAddress = socket.getLocalSocketAddress()) != null) {
                localAddress = localSocketAddress.toString();
            }
            _logger.finer("At " + methodName + " method, " + description + " [invoker address=" + localAddress + ", ServerEndPoint=" + this.getConnectionURL() + "]");
        }
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.log(Level.FINEST, "At " + methodName + ", thread stack:" + StringUtils.NEW_LINE + StringUtils.getCurrentStackTrace());
        }
    }

    private SocketChannel createChannel(String host, int port) throws IOException {
        SocketChannel sockChannel;
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("connecting new socket channel to " + host + ":" + port + ", connect timeout=" + this._config.getSocketConnectTimeout() + " keepalive=" + LRMIUtilities.KEEP_ALIVE_MODE);
        }
        int i = 0;
        while (true) {
            sockChannel = this.createSocket(host, port);
            try {
                sockChannel.socket().connect(this.m_Address, (int)this._config.getSocketConnectTimeout());
            }
            catch (ClosedSelectorException e) {
                this.handleConnectError(i, host, port, sockChannel, e);
                ++i;
                continue;
            }
            break;
        }
        sockChannel.configureBlocking(this._blocking);
        sockChannel.read(ByteBuffer.allocate(0));
        return sockChannel;
    }

    private SocketChannel createSocket(String host, int port) throws IOException {
        SocketChannel sockChannel = SocketChannel.open();
        sockChannel.configureBlocking(true);
        this.m_Address = new InetSocketAddress(host, port);
        LRMIUtilities.initNewSocketProperties(sockChannel);
        return sockChannel;
    }

    private void handleConnectError(int retry, String host, int port, SocketChannel sockChannel, ClosedSelectorException e) {
        block4: {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "retrying connection due to closed selector exception: connecting to " + host + ":" + port + ", connect timeout=" + this._config.getSocketConnectTimeout() + " keepalive=" + LRMIUtilities.KEEP_ALIVE_MODE, e);
            }
            try {
                sockChannel.close();
            }
            catch (Exception ex) {
                if (!_logger.isLoggable(Level.FINE)) break block4;
                _logger.log(Level.FINE, "Failed to close socket: connecting to " + host + ":" + port + ", connect timeout=" + this._config.getSocketConnectTimeout() + " keepalive=" + LRMIUtilities.KEEP_ALIVE_MODE, ex);
            }
        }
        if (retry + 1 == SELECTOR_BUG_CONNECT_RETRY) {
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this._closedLock;
        synchronized (object) {
            if (this._closed) {
                return;
            }
            this._closed = true;
            this.closeSocketAndUnregisterWatchdog();
        }
    }

    @Override
    protected boolean isClosed() {
        return this._closed;
    }

    @Override
    public void disconnect() {
        Reader reader;
        if (this.disconnected.compareAndSet(false, true)) {
            connections.decrement();
        }
        this.closeSocketAndUnregisterWatchdog();
        this.m_SockChannel = null;
        Writer writer = this._writer;
        if (writer != null) {
            writer.closeContext();
            this._generatedTraffic += writer.getGeneratedTraffic();
            this._writer = null;
        }
        if ((reader = this._reader) != null) {
            reader.closeContext();
            this._receivedTraffic += reader.getReceivedTraffic();
            this._reader = null;
        }
        this.setConnected(false);
    }

    private void closeSocketAndUnregisterWatchdog() {
        try {
            if (this.m_SockChannel != null) {
                this.m_SockChannel.close();
            }
        }
        catch (Exception ex) {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "Failed to disconnect from " + this.getConnectionURL(), ex);
            }
        }
        finally {
            if (this._watchdogContext != null) {
                this._watchdogContext.close();
            }
        }
    }

    public Reader getReader() {
        return this._reader;
    }

    public SocketChannel getChannel() {
        return this.m_SockChannel;
    }

    public Writer getWriter() {
        return this._writer;
    }

    public void afterInvoke() {
        this._watchdogContext.watchIdle();
        this._requestPacket.clear();
        this._replayPacket.clear();
    }

    public IClassProvider getClassProvider() {
        return this.getProtocolAdapter().getClassProvider();
    }

    private void doHandshake(LRMIMethod lrmiMethod) throws IOException, IOFilterException, ClassNotFoundException {
        RequestPacket requestPacket = new RequestPacket(new HandshakeRequest(PlatformLogicalVersion.getLogicalVersion()));
        requestPacket.operationPriority = this.getOperationPriority(lrmiMethod, LRMIInvocationContext.getCurrentContext());
        String previousThreadName = this.updateThreadNameIfNeeded();
        this._watchdogContext.watchRequest("handshake");
        try {
            this._writer.writeRequest(requestPacket);
            this._watchdogContext.watchResponse("handshake");
            if (this._blocking) {
                this._reader.readReply(0, 1000);
            } else {
                this._reader.readReply(this._slowConsumerLatency, 1000);
            }
        }
        catch (ClassNotFoundException e) {
            if (_logger.isLoggable(Level.SEVERE)) {
                _logger.log(Level.SEVERE, "unexpected exception occured at handshake sequence: [" + this.getConnectionURL() + "]", e);
            }
            throw e;
        }
        finally {
            this._watchdogContext.watchNone();
            this.restoreThreadNameIfNeeded(previousThreadName);
        }
    }

    private OperationPriority getOperationPriority(LRMIMethod lrmiMethod, LRMIInvocationContext currentContext) {
        if (lrmiMethod.isLivenessPriority && currentContext.isLivenessPriorityEnabled()) {
            return OperationPriority.LIVENESS;
        }
        if (lrmiMethod.isMonitoringPriority) {
            return OperationPriority.MONITORING;
        }
        if (currentContext.isCustomPriorityEnabled()) {
            return OperationPriority.CUSTOM;
        }
        return OperationPriority.REGULAR;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public Object invoke(Object proxy, LRMIMethod lrmiMethod, Object[] args, ConnectionPool connPool) throws ApplicationException, ProtocolException, RemoteException, InterruptedException {
        String monitoringId;
        IRemoteClassProviderProvider previousConnection;
        String previousThreadName;
        block38: {
            block37: {
                AsyncContext ctx;
                LRMIInvocationTrace trace;
                if (_logger.isLoggable(Level.FINER)) {
                    this.detailedLogging("CPeer.invoke", "trying to invoke method [" + lrmiMethod.realMethod.getDeclaringClass().getSimpleName() + "." + lrmiMethod.realMethod.getName() + "]");
                }
                LRMIInvocationContext currentContext = LRMIInvocationContext.getCurrentContext();
                if (_contextLogger.isLoggable(Level.FINE) && (trace = currentContext.getTrace()) != null) {
                    trace = trace.setIdentifier(NIOUtils.getSocketDisplayString(this.m_SockChannel));
                    currentContext.setTrace(trace);
                }
                previousThreadName = null;
                previousConnection = LRMIConnection.putConnection(this._remoteConnection);
                ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
                long clientClassLoaderId = this.getClassProvider().putClassLoader(contextClassLoader);
                boolean isCallBack = lrmiMethod.isCallBack || currentContext.isCallbackMethod();
                OperationPriority priority = this.getOperationPriority(lrmiMethod, currentContext);
                this._requestPacket.set(this.getObjectId(), lrmiMethod.orderId, args, lrmiMethod.isOneWay, isCallBack, lrmiMethod, clientClassLoaderId, priority, this._serviceVersion);
                monitoringId = Pivot.extractMonitoringId(this._requestPacket);
                this._watchdogContext.watchRequest(monitoringId);
                if (!lrmiMethod.isAsync) break block37;
                LRMIFuture result = (LRMIFuture)FutureContext.getFutureResult();
                if (result == null) {
                    result = new LRMIFuture(contextClassLoader);
                } else {
                    result.reset(contextClassLoader);
                }
                this._asyncContext = ctx = new AsyncContext(connPool, this._handler, this._requestPacket, result, this, this._remoteConnection, contextClassLoader, this._remoteClassLoaderIdentifier, monitoringId, this._watchdogContext);
                this._writer.setWriteInterestManager(ctx);
                this._handler.addChannel(this.m_SockChannel, ctx);
                FutureContext.setFutureResult(result);
                Object var16_28 = null;
                if (!lrmiMethod.isAsync) {
                    this.afterInvoke();
                }
                LRMIConnection.setConnection(previousConnection);
                this.restoreThreadNameIfNeeded(previousThreadName);
                return var16_28;
            }
            previousThreadName = this.updateThreadNameIfNeeded();
            this._writer.writeRequest(this._requestPacket);
            if (!lrmiMethod.isOneWay) break block38;
            this._monitoringModule.monitorActivity(monitoringId, this._writer, this._reader);
            Object result = null;
            if (!lrmiMethod.isAsync) {
                this.afterInvoke();
            }
            LRMIConnection.setConnection(previousConnection);
            this.restoreThreadNameIfNeeded(previousThreadName);
            return result;
        }
        LRMIInvocationContext.updateContext(null, null, (LRMIInvocationContext.InvocationStage)LRMIInvocationContext.InvocationStage.CLIENT_RECEIVE_REPLY, null, null, (boolean)false, null, null);
        boolean hasMoreIntermidiateRequests = true;
        LRMIRemoteClassLoaderIdentifier previousIdentifier = RemoteClassLoaderContext.set(this._remoteClassLoaderIdentifier);
        while (hasMoreIntermidiateRequests) {
            this._watchdogContext.watchResponse(monitoringId);
            this._reader.readReply(this._replayPacket);
            if (this._replayPacket.getResult() instanceof ClassProviderRequest) {
                this._replayPacket.clear();
                this._watchdogContext.watchRequest(monitoringId);
                this._writer.writeRequest(new RequestPacket(this.getClassProvider()), false);
                continue;
            }
            hasMoreIntermidiateRequests = false;
        }
        if (this._replayPacket.getException() != null) {
            throw this._replayPacket.getException();
        }
        Object object = this._replayPacket.getResult();
        RemoteClassLoaderContext.set(previousIdentifier);
        this._monitoringModule.monitorActivity(monitoringId, this._writer, this._reader);
        if (!lrmiMethod.isAsync) {
            this.afterInvoke();
        }
        LRMIConnection.setConnection(previousConnection);
        this.restoreThreadNameIfNeeded(previousThreadName);
        return object;
        {
            catch (Throwable throwable) {
                try {
                    try {
                        RemoteClassLoaderContext.set(previousIdentifier);
                        this._monitoringModule.monitorActivity(monitoringId, this._writer, this._reader);
                        throw throwable;
                    }
                    catch (LRMIUnhandledException ex) {
                        if (ex.getStage() == LRMIUnhandledException.Stage.DESERIALIZATION) {
                            if (_logger.isLoggable(Level.FINEST)) {
                                _logger.log(Level.FINE, "LRMI caught LRMIUnhandledException during deserialization stage at end point, reseting writer context.", ex);
                            }
                            this._writer.resetContext();
                        }
                        if (_logger.isLoggable(Level.FINE)) {
                            _logger.log(Level.FINE, "LRMI caught LRMIUnhandledException, propogating it upwards.", ex);
                        }
                        throw ex;
                    }
                    catch (NoSuchObjectException ex) {
                        this.disconnect();
                        NoSuchObjectException detailedException = this.handleNoSuchObjectException(lrmiMethod, ex);
                        throw detailedException;
                    }
                    catch (IOException ex) {
                        this.disconnect();
                        String exMessage = "LRMI transport protocol over NIO broken connection with ServerEndPoint: [" + this.getConnectionURL() + "]";
                        if (_logger.isLoggable(Level.FINE)) {
                            _logger.log(Level.FINE, exMessage, ex);
                        }
                        if (this._watchdogContext.requestWatchHasException()) {
                            throw new ConnectIOException(exMessage, this._watchdogContext.getAndClearRequestWatchException());
                        }
                        if (this._watchdogContext.responseWatchHasException()) {
                            throw new ConnectIOException(exMessage, this._watchdogContext.getAndClearResponseWatchException());
                        }
                        throw new ConnectException(exMessage, ex);
                    }
                    catch (MarshalContextClearedException ex) {
                        this.disconnect();
                        String exMessage = "LRMI transport protocol over NIO broken connection with ServerEndPoint: [" + this.getConnectionURL() + "]";
                        if (_logger.isLoggable(Level.FINE)) {
                            _logger.log(Level.FINE, exMessage, ex);
                        }
                        throw new RemoteException(exMessage, ex);
                    }
                    catch (Throwable ex) {
                        Level logLevel;
                        if (ex instanceof ApplicationException) {
                            throw (ApplicationException)ex;
                        }
                        String exMsg = "LRMI transport protocol over NIO connection [" + this.getConnectionURL() + "] caught unexpected exception: " + ex.toString();
                        Level level = logLevel = ex instanceof RuntimeException ? Level.SEVERE : Level.FINE;
                        if (_logger.isLoggable(logLevel)) {
                            _logger.log(logLevel, exMsg, ex);
                        }
                        this.disconnect();
                        if (ex instanceof RemoteException) {
                            throw (RemoteException)ex;
                        }
                        if (ex instanceof RuntimeException) {
                            throw (RuntimeException)ex;
                        }
                        if (ex instanceof ProtocolException) {
                            if (ex.getCause() instanceof NoSuchObjectException) {
                                NoSuchObjectException detailedException = this.handleNoSuchObjectException(lrmiMethod, (NoSuchObjectException)ex.getCause());
                                throw new ProtocolException(exMsg, detailedException);
                            }
                            throw (ProtocolException)ex;
                        }
                        throw new ProtocolException(exMsg, ex);
                    }
                }
                catch (Throwable throwable2) {
                    if (!lrmiMethod.isAsync) {
                        this.afterInvoke();
                    }
                    LRMIConnection.setConnection(previousConnection);
                    this.restoreThreadNameIfNeeded(previousThreadName);
                    throw throwable2;
                }
            }
        }
    }

    private String updateThreadNameIfNeeded() {
        if (!CHANGE_THREAD_NAME_ON_INVOCATION) {
            return null;
        }
        String previousThreadName = Thread.currentThread().getName();
        String newThreadName = previousThreadName + "[" + this._socketDisplayString + "]";
        Thread.currentThread().setName(newThreadName);
        return previousThreadName;
    }

    private void restoreThreadNameIfNeeded(String previousThreadName) {
        if (previousThreadName != null) {
            Thread.currentThread().setName(previousThreadName);
        }
    }

    private NoSuchObjectException handleNoSuchObjectException(LRMIMethod lrmiMethod, NoSuchObjectException ex) {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "LRMI made an attempt to invoke a method [" + LRMIUtilities.getMethodDisplayString(lrmiMethod.realMethod) + "] on an RemoteObject: [" + this.getConnectionURL() + "]\n that no longer  exists in the remote virtual machine.", ex);
        }
        LRMINoSuchObjectException detailedException = new LRMINoSuchObjectException("LRMI made an attempt to invoke a method [" + LRMIUtilities.getMethodDisplayString(lrmiMethod.realMethod) + "] on an RemoteObject: [" + this.getConnectionURL() + "] that no longer  exists in the remote virtual machine", ex);
        return detailedException;
    }

    @Override
    public long getGeneratedTraffic() {
        Writer writer = this._writer;
        return this._generatedTraffic + (writer != null ? writer.getGeneratedTraffic() : 0L);
    }

    @Override
    public long getReceivedTraffic() {
        Reader reader = this._reader;
        return this._receivedTraffic + (reader != null ? reader.getReceivedTraffic() : 0L);
    }

    @Override
    public void disable() {
        this.disconnect();
    }

    @Override
    public boolean sendKeepAlive() {
        try {
            if (!this.isConnected()) {
                return false;
            }
            this._requestPacket.set(-1L, 0, new Object[0], true, false, _dummyMethod, -1L, OperationPriority.REGULAR, this._serviceVersion);
            this._writer.writeRequest(this._requestPacket);
            return true;
        }
        catch (Throwable t) {
            if (_logger.isLoggable(Level.FINE)) {
                String exMessage = "LRMI over NIO broken connection with ServerEndPoint: " + this.getConnectionURL();
                _logger.log(Level.FINE, exMessage, t);
            }
            return false;
        }
    }

    public PlatformLogicalVersion getServiceVersion() {
        return this._serviceVersion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AsyncContext getAsyncContext() {
        Object object = this._memoryBarrierLock;
        synchronized (object) {
            return this._asyncContext;
        }
    }

    public void clearAsyncContext() {
        this._asyncContext = null;
    }

    public int hashCode() {
        if (this.m_Address != null) {
            return this.m_Address.hashCode();
        }
        return 0;
    }

    public String toString() {
        return this.getClass().getName() + "@" + Integer.toHexString(System.identityHashCode(this));
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof CPeer)) {
            return false;
        }
        if (this.m_Address != null) {
            return this.m_Address.equals(((CPeer)obj).m_Address);
        }
        return false;
    }

    static {
        try {
            _dummyMethod = new LRMIMethod(ReflectionUtil.createMethod(CPeer.class.getMethod("sendKeepAlive", new Class[0])), false, false, false, false, false, false, false, -1);
        }
        catch (Exception e) {
            throw new RuntimeException("InternalError: Failed to reflect sendKeepAlive() method.", e);
        }
    }

    private class ClientRemoteClassProviderProvider
    implements IRemoteClassProviderProvider {
        private LRMIRemoteClassLoaderIdentifier _remoteClassLoaderIdentifier;

        private ClientRemoteClassProviderProvider() {
        }

        @Override
        public synchronized IClassProvider getClassProvider() throws IOException, IOFilterException {
            try {
                RequestPacket requestForClass = new RequestPacket(new ClassProviderRequest());
                CPeer.this._writer.writeRequest(requestForClass);
                ReplyPacket response = CPeer.this._reader.readReply(true);
                return (IClassProvider)response.getResult();
            }
            catch (ClassNotFoundException e) {
                IOException exp = new IOException();
                exp.initCause(e);
                throw exp;
            }
        }

        @Override
        public LRMIRemoteClassLoaderIdentifier getRemoteClassLoaderIdentifier() {
            return this._remoteClassLoaderIdentifier;
        }

        @Override
        public LRMIRemoteClassLoaderIdentifier setRemoteClassLoaderIdentifier(LRMIRemoteClassLoaderIdentifier remoteClassLoaderIdentifier) {
            LRMIRemoteClassLoaderIdentifier prev = this._remoteClassLoaderIdentifier;
            this._remoteClassLoaderIdentifier = remoteClassLoaderIdentifier;
            return prev;
        }
    }
}

