/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.lrmi.nio;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.io.MarshalContextClearedException;
import com.gigaspaces.internal.io.MarshalInputStream;
import com.gigaspaces.internal.lrmi.LRMIMonitoringModule;
import com.gigaspaces.internal.utils.StringUtils;
import com.gigaspaces.internal.version.PlatformLogicalVersion;
import com.gigaspaces.lrmi.UIDGen;
import com.gigaspaces.lrmi.classloading.IRemoteClassProviderProvider;
import com.gigaspaces.lrmi.nio.IWriteInterestManager;
import com.gigaspaces.lrmi.nio.Pivot;
import com.gigaspaces.lrmi.nio.Reader;
import com.gigaspaces.lrmi.nio.ReplyPacket;
import com.gigaspaces.lrmi.nio.RequestPacket;
import com.gigaspaces.lrmi.nio.WriteExecutionPhaseListener;
import com.gigaspaces.lrmi.nio.Writer;
import com.gigaspaces.lrmi.nio.filters.IOBlockFilterManager;
import com.gigaspaces.lrmi.nio.filters.IOFilterException;
import com.gigaspaces.lrmi.nio.filters.IOFilterManager;
import com.gigaspaces.lrmi.nio.selector.handler.ReadSelectorThread;
import com.gigaspaces.lrmi.nio.selector.handler.WriteSelectorThread;
import com.gigaspaces.time.SystemTime;
import java.io.IOException;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.space.InternalSpaceException;

@InternalApi
public class ChannelEntry
implements IWriteInterestManager {
    private static final Logger _logger = Logger.getLogger("com.gigaspaces.lrmi");
    private final Pivot _pivot;
    private final SocketChannel _socketChannel;
    private final InetSocketAddress _clientEndPointAddress;
    private final SelectionKey _readSelectionKey;
    public final Writer _writer;
    public final Reader _reader;
    public SelectionKey _writeSelectionKey;
    private long _ownerRemoteObjID;
    public final long _connectionID;
    private final long _connectionTimeStamp;
    private final ReadSelectorThread _readSelectorThread;
    private final WriteSelectorThread _writeSelectorThread;
    private final IRemoteClassProviderProvider _remoteClassProvider = new Pivot.ServerRemoteClassProviderProvider(this);
    private final IOFilterManager _filterManager;
    private boolean _protocolValidated;
    private PlatformLogicalVersion _sourceLogicalVersion;
    private long _sourcePid = -1L;
    private static final Map<String, Long> _rejectedProtocolHosts = new HashMap<String, Long>();
    private final LRMIMonitoringModule _monitoringModule = new LRMIMonitoringModule();
    private final WriteExecutionPhaseListener _writeExecutionPhaseListener = new ChannelEntryWriteExecutionPhaseListener();
    private volatile State _currentChannelState = State.IDLE;
    private volatile boolean _firstMessage = true;

    public ChannelEntry(WriteSelectorThread writeSelectorThread, ReadSelectorThread readSelectorThread, SelectionKey selectionKey, InetSocketAddress clientEndPointAddress, Pivot pivot) {
        SocketChannel channel = (SocketChannel)selectionKey.channel();
        this._pivot = pivot;
        this._readSelectionKey = selectionKey;
        this._readSelectorThread = readSelectorThread;
        this._writeSelectorThread = writeSelectorThread;
        this._socketChannel = channel;
        this._writer = new Writer(channel, this);
        this._reader = new Reader(channel, this._pivot.getSystemRequestHandler());
        this._connectionID = UIDGen.nextId();
        this._connectionTimeStamp = SystemTime.timeMillis();
        this._clientEndPointAddress = clientEndPointAddress;
        try {
            this._filterManager = IOBlockFilterManager.createFilter(this._reader, this._writer, false, this._socketChannel);
        }
        catch (Exception e) {
            throw new InternalSpaceException("Failed to load communication filter " + System.getProperty("com.gs.lrmi.filter.factory"), e);
        }
        if (this._filterManager != null) {
            try {
                this._filterManager.beginHandshake();
            }
            catch (Exception e) {
                throw new InternalSpaceException("Failed to perform communication filter handshake using " + System.getProperty("com.gs.lrmi.filter.factory") + " filter", e);
            }
        }
    }

    public MarshalInputStream readRequest(Reader.Context ctx) {
        try {
            if (this._firstMessage) {
                ctx.messageSizeLimit = 5120;
                this._firstMessage = false;
            }
            return this._reader.readRequest(ctx);
        }
        catch (ClosedChannelException e) {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "Failed to read from " + this.getClientEndPointAddress() + " due to closed channel", e);
            }
        }
        catch (IOFilterException e) {
            if (_logger.isLoggable(Level.WARNING)) {
                _logger.log(Level.WARNING, "Closing connection to " + this.getClientEndPointAddress() + " because of " + e, e);
            }
        }
        catch (ConnectException e) {
            _logger.log(Level.WARNING, "Closing connection to " + this.getClientEndPointAddress() + " because of " + e, e);
        }
        catch (OutOfMemoryError oome) {
            _logger.log(Level.WARNING, "Closing connection to " + this.getClientEndPointAddress() + " because of " + oome + ", message length is " + ctx.dataLength + " bytes", oome);
        }
        catch (Throwable e) {
            this._pivot.handleExceptionFromServer(this._writer, this._reader, e);
        }
        this._pivot.closeConnection(this);
        return null;
    }

    public RequestPacket unmarshall(MarshalInputStream stream) {
        RequestPacket requestPacket;
        block2: {
            requestPacket = null;
            try {
                requestPacket = this._reader.unmarshallRequest(stream);
            }
            catch (Throwable ex) {
                if (!this._pivot.handleExceptionFromServer(this._writer, this._reader, ex)) break block2;
                this._pivot.closeConnection(this);
            }
        }
        return requestPacket;
    }

    public void setOwnerRemoteObjID(long remoteObjID) {
        if (this._ownerRemoteObjID == 0L) {
            this._ownerRemoteObjID = remoteObjID;
        }
    }

    public InetSocketAddress getClientEndPointAddress() {
        if (this._clientEndPointAddress != null) {
            return this._clientEndPointAddress;
        }
        Socket socket = this._socketChannel.socket();
        if (socket == null) {
            return null;
        }
        return (InetSocketAddress)socket.getRemoteSocketAddress();
    }

    public void writeReply(ReplyPacket packet, boolean reuseBuffer, Writer.Context ctx, String monitoringId) {
        try {
            this._writer.writeReply(packet, reuseBuffer, ctx);
            this.monitorActivity(monitoringId);
        }
        catch (MarshalContextClearedException e) {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "Caught marshal context cleared exception, closing connection", e);
            }
            this._pivot.closeConnection(this);
            throw e;
        }
        catch (Exception ex) {
            this._pivot.handleExceptionFromServer(this._writer, this._reader, ex);
            this._pivot.closeConnection(this);
        }
    }

    @Override
    public void removeWriteInterest(boolean restoreReadInterest) {
        this._writeSelectorThread.removeWriteInterest(this._writeSelectionKey);
        this._writeSelectionKey = null;
        if (restoreReadInterest) {
            this.returnSocket();
        }
    }

    @Override
    public void setWriteInterest() {
        this._writeSelectorThread.setWriteInterest(this);
    }

    public long getRemoteObjID() {
        return this._ownerRemoteObjID;
    }

    public long getConnectionTimeStamp() {
        return this._connectionTimeStamp;
    }

    public long getConnectionID() {
        return this._connectionID;
    }

    public void returnSocket() {
        if (this._readSelectorThread != null && this._readSelectionKey != null) {
            this._readSelectionKey.attach(null);
            this._readSelectorThread.registerKey(this._readSelectionKey);
        }
    }

    public void onWriteEvent() {
        try {
            this._writer.onWriteEvent();
        }
        catch (Exception ex) {
            this._pivot.handleExceptionFromServer(this._writer, this._reader, ex);
            this._pivot.closeConnection(this);
        }
    }

    public void close() throws IOException {
        this._socketChannel.close();
        this._writer.closeContext();
        this._reader.closeContext();
    }

    public synchronized void setSourceDetails(PlatformLogicalVersion logicalVersion, long pid) {
        this._sourceLogicalVersion = logicalVersion;
        this._sourcePid = pid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PlatformLogicalVersion getSourcePlatformLogicalVersion() {
        if (this._sourceLogicalVersion == null) {
            ChannelEntry channelEntry = this;
            synchronized (channelEntry) {
                return this._sourceLogicalVersion;
            }
        }
        return this._sourceLogicalVersion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getSourcePid() {
        if (this._sourcePid == -1L) {
            ChannelEntry channelEntry = this;
            synchronized (channelEntry) {
                return this._sourcePid;
            }
        }
        return this._sourcePid;
    }

    public long getGeneratedTraffic() {
        return this._writer.getGeneratedTraffic();
    }

    public long getReceivedTraffic() {
        return this._reader.getReceivedTraffic();
    }

    public IRemoteClassProviderProvider getRemoteClassProvider() {
        return this._remoteClassProvider;
    }

    public SocketChannel getSocketChannel() {
        return this._socketChannel;
    }

    public SelectionKey getReadSelectionKey() {
        return this._readSelectionKey;
    }

    public boolean isProtocolValidated() {
        return this._protocolValidated;
    }

    public boolean readProtocolValidationHeader(Reader.ProtocolValidationContext context) {
        block6: {
            try {
                String protocolHeader = this._reader.readProtocolValidationHeader(context);
                if (!"gigaspaces-lrmi-protocol".startsWith(protocolHeader)) {
                    ChannelEntry.removeObsoleteRejectedProtocolHosts();
                    this.addToRejectedProtocolHosts();
                    return false;
                }
                if ("gigaspaces-lrmi-protocol".equals(protocolHeader)) {
                    ChannelEntry.removeObsoleteRejectedProtocolHosts();
                    this._protocolValidated = true;
                }
                return true;
            }
            catch (IOException e) {
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.log(Level.FINE, "Failed to read protocol header from " + this.getClientEndPointAddress() + " due to IOException", e);
                }
            }
            catch (Throwable t) {
                if (!_logger.isLoggable(Level.SEVERE)) break block6;
                _logger.log(Level.SEVERE, "Failed to read protocol header from " + this.getClientEndPointAddress(), t);
            }
        }
        return false;
    }

    public void monitorActivity(String trackingId) {
        this._monitoringModule.monitorActivity(trackingId, this._writer, this._reader);
    }

    public LRMIMonitoringModule getMonitoringModule() {
        return this._monitoringModule;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToRejectedProtocolHosts() {
        Map<String, Long> map = _rejectedProtocolHosts;
        synchronized (map) {
            String hostName;
            InetSocketAddress clientEndPointAddress = this.getClientEndPointAddress();
            String string = hostName = clientEndPointAddress == null ? null : clientEndPointAddress.getHostName();
            if (StringUtils.hasText(hostName) && !_rejectedProtocolHosts.containsKey(hostName)) {
                long currentTime = SystemTime.timeMillis();
                _rejectedProtocolHosts.put(hostName, currentTime);
                if (_logger.isLoggable(Level.WARNING)) {
                    _logger.warning("Incoming communication from " + this.getClientEndPointAddress() + " using unrecognized protocol, closing channel");
                }
            }
        }
    }

    public State getChannelState() {
        return this._currentChannelState;
    }

    public void setChannelState(State state) {
        this._currentChannelState = state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void removeObsoleteRejectedProtocolHosts() {
        Map<String, Long> map = _rejectedProtocolHosts;
        synchronized (map) {
            long currentTime = SystemTime.timeMillis();
            Iterator<Map.Entry<String, Long>> iterator = _rejectedProtocolHosts.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, Long> entry = iterator.next();
                if (currentTime - entry.getValue() <= 300000L) continue;
                iterator.remove();
            }
        }
    }

    public WriteExecutionPhaseListener getWriteExecutionPhaseListener() {
        return this._writeExecutionPhaseListener;
    }

    public static enum State {
        NONE(0),
        PROGRESS(1),
        IDLE(2);

        int code;

        private State(int code) {
            this.code = code;
        }

        public int getCode() {
            return this.code;
        }

        public static State fromCode(int code) {
            switch (code) {
                case 0: {
                    return NONE;
                }
                case 1: {
                    return PROGRESS;
                }
                case 2: {
                    return IDLE;
                }
            }
            throw new IllegalArgumentException("No such state: " + code);
        }
    }

    private class ChannelEntryWriteExecutionPhaseListener
    implements WriteExecutionPhaseListener {
        private ChannelEntryWriteExecutionPhaseListener() {
        }

        @Override
        public void onPhase(Writer.Context.Phase phase) {
            if (phase == Writer.Context.Phase.FINISH) {
                ChannelEntry.this.setChannelState(State.IDLE);
            }
        }
    }
}

