/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.lrmi.nio;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.lrmi.nio.CPeer;
import com.gigaspaces.lrmi.nio.watchdog.Watchdog;

@InternalApi
public class ClientPeerWatchedObjectsContext {
    private final Watchdog.WatchedObject _watchedRequestObject;
    private final Watchdog.WatchedObject _watchedResponseObject;
    private final Watchdog.WatchedObject _watchedIdle;
    private WatchedObject _currentlyWatchedObject = WatchedObject.NONE;

    public ClientPeerWatchedObjectsContext(CPeer cpeer) {
        this._watchedRequestObject = Watchdog.getGroup(Watchdog.Group.REQUEST_GROUP).addRequestWatch(cpeer.getChannel(), cpeer);
        this._watchedResponseObject = Watchdog.getGroup(Watchdog.Group.RESPONSE_GROUP).addResponseWatch(cpeer.getChannel(), cpeer);
        this._watchedIdle = Watchdog.getGroup(Watchdog.Group.IDLE_GROUP).addIdleWatch(cpeer);
    }

    public void close() {
        Watchdog.getGroup(Watchdog.Group.REQUEST_GROUP).removeWatch(this._watchedRequestObject);
        Watchdog.getGroup(Watchdog.Group.RESPONSE_GROUP).removeWatch(this._watchedResponseObject);
        Watchdog.getGroup(Watchdog.Group.IDLE_GROUP).removeWatch(this._watchedIdle);
    }

    public void watchIdle() {
        this.watch(WatchedObject.IDLE, "");
    }

    public void watchRequest(String monitoringId) {
        this.watch(WatchedObject.REQUEST, monitoringId);
    }

    public void watchResponse(String monitoringId) {
        this.watch(WatchedObject.RESPONSE, monitoringId);
    }

    public void watchNone() {
        this.watch(WatchedObject.NONE, "");
    }

    public boolean requestWatchHasException() {
        return this._watchedRequestObject.getException() != null;
    }

    public Exception getAndClearRequestWatchException() {
        Exception result = this._watchedRequestObject.getException();
        this._watchedRequestObject.setException(null);
        return result;
    }

    public boolean responseWatchHasException() {
        return this._watchedResponseObject.getException() != null;
    }

    public Exception getAndClearResponseWatchException() {
        Exception result = this._watchedResponseObject.getException();
        this._watchedResponseObject.setException(null);
        return result;
    }

    private void watch(WatchedObject toWatch, String monitoringId) {
        WatchedObject currentlyWatched = this._currentlyWatchedObject;
        if (currentlyWatched == toWatch) {
            return;
        }
        switch (currentlyWatched) {
            case IDLE: {
                this._watchedIdle.stopWatch();
                this._watchedIdle.setMonitoringId(null);
                break;
            }
            case REQUEST: {
                this._watchedRequestObject.stopWatch();
                this._watchedRequestObject.setMonitoringId(null);
                break;
            }
            case RESPONSE: {
                this._watchedResponseObject.stopWatch();
                this._watchedResponseObject.incrementVersion();
                this._watchedResponseObject.setMonitoringId(null);
                break;
            }
            case NONE: {
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported state: " + (Object)((Object)currentlyWatched));
            }
        }
        switch (toWatch) {
            case IDLE: {
                this._watchedIdle.setMonitoringId(monitoringId);
                this._watchedIdle.startWatch();
                break;
            }
            case REQUEST: {
                this._watchedRequestObject.setMonitoringId(monitoringId);
                this._watchedRequestObject.startWatch();
                break;
            }
            case RESPONSE: {
                this._watchedResponseObject.setMonitoringId(monitoringId);
                this._watchedResponseObject.startWatch();
                break;
            }
            case NONE: {
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported state: " + (Object)((Object)toWatch));
            }
        }
        this._currentlyWatchedObject = toWatch;
    }

    private static enum WatchedObject {
        NONE,
        IDLE,
        REQUEST,
        RESPONSE;

    }
}

