/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.lrmi.nio;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.management.transport.ITransportConnection;
import java.util.Date;

@InternalApi
public class NIOTransportConnection
implements ITransportConnection {
    private static final long serialVersionUID = 1L;
    static final String TRANSPORT_PROTOCOL_NAME = "NIO";
    long remoteObjID;
    long connectionID;
    Date connectTime;
    String serverIPAddress;
    int serverPort;
    String clientIPAddress;
    int clientPort;

    public NIOTransportConnection(long remoteObjID, long connectionID, long connectTime, String clientIPAddress, int clientPort, String serverIPAddress, int serverPort) {
        this.remoteObjID = remoteObjID;
        this.connectionID = connectionID;
        this.connectTime = new Date(connectTime);
        this.clientIPAddress = clientIPAddress;
        this.clientPort = clientPort;
        this.serverIPAddress = serverIPAddress;
        this.serverPort = serverPort;
    }

    @Override
    public long getRemoteObjID() {
        return this.remoteObjID;
    }

    @Override
    public Date getConnectTime() {
        return this.connectTime;
    }

    @Override
    public String getServerIPAddress() {
        return this.serverIPAddress;
    }

    @Override
    public String getClientIPAddress() {
        return this.clientIPAddress;
    }

    @Override
    public int getClientPort() {
        return this.clientPort;
    }

    @Override
    public int getServerPort() {
        return this.serverPort;
    }

    @Override
    public long getConnectionID() {
        return this.connectionID;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("NIO Transport Protocol info:");
        sb.append("\nRemoteObjectID: " + this.getRemoteObjID());
        sb.append("\nConnectionID: " + this.getConnectionID());
        sb.append("\nConnectionTime: " + this.getConnectTime());
        sb.append("\nClient IP Address: " + this.getClientIPAddress() + ":" + this.getClientPort());
        sb.append("\nServer IP Address: " + this.getServerIPAddress() + ":" + this.getClientPort());
        return sb.toString();
    }
}

