/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.lrmi.nio;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.config.ConfigurationException;
import com.gigaspaces.config.lrmi.ITransportConfig;
import com.gigaspaces.config.lrmi.nio.NIOConfiguration;
import com.gigaspaces.internal.lrmi.LRMIMonitoringDetailsImpl;
import com.gigaspaces.internal.utils.concurrent.GSThread;
import com.gigaspaces.internal.version.PlatformLogicalVersion;
import com.gigaspaces.lrmi.ClientPeerInvocationHandler;
import com.gigaspaces.lrmi.ConnPoolInvocationHandler;
import com.gigaspaces.lrmi.ConnectionPool;
import com.gigaspaces.lrmi.DynamicSmartStub;
import com.gigaspaces.lrmi.GenericExporter;
import com.gigaspaces.lrmi.LRMIRuntime;
import com.gigaspaces.lrmi.ProtocolAdapter;
import com.gigaspaces.lrmi.ServerPeer;
import com.gigaspaces.lrmi.classloading.DefaultClassProvider;
import com.gigaspaces.lrmi.classloading.IClassProvider;
import com.gigaspaces.lrmi.nio.CPeer;
import com.gigaspaces.lrmi.nio.Pivot;
import com.gigaspaces.lrmi.nio.SPeer;
import com.gigaspaces.lrmi.nio.selector.handler.client.ClientConversationRunner;
import com.gigaspaces.lrmi.nio.selector.handler.client.ClientHandler;
import com.gigaspaces.management.transport.ITransportConnection;
import com.j_spaces.core.service.ServiceConfigLoader;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.rmi.RemoteException;
import java.rmi.server.ExportException;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;

@InternalApi
public class PAdapter
implements ProtocolAdapter<CPeer> {
    private static final Logger _logger = Logger.getLogger("com.gigaspaces.lrmi");
    static final String ADAPTER_NAME = "NIO";
    private Pivot m_Pivot;
    private NIOConfiguration _nioConfig;
    private GenericExporter _exporter;
    private IClassProvider _classProvider;
    private ClientHandler[] _handlers;
    private ClientConversationRunner _clientConversationRunner;
    private final AtomicInteger nextIndex = new AtomicInteger(0);
    private volatile boolean _clientSideInitialized = false;
    private volatile boolean _serverSideInitialized = false;
    private boolean _shutdown = false;

    @Override
    public synchronized void init(ITransportConfig config, ProtocolAdapter.Side initSide) throws RemoteException, ConfigurationException {
        if (!this._shutdown) {
            NIOConfiguration nioConfig = (NIOConfiguration)config;
            if (initSide == ProtocolAdapter.Side.CLIENT) {
                this.clientSideInit();
            } else {
                this.serverSideInit(nioConfig);
            }
        }
    }

    private void clientSideInit() throws RemoteException {
        if (this._clientSideInitialized) {
            return;
        }
        this._clientSideInitialized = true;
        this._exporter = (GenericExporter)ServiceConfigLoader.getExporter();
        this.initClassProvider();
        this._handlers = new ClientHandler[4];
        for (int i = 0; i < this._handlers.length; ++i) {
            try {
                this._handlers[i] = new ClientHandler();
                GSThread writeThread = new GSThread((Runnable)this._handlers[i], "LRMI-async-Selector-Thread-" + i);
                writeThread.setDaemon(true);
                writeThread.start();
                continue;
            }
            catch (IOException e) {
                _logger.log(Level.SEVERE, "cant create a selector for async calls", e);
                throw new IllegalStateException("cant create a selector for async calls", e);
            }
        }
        try {
            this._clientConversationRunner = new ClientConversationRunner();
            GSThread writeThread = new GSThread((Runnable)this._clientConversationRunner, "LRMI-async-client-connection-Thread-");
            writeThread.setDaemon(true);
            writeThread.start();
        }
        catch (Exception e) {
            _logger.log(Level.SEVERE, "cant create a selector for connect", e);
            throw new IllegalStateException("cant create a selector for connect", e);
        }
    }

    private synchronized void initClassProvider() throws ExportException {
        if (this._classProvider == null) {
            DefaultClassProvider provider = new DefaultClassProvider(String.valueOf(LRMIRuntime.getRuntime().getID()));
            this._classProvider = (IClassProvider)this._exporter.export(provider, false);
        }
    }

    private void serverSideInit(NIOConfiguration config) throws RemoteException {
        if (this._serverSideInitialized) {
            return;
        }
        this._nioConfig = config;
        this._exporter = (GenericExporter)ServiceConfigLoader.getExporter();
        this.initClassProvider();
        if (_logger.isLoggable(Level.CONFIG)) {
            _logger.config(config.toString());
        }
        try {
            this.m_Pivot = new Pivot(this._nioConfig, this);
        }
        catch (IOException ex) {
            throw new RemoteException("Failed initialization of LRMI over NIO Protocol Adapter.", ex);
        }
        this._serverSideInitialized = true;
    }

    private synchronized ClientHandler getClientHandler() {
        if (this._handlers == null) {
            throw new IllegalStateException("attempt to getClientHandler but handlers are not initialized, client side initialized state = " + this._clientSideInitialized);
        }
        return this._handlers[this.nextIndex.getAndIncrement() % this._handlers.length];
    }

    private ClientConversationRunner getClientConversationRunner() {
        return this._clientConversationRunner;
    }

    @Override
    public IClassProvider getClassProvider() {
        return this._classProvider;
    }

    @Override
    public int getPort() {
        return this.m_Pivot.getPort();
    }

    @Override
    public String getHostName() {
        return this.m_Pivot.getHostName();
    }

    @Override
    public String getName() {
        return ADAPTER_NAME;
    }

    public InetSocketAddress getBindInetSocketAddress() {
        return this.m_Pivot.getServerBindInetSocketAddress();
    }

    @Override
    public CPeer getClientPeer(PlatformLogicalVersion serviceVersion) {
        return new CPeer(this, this.getClientHandler(), this.getClientConversationRunner(), serviceVersion);
    }

    @Override
    public ServerPeer newServerPeer(long objectId, ClassLoader objectClassLoader, String serviceDetails) {
        return new SPeer(this, objectId, objectClassLoader, serviceDetails);
    }

    public Pivot getPivot() {
        return this.m_Pivot;
    }

    @Override
    public synchronized void shutdown() {
        this._shutdown = true;
        if (this._handlers != null) {
            for (ClientHandler handler : this._handlers) {
                if (handler == null) continue;
                handler.shutdown();
            }
        }
        if (this.m_Pivot != null) {
            this.m_Pivot.shutdown();
        }
        this._exporter.unexport(this._classProvider);
    }

    @Override
    public List<ITransportConnection> getRemoteObjectConnectionsList(long objectId) {
        return this.m_Pivot.getRemoteObjectConnectionsList(objectId);
    }

    @Override
    public int countRemoteObjectConnections(long objectId) {
        return this.m_Pivot.countRemoteObjectConnections(objectId);
    }

    @Override
    public ClientPeerInvocationHandler getClientInvocationHandler(String connectionURL, ITransportConfig config, PlatformLogicalVersion serviceVersion) {
        ConnectionPool connPool = new ConnectionPool(this, config, connectionURL, serviceVersion);
        return new ConnPoolInvocationHandler(connPool);
    }

    @Override
    public LRMIMonitoringDetailsImpl getMonitoringDetails() {
        return new LRMIMonitoringDetailsImpl(this.m_Pivot.getMonitoringDetails(), DynamicSmartStub.getMonitoringDetails());
    }
}

