/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.lrmi.nio;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.config.lrmi.nio.NIOConfiguration;
import com.gigaspaces.exception.lrmi.LRMIUnhandledException;
import com.gigaspaces.exception.lrmi.ProtocolException;
import com.gigaspaces.internal.collections.CollectionsFactory;
import com.gigaspaces.internal.collections.LongObjectMap;
import com.gigaspaces.internal.io.MarshalContextClearedException;
import com.gigaspaces.internal.io.MarshalInputStream;
import com.gigaspaces.internal.lrmi.LRMIInboundMonitoringDetailsImpl;
import com.gigaspaces.internal.lrmi.LRMIServiceMonitoringDetailsImpl;
import com.gigaspaces.internal.utils.concurrent.ContextClassLoaderRunnable;
import com.gigaspaces.internal.version.PlatformLogicalVersion;
import com.gigaspaces.lrmi.ILRMIService;
import com.gigaspaces.lrmi.LRMIInvocationContext;
import com.gigaspaces.lrmi.LRMIInvocationTrace;
import com.gigaspaces.lrmi.LRMIMethod;
import com.gigaspaces.lrmi.LRMIRuntime;
import com.gigaspaces.lrmi.ObjectRegistry;
import com.gigaspaces.lrmi.OperationPriority;
import com.gigaspaces.lrmi.ProtocolAdapter;
import com.gigaspaces.lrmi.ServerPeer;
import com.gigaspaces.lrmi.classloading.ClassProviderRequest;
import com.gigaspaces.lrmi.classloading.IClassProvider;
import com.gigaspaces.lrmi.classloading.IRemoteClassProviderProvider;
import com.gigaspaces.lrmi.classloading.LRMIRemoteClassLoaderIdentifier;
import com.gigaspaces.lrmi.classloading.protocol.lrmi.HandshakeRequest;
import com.gigaspaces.lrmi.classloading.protocol.lrmi.LRMIConnection;
import com.gigaspaces.lrmi.nio.ChannelEntry;
import com.gigaspaces.lrmi.nio.DefaultResponseHandler;
import com.gigaspaces.lrmi.nio.IResponseContext;
import com.gigaspaces.lrmi.nio.LRMIMethodTrackingIdProvider;
import com.gigaspaces.lrmi.nio.NIOTransportConnection;
import com.gigaspaces.lrmi.nio.NIOUtils;
import com.gigaspaces.lrmi.nio.PivotResponseContext;
import com.gigaspaces.lrmi.nio.Reader;
import com.gigaspaces.lrmi.nio.ReplyPacket;
import com.gigaspaces.lrmi.nio.RequestPacket;
import com.gigaspaces.lrmi.nio.ResponseContext;
import com.gigaspaces.lrmi.nio.SystemRequestHandler;
import com.gigaspaces.lrmi.nio.SystemRequestHandlerImpl;
import com.gigaspaces.lrmi.nio.Writer;
import com.gigaspaces.lrmi.nio.filters.IOFilterException;
import com.gigaspaces.lrmi.nio.selector.SelectorManager;
import com.gigaspaces.lrmi.nio.selector.handler.ReadSelectorThread;
import com.gigaspaces.lrmi.nio.selector.handler.WriteSelectorThread;
import com.gigaspaces.management.transport.ITransportConnection;
import com.j_spaces.kernel.ClassLoaderHelper;
import java.io.IOException;
import java.io.InvalidClassException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.rmi.NoSuchObjectException;
import java.rmi.Remote;
import java.rmi.UnmarshalException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jini.rio.boot.LoggableClassLoader;

@InternalApi
public class Pivot {
    private static final Logger _logger = Logger.getLogger("com.gigaspaces.lrmi");
    private static final Logger _contextLogger = Logger.getLogger("com.gigaspaces.lrmi.context");
    private final IClassProvider _classProvider;
    private final Map<SocketAddress, ChannelEntry> _clientToChannel;
    private final Map<SocketChannel, ChannelEntry> m_Channels;
    private final Executor _threadPool;
    private final Executor _livenessPriorityThreadPool;
    private final Executor _monitoringPriorityThreadPool;
    private final Executor _customThreadPool;
    private final SelectorManager _selectorManager;
    private final DefaultResponseHandler _defaultResponseHandler = new DefaultResponseHandler();
    private final boolean _protocolValidationEnabled;
    private final SystemRequestHandler _systemRequestHandler = new SystemRequestHandlerImpl();

    public Pivot(NIOConfiguration config, ProtocolAdapter protocol) throws IOException {
        this._classProvider = protocol.getClassProvider();
        this._clientToChannel = new ConcurrentHashMap<SocketAddress, ChannelEntry>();
        this.m_Channels = new ConcurrentHashMap<SocketChannel, ChannelEntry>();
        this._selectorManager = new SelectorManager(this, config.getBindHostName(), config.getBindPort(), config.getReadSelectorThreads());
        this._threadPool = LRMIRuntime.getRuntime().getThreadPool();
        this._livenessPriorityThreadPool = LRMIRuntime.getRuntime().getLivenessPriorityThreadPool();
        this._monitoringPriorityThreadPool = LRMIRuntime.getRuntime().getMonitoringPriorityThreadPool();
        this._customThreadPool = LRMIRuntime.getRuntime().getCustomThreadPool();
        this._protocolValidationEnabled = config.isProtocolValidationEnabled();
    }

    void shutdown() {
        this._selectorManager.requestShutdown();
        LinkedList<ChannelEntry> channelEntries = new LinkedList<ChannelEntry>(this.m_Channels.values());
        for (ChannelEntry chEntry : channelEntries) {
            this.closeConnection(chEntry);
        }
    }

    public int getPort() {
        return this._selectorManager.getPort();
    }

    public String getHostName() {
        return this._selectorManager.getHostName();
    }

    public static boolean isMonitorActivity() {
        return LRMIRuntime.getRuntime().isMonitorActivity();
    }

    public boolean handleExceptionFromServer(Writer writer, Reader reader, Throwable ex) {
        if (ex instanceof ClosedChannelException) {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "Connection with client closed from [" + writer.getEndPointAddress() + "] endpoint.");
            }
            return true;
        }
        if (ex instanceof MarshalContextClearedException) {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "Marshal context have been cleared, probably because the exported service class loader has been unloaded, service incoming invocation from [" + writer.getEndPointAddress() + "] endpoint.");
            }
            return true;
        }
        try {
            String msg = "LRMI Transport Protocol caught server exception caused by [" + writer.getEndPointAddress() + "] client.";
            if (ex instanceof LRMIUnhandledException) {
                LRMIUnhandledException lrmiue;
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.log(Level.FINE, msg, ex);
                }
                if ((lrmiue = (LRMIUnhandledException)ex).getStage() == LRMIUnhandledException.Stage.DESERIALIZATION) {
                    reader.resetContext();
                }
                if (writer.isOpen()) {
                    writer.writeReply(new ReplyPacket<Object>(null, lrmiue));
                }
                return false;
            }
            if (ex instanceof RuntimeException || ex instanceof InvalidClassException) {
                if (_logger.isLoggable(Level.SEVERE)) {
                    _logger.log(Level.SEVERE, msg, ex);
                }
            } else if (ex instanceof UnmarshalException) {
                if (_logger.isLoggable(Level.WARNING)) {
                    _logger.log(Level.WARNING, msg, ex);
                }
            } else if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, msg, ex);
            }
            if (writer.isOpen()) {
                writer.writeReply(new ReplyPacket<Object>(null, new ProtocolException(msg, ex)));
            }
            return true;
        }
        catch (Exception ex2) {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "Failed to send handledServerException to endpoint [" + writer.getEndPointAddress() + "] , the client disconnected from the server.", ex);
            }
            return true;
        }
    }

    public ChannelEntry newConnection(ReadSelectorThread readHandler, SelectionKey key) {
        SocketChannel channel = (SocketChannel)key.channel();
        WriteSelectorThread writeHandler = this._selectorManager.getWriteHandler(key.channel());
        Socket socket = channel.socket();
        InetSocketAddress socketAddress = (InetSocketAddress)(socket == null ? null : socket.getRemoteSocketAddress());
        ChannelEntry channelEntry = new ChannelEntry(writeHandler, readHandler, key, socketAddress, this);
        this.m_Channels.put(channel, channelEntry);
        if (socketAddress != null) {
            this._clientToChannel.put(socketAddress, channelEntry);
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "Connected new client from [" + channelEntry.getClientEndPointAddress() + "] endpoint.");
        }
        return channelEntry;
    }

    public synchronized void closeConnection(ChannelEntry channelEntry) {
        block5: {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "Connection with client closed from [" + channelEntry.getClientEndPointAddress() + "] endpoint.");
            }
            try {
                SocketAddress socketAddress;
                SocketChannel socketChannel;
                Socket socket;
                if (channelEntry.getReadSelectionKey() != null) {
                    channelEntry.getReadSelectionKey().cancel();
                }
                if ((socket = (socketChannel = channelEntry.getSocketChannel()).socket()) != null && (socketAddress = socket.getRemoteSocketAddress()) != null) {
                    this._clientToChannel.remove(socketAddress);
                }
                channelEntry.close();
                this.m_Channels.remove(socketChannel);
            }
            catch (IOException ex) {
                if (!_logger.isLoggable(Level.FINE)) break block5;
                _logger.log(Level.FINE, ex.toString(), ex);
            }
        }
    }

    public void handleProtocolValidation(ChannelEntry channelEntry, Reader.ProtocolValidationContext context, ReadSelectorThread handler) {
        boolean keepChannelOpen = channelEntry.readProtocolValidationHeader(context);
        if (!keepChannelOpen) {
            this.closeConnection(channelEntry);
        } else {
            if (channelEntry.isProtocolValidated()) {
                context.selectionKey.attach(null);
            }
            handler.registerKey(context.selectionKey);
        }
    }

    public void handleReadRequest(ChannelEntry channelEntry, Reader.Context ctx, ReadSelectorThread handler) {
        Runnable task;
        OperationPriority operationPriority;
        MarshalInputStream stream = channelEntry.readRequest(ctx);
        if (ctx.phase != Reader.Context.Phase.FINISH || stream == null && !ctx.isSystemRequest()) {
            handler.registerKey(ctx.selectionKey);
            return;
        }
        ctx.selectionKey.attach(null);
        if (ctx.isSystemRequest()) {
            operationPriority = OperationPriority.MONITORING;
            task = ctx.systemRequestContext.getResponseTask(this, channelEntry, ctx.startTimestamp);
        } else {
            operationPriority = RequestPacket.getOperationPriorityFromBytes(ctx.bytes);
            task = new ChannelEntryTask(this, channelEntry, stream);
        }
        this.executeAccordingToPriority(operationPriority, task);
    }

    public void requestPending(ChannelEntry channel, ReplyPacket<?> respPacket, IResponseContext responseContext) {
        this.executeAccordingToPriority(responseContext.getOperationPriority(), new ReplyTask(this, channel, respPacket, responseContext));
    }

    private void executeAccordingToPriority(OperationPriority operationPriority, Runnable command) {
        switch (operationPriority) {
            case CUSTOM: {
                this._customThreadPool.execute(command);
                break;
            }
            case LIVENESS: {
                this._livenessPriorityThreadPool.execute(command);
                break;
            }
            case MONITORING: {
                this._monitoringPriorityThreadPool.execute(command);
                break;
            }
            case REGULAR: {
                this._threadPool.execute(command);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ReplyPacket consumeAndHandleRequest(RequestPacket requestPacket, IResponseContext respContext, ChannelEntry channelEntry) {
        Object reqObject = requestPacket.getRequestObject();
        if (reqObject != null) {
            if (reqObject instanceof ClassProviderRequest) {
                return new ReplyPacket<IClassProvider>(this._classProvider, null);
            }
            if (reqObject instanceof HandshakeRequest) {
                HandshakeRequest handshakeRequest = (HandshakeRequest)reqObject;
                channelEntry.setSourceDetails(handshakeRequest.getSourcePlatformLogicalVersion(), handshakeRequest.getSourcePid());
                return new ReplyPacket<Object>(null, null);
            }
        }
        boolean sendResponse = true;
        Exception resultEx = null;
        Object result = null;
        try {
            if (requestPacket.isOneWay()) {
                channelEntry.returnSocket();
                sendResponse = false;
            }
            if (requestPacket.getObjectId() != -1L) {
                if (requestPacket.getInvokeMethod() == null) {
                    _logger.log(Level.WARNING, "canceling invocation of request packet without invokeMethod : " + requestPacket);
                } else {
                    result = LRMIRuntime.getRuntime().invoked(requestPacket.getObjectId(), requestPacket.getInvokeMethod().realMethod, requestPacket.getArgs());
                }
            }
        }
        catch (NoSuchObjectException ex) {
            if (requestPacket.isOneWay() && _logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "Failed to invoke one way method : " + requestPacket.getInvokeMethod() + "\nReason: This remoteObject: " + requestPacket.getObjectId() + " has been already unexported.", ex);
            }
            resultEx = ex;
        }
        catch (Exception ex) {
            resultEx = ex;
        }
        finally {
            if (requestPacket.isCallBack) {
                sendResponse = respContext.shouldSendResponse();
            }
        }
        if (requestPacket.isOneWay() && resultEx != null && _logger.isLoggable(Level.SEVERE)) {
            _logger.log(Level.SEVERE, "Failed to invoke one-way method: " + requestPacket.getInvokeMethod(), resultEx);
        }
        if (!sendResponse) {
            return null;
        }
        return new ReplyPacket<Object>(result, resultEx);
    }

    public ChannelEntry getChannelEntryFromChannel(SocketChannel channel) {
        return this.m_Channels.get(channel);
    }

    public InetSocketAddress getServerBindInetSocketAddress() {
        return this._selectorManager.getBindInetSocketAddress();
    }

    public void handleRequest(RequestPacket requestPacket, ChannelEntry channelEntry) {
        channelEntry.setOwnerRemoteObjID(requestPacket.getObjectId());
        PivotResponseContext respContext = null;
        String monitoringId = Pivot.extractMonitoringId(requestPacket);
        if (requestPacket.isCallBack) {
            LRMIInvocationTrace trace = _contextLogger.isLoggable(Level.FINE) ? LRMIInvocationContext.getCurrentContext().getTrace() : null;
            respContext = new PivotResponseContext(this, channelEntry, this._defaultResponseHandler, LRMIInvocationContext.getCurrentContext().getSourceLogicalVersion(), requestPacket.operationPriority, monitoringId, trace);
            ResponseContext.setExistingResponseContext(respContext);
        }
        ReplyPacket replyPacket = this.consumeAndHandleRequest(requestPacket, respContext, channelEntry);
        ResponseContext.clearResponseContext();
        if (replyPacket == null) {
            if (Pivot.isMonitorActivity()) {
                channelEntry.monitorActivity(monitoringId);
            }
            return;
        }
        boolean reuseBuffer = requestPacket.getRequestObject() == null;
        this.sendResponse(channelEntry, replyPacket, respContext, reuseBuffer, monitoringId);
    }

    public static String extractMonitoringId(RequestPacket requestPacket) {
        LRMIMethod lrmiMethod = requestPacket.getInvokeMethod();
        if (lrmiMethod == null) {
            return null;
        }
        if (!lrmiMethod.isCustomTracking) {
            return lrmiMethod.realMethodString;
        }
        Object[] args = requestPacket.getArgs();
        if (args.length < 1) {
            return lrmiMethod.realMethodString;
        }
        Object trackingParam = args[0];
        if (!(trackingParam instanceof LRMIMethodTrackingIdProvider)) {
            return lrmiMethod.realMethodString;
        }
        return ((LRMIMethodTrackingIdProvider)trackingParam).getLRMIMethodTrackingId();
    }

    public void sendResponse(ChannelEntry channelEntry, ReplyPacket replyPacket, IResponseContext respContext) {
        this.sendResponse(channelEntry, replyPacket, respContext, true, respContext.getLRMIMonitoringId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendResponse(ChannelEntry channelEntry, ReplyPacket replyPacket, IResponseContext respContext, boolean reuseBuffer, String monitoringId) {
        try {
            boolean changeCL;
            LRMIInvocationContext.updateContext(null, null, (LRMIInvocationContext.InvocationStage)LRMIInvocationContext.InvocationStage.SERVER_MARSHAL_REPLY, null, null, (boolean)false, null, null);
            if (respContext != null && !respContext.markAsSentResponse()) {
                _logger.severe("Trying to send a response twice using the same response context.");
                return;
            }
            LRMIInvocationTrace trace = respContext != null ? respContext.getTrace() : (_contextLogger.isLoggable(Level.FINE) ? LRMIInvocationContext.getCurrentContext().getTrace() : null);
            Writer.ChannelEntryContext ctx = new Writer.ChannelEntryContext(trace, channelEntry.getWriteExecutionPhaseListener());
            ObjectRegistry.Entry entry = LRMIRuntime.getRuntime().getRegistryObject(channelEntry.getRemoteObjID());
            ClassLoader orgThreadCL = Thread.currentThread().getContextClassLoader();
            ClassLoader marshalClassLoader = entry != null ? entry.getExportedThreadClassLoader() : orgThreadCL;
            boolean bl = changeCL = orgThreadCL != marshalClassLoader;
            if (changeCL) {
                ClassLoaderHelper.setContextClassLoader(marshalClassLoader, true);
            }
            try {
                channelEntry.writeReply(replyPacket, reuseBuffer, ctx, monitoringId);
            }
            finally {
                if (changeCL) {
                    ClassLoaderHelper.setContextClassLoader(orgThreadCL, true);
                }
            }
        }
        catch (Exception ex) {
            this.handleExceptionFromServer(channelEntry._writer, channelEntry._reader, ex);
        }
    }

    protected List<ChannelEntry> getChannels(long remoteObjID) {
        LinkedList<ChannelEntry> channelEntries = new LinkedList<ChannelEntry>(this.m_Channels.values());
        Iterator iter = channelEntries.iterator();
        while (iter.hasNext()) {
            ChannelEntry chEntry = (ChannelEntry)iter.next();
            if (chEntry.getRemoteObjID() == remoteObjID) continue;
            iter.remove();
        }
        return channelEntries;
    }

    public void unexport(long remoteObjID) {
        List<ChannelEntry> channelEntries = this.getChannels(remoteObjID);
        for (ChannelEntry chEntry : channelEntries) {
            this.closeConnection(chEntry);
        }
    }

    public List<ITransportConnection> getRemoteObjectConnectionsList(long remoteObjID) {
        ArrayList<ITransportConnection> result = new ArrayList<ITransportConnection>();
        for (ChannelEntry channelEntry : this.m_Channels.values()) {
            InetSocketAddress clientEndPoint;
            if (channelEntry.getRemoteObjID() != remoteObjID || (clientEndPoint = this.getClientEndPointAddress(channelEntry)) == null) continue;
            result.add(new NIOTransportConnection(remoteObjID, channelEntry.getConnectionID(), channelEntry.getConnectionTimeStamp(), clientEndPoint.getAddress().getHostAddress(), clientEndPoint.getPort(), this.getServerBindInetSocketAddress().getAddress().getHostAddress(), this.getServerBindInetSocketAddress().getPort()));
        }
        return result;
    }

    public int countRemoteObjectConnections(long remoteObjID) {
        int result = 0;
        for (ChannelEntry channelEntry : this.m_Channels.values()) {
            if (channelEntry.getRemoteObjID() != remoteObjID || this.getClientEndPointAddress(channelEntry) == null) continue;
            ++result;
        }
        return result;
    }

    private InetSocketAddress getClientEndPointAddress(ChannelEntry channelEntry) {
        InetSocketAddress clientEndPoint = channelEntry.getClientEndPointAddress();
        if (clientEndPoint == null) {
            return null;
        }
        return clientEndPoint.getAddress() == null ? null : clientEndPoint;
    }

    public boolean isProtocolValidationEnabled() {
        return this._protocolValidationEnabled;
    }

    public LRMIInboundMonitoringDetailsImpl getMonitoringDetails() {
        Collection<ChannelEntry> channels = this.m_Channels.values();
        LongObjectMap<LRMIServiceMonitoringDetailsImpl> servicesTrackingDetails = CollectionsFactory.getInstance().createLongObjectMap();
        for (ChannelEntry channelEntry : channels) {
            long remoteObjID = channelEntry.getRemoteObjID();
            ObjectRegistry.Entry registryObject = LRMIRuntime.getRuntime().getRegistryObject(remoteObjID);
            if (registryObject == null) continue;
            Remote exportedService = registryObject.m_Object;
            LRMIServiceMonitoringDetailsImpl monitoringDetails = (LRMIServiceMonitoringDetailsImpl)servicesTrackingDetails.get(remoteObjID);
            if (monitoringDetails == null) {
                String serviceDetails = Pivot.getServiceDetails(exportedService);
                ClassLoader classLoader = registryObject.getExportedThreadClassLoader();
                String serviceClassLoaderDetails = classLoader instanceof LoggableClassLoader ? ((LoggableClassLoader)classLoader).getLogName() : classLoader.toString();
                ServerPeer serverPeer = registryObject.getServerPeer();
                String connectionUrl = serverPeer != null ? serverPeer.getConnectionURL() : null;
                monitoringDetails = new LRMIServiceMonitoringDetailsImpl(serviceDetails, serviceClassLoaderDetails, remoteObjID, connectionUrl);
                servicesTrackingDetails.put(remoteObjID, monitoringDetails);
            }
            monitoringDetails.addChannelDetails(channelEntry);
        }
        return new LRMIInboundMonitoringDetailsImpl(servicesTrackingDetails.getValues(new LRMIServiceMonitoringDetailsImpl[servicesTrackingDetails.size()]));
    }

    public SystemRequestHandler getSystemRequestHandler() {
        return this._systemRequestHandler;
    }

    public ChannelEntry.State getChannelEntryState(SocketAddress monitoredClient) {
        ChannelEntry channelEntry = this._clientToChannel.get(monitoredClient);
        if (channelEntry == null) {
            return ChannelEntry.State.NONE;
        }
        return channelEntry.getChannelState();
    }

    public static String getServiceDetails(Remote exportedService) {
        return exportedService.getClass().toString() + (exportedService instanceof ILRMIService ? "(" + ((ILRMIService)((Object)exportedService)).getServiceName() + ")" : "");
    }

    private static class ReplyTask
    extends ContextClassLoaderRunnable {
        private final Pivot pivot;
        private final ChannelEntry channel;
        private final ReplyPacket<?> packet;
        private final IResponseContext ctx;

        private ReplyTask(Pivot pivot, ChannelEntry channel, ReplyPacket<?> packet, IResponseContext ctx) {
            this.pivot = pivot;
            this.channel = channel;
            this.packet = packet;
            this.ctx = ctx;
        }

        @Override
        protected void execute() {
            try {
                LRMIInvocationContext.updateContext((LRMIInvocationTrace)this.ctx.getTrace(), (LRMIInvocationContext.ProxyWriteType)LRMIInvocationContext.ProxyWriteType.UNCACHED, (LRMIInvocationContext.InvocationStage)LRMIInvocationContext.InvocationStage.SERVER_MARSHAL_REPLY, (PlatformLogicalVersion)this.ctx.getSourcePlatformLogicalVersion(), null, (boolean)false, null, null);
                this.pivot.sendResponse(this.channel, this.packet, this.ctx);
            }
            finally {
                LRMIInvocationContext.resetContext();
            }
        }
    }

    private static final class ChannelEntryTask
    implements Runnable {
        private final Pivot pivot;
        private final ChannelEntry channelEntry;
        private final MarshalInputStream stream;

        private ChannelEntryTask(Pivot pivot, ChannelEntry channelEntry, MarshalInputStream stream) {
            this.pivot = pivot;
            this.channelEntry = channelEntry;
            this.stream = stream;
        }

        @Override
        public void run() {
            try {
                this.setLRMIInvocationContext();
                LRMIConnection.setConnection(this.channelEntry.getRemoteClassProvider());
                RequestPacket requestPacket = this.channelEntry.unmarshall(this.stream);
                if (requestPacket == null) {
                    this.channelEntry.returnSocket();
                } else {
                    try {
                        LRMIInvocationContext.updateContext(null, null, (LRMIInvocationContext.InvocationStage)LRMIInvocationContext.InvocationStage.INVOCATION_HANDLING, null, null, (boolean)false, null, null);
                        if (_logger.isLoggable(Level.FINEST)) {
                            _logger.finest("<-- " + requestPacket);
                        }
                        this.pivot.handleRequest(requestPacket, this.channelEntry);
                    }
                    finally {
                        requestPacket.restorePreviousLRMIRemoteClassLoaderState();
                    }
                }
                LRMIConnection.clearConnection();
            }
            finally {
                LRMIInvocationContext.resetContext();
            }
        }

        private void setLRMIInvocationContext() {
            LRMIInvocationTrace trace = _contextLogger.isLoggable(Level.FINE) ? new LRMIInvocationTrace(null, null, NIOUtils.getSocketDisplayString(this.channelEntry.getSocketChannel()), false) : null;
            LRMIInvocationContext.updateContext((LRMIInvocationTrace)trace, (LRMIInvocationContext.ProxyWriteType)LRMIInvocationContext.ProxyWriteType.UNCACHED, (LRMIInvocationContext.InvocationStage)LRMIInvocationContext.InvocationStage.SERVER_UNMARSHAL_REQUEST, (PlatformLogicalVersion)this.channelEntry.getSourcePlatformLogicalVersion(), null, (boolean)false, null, (InetSocketAddress)this.channelEntry.getClientEndPointAddress());
        }
    }

    public static final class ServerRemoteClassProviderProvider
    implements IRemoteClassProviderProvider {
        private final ChannelEntry channel;
        private LRMIRemoteClassLoaderIdentifier _remoteClassLoaderIdentifier;

        public ServerRemoteClassProviderProvider(ChannelEntry channel) {
            this.channel = channel;
        }

        @Override
        public synchronized IClassProvider getClassProvider() throws IOException, IOFilterException {
            try {
                ReplyPacket<ClassProviderRequest> requestForClass = new ReplyPacket<ClassProviderRequest>(new ClassProviderRequest(), null);
                this.channel._writer.writeReply(requestForClass);
                RequestPacket response = this.channel._reader.readRequest(true);
                return (IClassProvider)response.getRequestObject();
            }
            catch (ClassNotFoundException e) {
                IOException exp = new IOException();
                exp.initCause(e);
                throw exp;
            }
        }

        @Override
        public LRMIRemoteClassLoaderIdentifier getRemoteClassLoaderIdentifier() {
            return this._remoteClassLoaderIdentifier;
        }

        @Override
        public LRMIRemoteClassLoaderIdentifier setRemoteClassLoaderIdentifier(LRMIRemoteClassLoaderIdentifier remoteClassLoaderIdentifier) {
            LRMIRemoteClassLoaderIdentifier result = this._remoteClassLoaderIdentifier;
            this._remoteClassLoaderIdentifier = remoteClassLoaderIdentifier;
            return result;
        }
    }
}

