/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.lrmi.nio;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.time.SystemTime;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.nio.charset.Charset;

@InternalApi
public class ProtocolValidation {
    public static final String PROTOCOL_STRING = "gigaspaces-lrmi-protocol";

    public static int getProtocolHeaderBytesLength() {
        return ProtocolValidation.getProtocolHeaderBytes().length;
    }

    public static byte[] getProtocolHeaderBytes() {
        return PROTOCOL_STRING.getBytes(Charset.forName("UTF-8"));
    }

    public static void writeProtocolValidationHeader(SocketChannel socketChannel, long timeout) throws IOException {
        long end;
        if (timeout == Long.MAX_VALUE) {
            end = timeout;
        } else {
            end = SystemTime.timeMillis() + timeout;
            if (end <= 0L) {
                end = Long.MAX_VALUE;
            }
        }
        ByteBuffer byteBuffer = ByteBuffer.wrap(ProtocolValidation.getProtocolHeaderBytes());
        while (byteBuffer.hasRemaining() && SystemTime.timeMillis() < end) {
            int writtenBytes = socketChannel.write(byteBuffer);
            if (writtenBytes != 0) continue;
            Thread.yield();
        }
        if (byteBuffer.hasRemaining()) {
            throw new SocketTimeoutException("Timed out while writing protocol header. timeout=" + timeout);
        }
    }
}

