/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.lrmi.nio;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.exception.lrmi.LRMIUnhandledException;
import com.gigaspaces.exception.lrmi.SlowConsumerException;
import com.gigaspaces.internal.backport.java.util.concurrent.atomic.LongAdder;
import com.gigaspaces.internal.io.GSByteArrayInputStream;
import com.gigaspaces.internal.io.MarshalContextClearedException;
import com.gigaspaces.internal.io.MarshalInputStream;
import com.gigaspaces.lrmi.SmartByteBufferCache;
import com.gigaspaces.lrmi.nio.IPacket;
import com.gigaspaces.lrmi.nio.ProtocolValidation;
import com.gigaspaces.lrmi.nio.ReplyPacket;
import com.gigaspaces.lrmi.nio.RequestPacket;
import com.gigaspaces.lrmi.nio.SystemRequestHandler;
import com.gigaspaces.lrmi.nio.TemporarySelectorFactory;
import com.gigaspaces.lrmi.nio.UnMarshallingException;
import com.gigaspaces.lrmi.nio.filters.IOFilterException;
import com.gigaspaces.lrmi.nio.filters.IOFilterManager;
import com.gigaspaces.time.SystemTime;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.ConnectException;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.nio.charset.Charset;
import java.rmi.NoSuchObjectException;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import sun.misc.BASE64Encoder;

@InternalApi
public class Reader {
    private static final Logger _logger = Logger.getLogger("com.gigaspaces.lrmi");
    private static final Logger offendingMessageLogger = Logger.getLogger("com.gigaspaces.lrmi.offending");
    private static final Logger _slowerConsumerLogger = Logger.getLogger("com.gigaspaces.lrmi.slow_consumer");
    public static final long SUSPICIOUS_THRESHOLD = Long.valueOf(System.getProperty("com.gs.lrmi.suspicious-threshold", "20000000"));
    private static final LongAdder receivedTraffic = new LongAdder();
    private static final byte[] DUMMY_BUFFER = new byte[0];
    private static final byte[] _resetBuffer = new byte[]{121, 112};
    private final SocketChannel _socketChannel;
    private static final int BUFFER_LIMIT = Integer.getInteger("com.gs.lrmi.maxBufferSize", 65536);
    private MarshalInputStream _ois;
    private final GSByteArrayInputStream _bais = new GSByteArrayInputStream(DUMMY_BUFFER);
    private final SmartByteBufferCache _bufferCache = SmartByteBufferCache.getDefaultSmartByteBufferCache();
    private final ByteBuffer _headerBuffer = ByteBuffer.allocateDirect(4);
    private boolean _bufferIsOccupied = false;
    private IOFilterManager _filterManager;
    private final MarshalInputStream.Context _streamContext;
    private final int _slowConsumerRetries;
    private long _receivedTraffic;
    private final SystemRequestHandler _systemRequestHandler;

    public static LongAdder getReceivedTrafficCounter() {
        return receivedTraffic;
    }

    public Reader(SocketChannel sockChannel, int slowConsumerRetries) {
        this(sockChannel, slowConsumerRetries, null);
    }

    public Reader(SocketChannel sockChannel, SystemRequestHandler systemRequestHandler) {
        this(sockChannel, Integer.MAX_VALUE, systemRequestHandler);
    }

    private Reader(SocketChannel sockChannel, int slowConsumerRetries, SystemRequestHandler systemRequestHandler) {
        this._socketChannel = sockChannel;
        this._headerBuffer.order(ByteOrder.BIG_ENDIAN);
        this._streamContext = MarshalInputStream.createContext();
        try {
            this._ois = new MarshalInputStream(this._bais, this._streamContext);
        }
        catch (IOException e) {
            if (_logger.isLoggable(Level.SEVERE)) {
                _logger.log(Level.SEVERE, e.getMessage(), e);
            }
            throw new RuntimeException("Failed to initialize LRMI Reader stream: ", e);
        }
        this._slowConsumerRetries = slowConsumerRetries;
        this._systemRequestHandler = systemRequestHandler;
    }

    public MarshalInputStream readRequest(Context ctx) throws IOException, IOFilterException {
        return this.bytesToStream(ctx);
    }

    public RequestPacket readRequest(boolean createNewBuffer) throws IOException, ClassNotFoundException, IOFilterException {
        return this.bytesToPacket(new RequestPacket(), createNewBuffer, 0, 0);
    }

    public RequestPacket readRequest() throws IOException, ClassNotFoundException, IOFilterException {
        return this.bytesToPacket(new RequestPacket(), false, 0, 0);
    }

    public MarshalInputStream readReply(Context ctx) throws IOException, IOFilterException {
        return this.bytesToStream(ctx);
    }

    public <T> ReplyPacket<T> readReply(boolean createNewBuffer) throws IOException, ClassNotFoundException, IOFilterException {
        return this.bytesToPacket(new ReplyPacket(), createNewBuffer, 0, 0);
    }

    public <T> ReplyPacket<T> readReply() throws IOException, ClassNotFoundException, IOFilterException {
        return this.bytesToPacket(new ReplyPacket(), false, 0, 0);
    }

    public <T> void readReply(ReplyPacket<T> packet) throws IOException, ClassNotFoundException, IOFilterException {
        this.bytesToPacket(packet, false, 0, 0);
    }

    public <T> ReplyPacket<T> readReply(int slowConsumerTimeout, int sizeLimit) throws IOException, ClassNotFoundException, IOFilterException {
        return this.bytesToPacket(new ReplyPacket(), false, slowConsumerTimeout, sizeLimit);
    }

    public void setFilterManager(IOFilterManager filterManager) {
        this._filterManager = filterManager;
    }

    private String prepareSlowConsumerCloseMsg(SocketAddress address, int slowConsumerLatency) {
        return "Closed slow consumer: " + address + " SlowConsumerRetries=" + this._slowConsumerRetries + " SlowConsumerLatency=" + slowConsumerLatency;
    }

    private String prepareSlowConsumerSleepMsg(SocketAddress endPointAddress, int retries, int slowConsumerLatency) {
        return "Sleeping - waiting for slow consumer: " + endPointAddress + " Retry=" + retries + " SlowConsumerRetries=" + this._slowConsumerRetries + " SlowConsumerLatency=" + slowConsumerLatency;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ByteBuffer readBytesFromChannelBlocking(boolean createNewBuffer, int slowConsumerLatency, int sizeLimit) throws IOException {
        int bytesRead = 0;
        int retries = 0;
        Selector tempSelector = null;
        SelectionKey tmpKey = null;
        this._headerBuffer.clear();
        try {
            while (bytesRead < 4) {
                int bRead = this._socketChannel.read(this._headerBuffer);
                if (bRead == -1) {
                    this.throwCloseConnection();
                }
                bytesRead += bRead;
                if (bRead != 0) continue;
                int selectTimeout = slowConsumerLatency / this._slowConsumerRetries + 1;
                boolean channelIsBlocking = this._socketChannel.isBlocking();
                if (slowConsumerLatency > 0 && ++retries > this._slowConsumerRetries) {
                    String slowConsumerMsg = this.prepareSlowConsumerCloseMsg(this.getEndPointAddress(), slowConsumerLatency);
                    if (_slowerConsumerLogger.isLoggable(Level.WARNING)) {
                        _slowerConsumerLogger.warning(slowConsumerMsg);
                    }
                    throw new SlowConsumerException(slowConsumerMsg);
                }
                if (channelIsBlocking) {
                    this._socketChannel.configureBlocking(false);
                }
                if (tempSelector == null) {
                    tempSelector = TemporarySelectorFactory.getSelector();
                    tmpKey = this._socketChannel.register(tempSelector, 1);
                }
                tmpKey.interestOps(tmpKey.interestOps() | 1);
                if (_slowerConsumerLogger.isLoggable(Level.FINE)) {
                    _slowerConsumerLogger.fine(this.prepareSlowConsumerSleepMsg(this.getEndPointAddress(), retries, slowConsumerLatency));
                }
                tempSelector.select(slowConsumerLatency == 0 ? 0L : (long)selectTimeout);
                tmpKey.interestOps(tmpKey.interestOps() & 0xFFFFFFFE);
                if (!channelIsBlocking) continue;
                this._socketChannel.configureBlocking(true);
            }
        }
        finally {
            if (tmpKey != null) {
                tmpKey.cancel();
                tmpKey = null;
            }
            if (tempSelector != null) {
                try {
                    tempSelector.selectNow();
                }
                catch (IOException bRead) {}
                TemporarySelectorFactory.returnSelector(tempSelector);
                tempSelector = null;
            }
        }
        this._receivedTraffic += 4L;
        receivedTraffic.add(4L);
        this._headerBuffer.flip();
        int dataLength = this._headerBuffer.getInt();
        if (0 < sizeLimit && sizeLimit < dataLength) {
            throw new IOException("Handshake failed expecting message of up to " + sizeLimit + " bytes, actual size is: " + dataLength + " bytes.");
        }
        if ((long)dataLength > SUSPICIOUS_THRESHOLD) {
            _logger.warning("About to allocate " + dataLength + " bytes - from socket channel: " + this._socketChannel);
        }
        ByteBuffer buffer = this.getByteBufferAllocated(createNewBuffer, dataLength);
        bytesRead = 0;
        boolean shouldUseSlidingWindow = dataLength >= BUFFER_LIMIT;
        try {
            while (bytesRead < dataLength) {
                int bRead;
                ByteBuffer workingBuffer = buffer;
                if (shouldUseSlidingWindow) {
                    buffer.position(bytesRead).limit(Math.min(dataLength, bytesRead + BUFFER_LIMIT));
                    workingBuffer = buffer.slice();
                }
                if ((bRead = this._socketChannel.read(workingBuffer)) == -1) {
                    this.throwCloseConnection();
                }
                bytesRead += bRead;
                if (bRead != 0) continue;
                int selectTimeout = slowConsumerLatency / this._slowConsumerRetries + 1;
                boolean channelIsBlocking = this._socketChannel.isBlocking();
                if (slowConsumerLatency > 0 && ++retries > this._slowConsumerRetries) {
                    String slowConsumerMsg = this.prepareSlowConsumerCloseMsg(this.getEndPointAddress(), slowConsumerLatency);
                    if (_slowerConsumerLogger.isLoggable(Level.WARNING)) {
                        _slowerConsumerLogger.warning(slowConsumerMsg);
                    }
                    throw new SlowConsumerException(slowConsumerMsg);
                }
                if (channelIsBlocking) {
                    this._socketChannel.configureBlocking(false);
                }
                if (tempSelector == null) {
                    tempSelector = TemporarySelectorFactory.getSelector();
                    tmpKey = this._socketChannel.register(tempSelector, 1);
                }
                tmpKey.interestOps(tmpKey.interestOps() | 1);
                if (_slowerConsumerLogger.isLoggable(Level.FINE)) {
                    _slowerConsumerLogger.fine(this.prepareSlowConsumerSleepMsg(this.getEndPointAddress(), retries, slowConsumerLatency));
                }
                tempSelector.select(slowConsumerLatency == 0 ? 0L : (long)selectTimeout);
                tmpKey.interestOps(tmpKey.interestOps() & 0xFFFFFFFE);
                if (!channelIsBlocking) continue;
                this._socketChannel.configureBlocking(true);
            }
        }
        finally {
            if (tmpKey != null) {
                tmpKey.cancel();
            }
            if (tempSelector != null) {
                try {
                    tempSelector.selectNow();
                }
                catch (IOException iOException) {}
                TemporarySelectorFactory.returnSelector(tempSelector);
            }
        }
        this._receivedTraffic += (long)buffer.position();
        receivedTraffic.add(buffer.position());
        buffer.position(0);
        buffer.limit(dataLength);
        return buffer;
    }

    private ByteBuffer getByteBufferAllocated(boolean createNewBuffer, int dataLength) {
        try {
            if (createNewBuffer) {
                return ByteBuffer.allocate(dataLength);
            }
            return (ByteBuffer)this._bufferCache.get(dataLength);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            _logger.log(Level.WARNING, "Got out of memory error while trying to allocate byte buffer of size  " + dataLength, outOfMemoryError);
            throw outOfMemoryError;
        }
    }

    private ByteBuffer readBytesFromChannelNoneBlocking(Context ctx) throws IOException {
        if (ctx.phase == Context.Phase.START) {
            this._headerBuffer.clear();
            ctx.phase = Context.Phase.HEADER;
        }
        if (ctx.phase == Context.Phase.HEADER) {
            int bRead = this._socketChannel.read(this._headerBuffer);
            if (bRead == -1) {
                this.throwCloseConnection();
            }
            ctx.bytesRead += bRead;
            if (ctx.bytesRead < 4) {
                return null;
            }
            this._receivedTraffic += 4L;
            receivedTraffic.add(4L);
            this._headerBuffer.flip();
            ctx.dataLength = this._headerBuffer.getInt();
            if (ctx.dataLength < 0 && this._systemRequestHandler.handles(ctx.dataLength)) {
                ctx.systemRequestContext = this._systemRequestHandler.getRequestContext(ctx.dataLength);
                ctx.dataLength = ctx.systemRequestContext.getRequestDataLength();
            }
            if (ctx.messageSizeLimit != 0 && ctx.messageSizeLimit <= ctx.dataLength) {
                String offendingAddress = this._socketChannel.socket() != null ? String.valueOf(this._socketChannel.socket().getRemoteSocketAddress()) : "unknown";
                String msg = "Handshake failed, expecting message of up to " + ctx.messageSizeLimit + " bytes, actual size is: " + ctx.dataLength + " bytes, offending address is " + offendingAddress;
                if (offendingMessageLogger.isLoggable(Level.FINEST)) {
                    try {
                        ByteBuffer buffer = this.getByteBufferAllocated(ctx.createNewBuffer, Math.min(ctx.dataLength, 5120));
                        this._socketChannel.read(buffer);
                        buffer.flip();
                        byte[] bytes = new byte[buffer.remaining()];
                        buffer.get(bytes);
                        try {
                            String str = new String(bytes, "UTF-8");
                            offendingMessageLogger.finest(msg + ", received string is : " + str);
                        }
                        catch (UnsupportedEncodingException e) {
                            offendingMessageLogger.finest(msg + ", base64 encoding of the received  buffer is : " + new BASE64Encoder().encode(bytes));
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                throw new ConnectException(msg);
            }
            ctx.buffer = this.getByteBufferAllocated(ctx.createNewBuffer, ctx.dataLength);
            ctx.bytesRead = 0;
            ctx.phase = Context.Phase.BODY;
        }
        if (ctx.phase == Context.Phase.BODY) {
            boolean shouldUseSlidingWindow;
            boolean bl = shouldUseSlidingWindow = ctx.dataLength >= BUFFER_LIMIT;
            if (shouldUseSlidingWindow) {
                while (ctx.bytesRead < ctx.dataLength) {
                    ctx.buffer.position(ctx.bytesRead).limit(Math.min(ctx.dataLength, ctx.bytesRead + BUFFER_LIMIT));
                    ByteBuffer window = ctx.buffer.slice();
                    int bRead = this._socketChannel.read(window);
                    if (bRead == -1) {
                        this.throwCloseConnection();
                    }
                    ctx.bytesRead += bRead;
                    if (bRead >= window.capacity()) continue;
                    return null;
                }
            } else {
                int bRead = this._socketChannel.read(ctx.buffer);
                if (bRead == -1) {
                    this.throwCloseConnection();
                }
                ctx.bytesRead += bRead;
                if (ctx.bytesRead < ctx.dataLength) {
                    return null;
                }
            }
            ctx.phase = Context.Phase.FINISH;
            this._receivedTraffic += (long)ctx.buffer.position();
            receivedTraffic.add(ctx.buffer.position());
            ctx.buffer.position(0);
            ctx.buffer.limit(ctx.dataLength);
            return ctx.buffer;
        }
        throw new IllegalStateException(String.valueOf((Object)ctx.phase));
    }

    private SocketAddress getEndPointAddress() {
        return this._socketChannel != null ? this._socketChannel.socket().getRemoteSocketAddress() : null;
    }

    private void throwCloseConnection() throws ClosedChannelException {
        ClosedChannelException closeEx = new ClosedChannelException();
        closeEx.initCause(new IOException("Connection has been closed by peer"));
        throw closeEx;
    }

    public RequestPacket unmarshallRequest(MarshalInputStream stream) throws ClassNotFoundException, NoSuchObjectException {
        RequestPacket packet = new RequestPacket();
        this.unmarshall(packet, stream);
        return packet;
    }

    public <T> ReplyPacket<T> unmarshallReply(MarshalInputStream stream) throws ClassNotFoundException, NoSuchObjectException {
        ReplyPacket packet = new ReplyPacket();
        this.unmarshall(packet, stream);
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("<-- Read Packet " + packet);
        }
        return packet;
    }

    private MarshalInputStream bytesToStream(Context ctx) throws IOException, IOFilterException {
        boolean endOfRequest;
        boolean startOfRequest;
        boolean bl = startOfRequest = ctx.phase == Context.Phase.START;
        if (this._bufferIsOccupied && startOfRequest) {
            ctx.createNewBuffer = true;
        } else {
            this._bufferIsOccupied = true;
        }
        byte[] res = this.readBytesNonBlocking(ctx);
        boolean bl2 = endOfRequest = ctx.phase == Context.Phase.FINISH;
        if (endOfRequest) {
            if (ctx.isSystemRequest()) {
                ctx.systemRequestContext.prepare(res);
            } else {
                ctx.bytes = res;
                if (ctx.createNewBuffer) {
                    ctx.createNewBuffer = false;
                    return new MarshalInputStream(new GSByteArrayInputStream(res), this._streamContext);
                }
                this._bais.setBuffer(res);
                return this._ois;
            }
        }
        return null;
    }

    private <T extends IPacket> T bytesToPacket(T packet, boolean createNewBuffer, int slowConsumerTimeout, int sizeLimit) throws IOException, ClassNotFoundException, IOFilterException {
        if (this._bufferIsOccupied || createNewBuffer) {
            GSByteArrayInputStream bis = new GSByteArrayInputStream(this.readBytesBlocking(true, slowConsumerTimeout, sizeLimit));
            MarshalInputStream mis = new MarshalInputStream(bis, this._streamContext);
            this.unmarshall(packet, mis);
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.finest("<-- Read Packet " + packet);
            }
            return packet;
        }
        this._bufferIsOccupied = true;
        this._bais.setBuffer(this.readBytesBlocking(false, slowConsumerTimeout, sizeLimit));
        this.unmarshall(packet, this._ois);
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("<-- Read packet " + packet);
        }
        return packet;
    }

    private void unmarshall(IPacket packet, MarshalInputStream mis) throws ClassNotFoundException, NoSuchObjectException {
        try {
            packet.readExternal(mis);
            this.resetStreamState(mis);
        }
        catch (MarshalContextClearedException e) {
            throw e;
        }
        catch (NoSuchObjectException e) {
            throw e;
        }
        catch (ClassNotFoundException e) {
            throw e;
        }
        catch (LRMIUnhandledException e) {
            boolean isReusedBuffer = mis == this._ois;
            try {
                if (isReusedBuffer) {
                    this._ois = new MarshalInputStream(this._bais, this._streamContext);
                }
            }
            catch (IOException ioe) {
                throw new UnMarshallingException("Failed to unmarsh :" + packet, ioe);
            }
            finally {
                if (isReusedBuffer && this._bufferIsOccupied) {
                    this._bais.setBuffer(DUMMY_BUFFER);
                    this._bufferIsOccupied = false;
                }
            }
            throw e;
        }
        catch (Exception e) {
            throw new UnMarshallingException("Failed to unmarsh :" + packet, e);
        }
    }

    private void resetStreamState(MarshalInputStream mis) throws IOException, ClassNotFoundException {
        if (mis == this._ois) {
            try {
                this._bais.setBuffer(_resetBuffer);
                mis.readObject();
            }
            finally {
                if (this._bufferIsOccupied) {
                    this._bais.setBuffer(DUMMY_BUFFER);
                    this._bufferIsOccupied = false;
                }
            }
        }
    }

    private byte[] readBytesBlocking(boolean createNewBuffer, int slowConsumerTimeout, int sizeLimit) throws IOException, IOFilterException {
        ByteBuffer bytes = this.readBytesFromChannelBlocking(createNewBuffer, slowConsumerTimeout, sizeLimit);
        if (this._filterManager != null) {
            return this._filterManager.handleBlockingContant(this.toByteArray(bytes), slowConsumerTimeout);
        }
        return bytes.array();
    }

    private byte[] toByteArray(ByteBuffer bytes) {
        byte[] res = new byte[bytes.remaining()];
        bytes.get(res);
        return res;
    }

    private byte[] readBytesNonBlocking(Context ctx) throws IOException, IOFilterException {
        ByteBuffer bytes = this.readBytesFromChannelNoneBlocking(ctx);
        if (bytes == null) {
            return null;
        }
        if (ctx.phase == Context.Phase.FINISH) {
            if (this._filterManager == null || ctx.isSystemRequest()) {
                return bytes.array();
            }
            return this._filterManager.handleNoneBlockingContant(ctx, this.toByteArray(bytes));
        }
        return null;
    }

    public void closeContext() {
        this._ois.closeContext();
    }

    public void resetContext() {
        this._ois.resetContext();
    }

    public long getReceivedTraffic() {
        return this._receivedTraffic;
    }

    public String readProtocolValidationHeader(ProtocolValidationContext context) throws IOException {
        int bytesRead = this._socketChannel.read(context.buffer);
        if (bytesRead == -1) {
            this.throwCloseConnection();
        }
        byte[] contentBuffer = Arrays.copyOf(context.buffer.array(), context.buffer.position());
        return new String(contentBuffer, Charset.forName("UTF-8"));
    }

    public static class ProtocolValidationContext {
        public final ByteBuffer buffer;
        public final SelectionKey selectionKey;

        public ProtocolValidationContext(SelectionKey selectionKey) {
            this.selectionKey = selectionKey;
            this.buffer = ByteBuffer.allocate(ProtocolValidation.getProtocolHeaderBytesLength());
        }
    }

    public static class Context {
        public final SelectionKey selectionKey;
        public Phase phase = Phase.START;
        public int bytesRead = 0;
        public ByteBuffer buffer = null;
        public int dataLength = 0;
        public boolean createNewBuffer = false;
        public byte[] bytes;
        public SystemRequestHandler.SystemRequestContext systemRequestContext;
        public long startTimestamp = SystemTime.timeMillis();
        public int messageSizeLimit = 0;

        public Context(SelectionKey selectionKey) {
            this.selectionKey = selectionKey;
        }

        public void reset() {
            this.phase = Phase.START;
            this.dataLength = 0;
            this.buffer = null;
            this.bytes = null;
            this.systemRequestContext = null;
            this.startTimestamp = SystemTime.timeMillis();
        }

        public boolean isSystemRequest() {
            return this.systemRequestContext != null;
        }

        public static enum Phase {
            START,
            HEADER,
            BODY,
            FINISH;

        }
    }
}

