/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.lrmi.nio;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.io.AnnotatedObjectInputStream;
import com.gigaspaces.internal.io.AnnotatedObjectOutputStream;
import com.gigaspaces.lrmi.classloading.LRMIRemoteClassLoaderIdentifier;
import com.gigaspaces.lrmi.classloading.protocol.lrmi.LRMIConnection;
import com.gigaspaces.lrmi.nio.IPacket;
import com.gigaspaces.lrmi.nio.RemoteClassLoaderContext;
import java.io.IOException;
import java.rmi.UnmarshalException;

@InternalApi
public class ReplyPacket<T>
implements IPacket {
    private static final long serialVersionUID = 1L;
    private static final byte SERIAL_VERSION = -127;
    private T result;
    private Exception exception;

    public ReplyPacket() {
    }

    public ReplyPacket(T result, Exception exception) {
        this.result = result;
        this.exception = exception;
    }

    public T getResult() {
        return this.result;
    }

    public void setException(Exception exception) {
        this.exception = exception;
    }

    public Exception getException() {
        return this.exception;
    }

    public void clear() {
        this.result = null;
        this.exception = null;
    }

    @Override
    public void readExternal(AnnotatedObjectInputStream in) throws IOException, ClassNotFoundException {
        if (in.readByte() != -127) {
            throw new UnmarshalException("Requested version does not match local version. Please make sure you are using the same version on both ends.");
        }
        LRMIRemoteClassLoaderIdentifier remoteClassLoaderId = RemoteClassLoaderContext.get();
        LRMIRemoteClassLoaderIdentifier previousIdentifier = null;
        if (remoteClassLoaderId != null) {
            previousIdentifier = LRMIConnection.setRemoteClassLoaderIdentifier(remoteClassLoaderId);
        }
        this.result = in.readUnshared();
        this.exception = (Exception)in.readUnshared();
        if (remoteClassLoaderId != null) {
            LRMIConnection.setRemoteClassLoaderIdentifier(previousIdentifier);
        }
    }

    @Override
    public void writeExternal(AnnotatedObjectOutputStream out) throws IOException {
        out.writeByte(-127);
        out.writeUnshared(this.result);
        out.writeUnshared(this.exception);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("[ReplyPacket: ");
        if (this.result != null) {
            builder.append("result = ").append(this.result);
        } else if (this.exception != null) {
            builder.append("exception = ").append(this.exception);
        }
        builder.append("]");
        return builder.toString();
    }
}

