/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.lrmi.nio;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.io.AnnotatedObjectInputStream;
import com.gigaspaces.internal.io.AnnotatedObjectOutputStream;
import com.gigaspaces.internal.io.IOUtils;
import com.gigaspaces.internal.version.PlatformLogicalVersion;
import com.gigaspaces.internal.version.PlatformVersion;
import com.gigaspaces.lrmi.LRMIInvocationContext;
import com.gigaspaces.lrmi.LRMIInvocationTrace;
import com.gigaspaces.lrmi.LRMIMethod;
import com.gigaspaces.lrmi.LRMIRuntime;
import com.gigaspaces.lrmi.ObjectRegistry;
import com.gigaspaces.lrmi.OperationPriority;
import com.gigaspaces.lrmi.classloading.LRMIRemoteClassLoaderIdentifier;
import com.gigaspaces.lrmi.classloading.protocol.lrmi.LRMIConnection;
import com.gigaspaces.lrmi.nio.IPacket;
import com.j_spaces.kernel.ClassLoaderHelper;
import java.io.IOException;
import java.io.InvalidClassException;
import java.rmi.NoSuchObjectException;
import java.rmi.UnmarshalException;
import java.util.logging.Level;
import java.util.logging.Logger;

@InternalApi
public class RequestPacket
implements IPacket {
    private static final long serialVersionUID = 1L;
    private static final byte SERIAL_VERSION = -126;
    private static final Logger _contextLogger = Logger.getLogger("com.gigaspaces.lrmi.context");
    private long lrmiId;
    private long objectId;
    private long remoteClassLoaderId;
    private int methodOrderId;
    private Object[] args;
    private transient LRMIMethod invokeMethod;
    private transient LRMIRemoteClassLoaderIdentifier previousIdentifier;
    private transient boolean shouldRestore;
    private Object _requestObj;
    public Exception exception;
    private transient boolean isOneWay;
    public transient boolean isCallBack;
    public transient OperationPriority operationPriority;
    private transient PlatformLogicalVersion targetVersion;

    public LRMIMethod getInvokeMethod() {
        return this.invokeMethod;
    }

    public RequestPacket() {
        this.operationPriority = OperationPriority.REGULAR;
    }

    public RequestPacket(Object requestObj) {
        this._requestObj = requestObj;
        this.operationPriority = OperationPriority.REGULAR;
    }

    public RequestPacket(long objectId, int methodOrderId, Object[] args, boolean isOneWay, boolean isCallBack, LRMIMethod invokeMethod, long contextClassLoaderId, OperationPriority priority, PlatformLogicalVersion targetVersion) {
        this.set(objectId, methodOrderId, args, isOneWay, isCallBack, invokeMethod, contextClassLoaderId, priority, targetVersion);
    }

    public final void set(long objectId, int methodOrderId, Object[] args, boolean isOneWay, boolean isCallBack, LRMIMethod lrmiMethod, long contextClassLoaderId, OperationPriority priority, PlatformLogicalVersion targetVersion) {
        this.lrmiId = LRMIRuntime.getRuntime().getID();
        this.objectId = objectId;
        this.methodOrderId = methodOrderId;
        this.args = args;
        this.isOneWay = isOneWay;
        this.isCallBack = isCallBack;
        this.invokeMethod = lrmiMethod;
        this.remoteClassLoaderId = contextClassLoaderId;
        this.operationPriority = priority;
        this.targetVersion = targetVersion;
    }

    public Object getRequestObject() {
        return this._requestObj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void readExternal(AnnotatedObjectInputStream in) throws IOException, ClassNotFoundException {
        byte version = in.readByte();
        if (version != -126) {
            throw new UnmarshalException("Requested version [" + version + "] does not match local version [" + -126 + "]. Please make sure you are using the same version on both ends, service version is " + PlatformVersion.getOfficialVersion());
        }
        byte flags = in.readByte();
        if ((flags & 1) != 0) {
            this._requestObj = in.readObject();
        } else {
            this.lrmiId = in.readLong();
            this.objectId = in.readLong();
            this.methodOrderId = in.readInt();
            this.remoteClassLoaderId = in.readLong();
            this.operationPriority = (flags & 8) != 0 ? OperationPriority.LIVENESS : ((flags & 0x10) != 0 ? OperationPriority.MONITORING : ((flags & 0x20) != 0 ? OperationPriority.CUSTOM : OperationPriority.REGULAR));
            if (this.operationPriority == OperationPriority.CUSTOM) {
                IOUtils.readRepetitiveString(in);
            }
            this.previousIdentifier = LRMIConnection.setRemoteClassLoaderIdentifier(new LRMIRemoteClassLoaderIdentifier(this.lrmiId, this.remoteClassLoaderId));
            this.shouldRestore = true;
            this.isOneWay = (flags & 2) != 0;
            boolean bl = this.isCallBack = (flags & 4) != 0;
            if (this.objectId != -1L) {
                LRMIInvocationContext currentContext;
                LRMIInvocationTrace trace;
                LRMIRuntime lrmiRuntime = LRMIRuntime.getRuntime();
                ObjectRegistry.Entry entry = lrmiRuntime.getRegistryObject(this.objectId);
                if (entry == null) {
                    throw new NoSuchObjectException("Object " + this.objectId + " not found in object registry");
                }
                if (entry.getExportedThreadClassLoader() == null) {
                    throw new NoSuchObjectException(entry + " has no ExportedThreadClassLoader");
                }
                LRMIMethod[] methodList = entry.getMethodList();
                if (this.methodOrderId >= methodList.length) {
                    String invClaz = methodList[0].realMethod.getDeclaringClass().getName();
                    throw new InvalidClassException(invClaz + "; local class incompatible. Check that you run the same class version. [objectId: " + this.objectId + ", methodId: " + this.methodOrderId + "]");
                }
                this.invokeMethod = methodList[this.methodOrderId];
                boolean logContext = _contextLogger.isLoggable(Level.FINE);
                if (logContext && (trace = (currentContext = LRMIInvocationContext.getCurrentContext()).getTrace()) != null) {
                    trace = trace.setMethod(this.invokeMethod.realMethodString);
                    currentContext.setTrace(trace);
                }
                if (this.isOneWay) {
                    LRMIConnection.clearConnection();
                }
                ClassLoader unmarshallClassLoader = entry.getExportedThreadClassLoader();
                Class<?>[] types = this.invokeMethod.methodTypes;
                if (types.length > 0) {
                    boolean changeCL;
                    ClassLoader orgThreadCL = Thread.currentThread().getContextClassLoader();
                    boolean bl2 = changeCL = orgThreadCL != unmarshallClassLoader;
                    if (changeCL) {
                        ClassLoaderHelper.setContextClassLoader(unmarshallClassLoader, true);
                    }
                    try {
                        LRMIInvocationContext currentContext2;
                        LRMIInvocationTrace trace2;
                        this.args = new Object[types.length];
                        for (int i = 0; i < types.length; ++i) {
                            this.args[i] = IOUtils.unmarshalValue(types[i], in);
                        }
                        if (logContext && (trace2 = (currentContext2 = LRMIInvocationContext.getCurrentContext()).getTrace()) != null) {
                            trace2 = trace2.setArgs(this.args);
                            currentContext2.setTrace(trace2);
                        }
                    }
                    finally {
                        if (changeCL) {
                            ClassLoaderHelper.setContextClassLoader(orgThreadCL, true);
                        }
                    }
                }
            }
        }
    }

    @Override
    public void writeExternal(AnnotatedObjectOutputStream out) throws IOException {
        out.writeByte(-126);
        out.writeByte(this.buildFlags());
        if (this._requestObj != null) {
            out.writeObject(this._requestObj);
        } else {
            out.writeLong(this.lrmiId);
            out.writeLong(this.objectId);
            out.writeInt(this.methodOrderId);
            out.writeLong(this.remoteClassLoaderId);
            if (this.operationPriority == OperationPriority.CUSTOM && this.targetVersion.greaterOrEquals(PlatformLogicalVersion.v9_7_0)) {
                IOUtils.writeRepetitiveString(out, "");
            }
            Class<?>[] types = this.invokeMethod.methodTypes;
            for (int i = 0; i < types.length; ++i) {
                IOUtils.marshalValue(types[i], this.args[i], out);
            }
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("[RequestPacket: ");
        if (this._requestObj != null) {
            builder.append("RequestObj = ").append(this._requestObj);
        }
        if (this.invokeMethod != null && this.invokeMethod.realMethod != null) {
            builder.append(this.invokeMethod.realMethod.getDeclaringClass()).append('.');
            builder.append(this.invokeMethod.realMethod.getName()).append('(');
            Class<?>[] types = this.invokeMethod.methodTypes;
            for (int i = 0; i < types.length; ++i) {
                builder.append(types[i] == null ? "null type" : types[i].getCanonicalName());
                builder.append(' ');
                builder.append(this.args == null ? "null args" : this.args[i]);
                if (i >= types.length - 1) continue;
                builder.append(", ");
            }
            builder.append(')');
        }
        builder.append(", isOneWay = ").append(this.isOneWay);
        builder.append(", isCallBack = ").append(this.isCallBack);
        builder.append(", Priority = ").append((Object)this.operationPriority);
        builder.append(']');
        return builder.toString();
    }

    private byte buildFlags() {
        byte flags = 0;
        if (this._requestObj != null) {
            flags = (byte)(flags | 1);
        }
        if (this.isOneWay) {
            flags = (byte)(flags | 2);
        }
        if (this.isCallBack) {
            flags = (byte)(flags | 4);
        }
        switch (this.operationPriority) {
            case REGULAR: {
                break;
            }
            case MONITORING: {
                flags = (byte)(flags | 0x10);
                break;
            }
            case LIVENESS: {
                flags = (byte)(flags | 8);
                break;
            }
            case CUSTOM: {
                flags = (byte)(flags | 0x20);
            }
        }
        return flags;
    }

    public void clear() {
        this.args = null;
    }

    public Object[] getArgs() {
        return this.args;
    }

    public long getObjectId() {
        return this.objectId;
    }

    public boolean isOneWay() {
        return this.isOneWay;
    }

    public void restorePreviousLRMIRemoteClassLoaderState() {
        if (this.shouldRestore) {
            LRMIConnection.setRemoteClassLoaderIdentifier(this.previousIdentifier);
        }
    }

    public static OperationPriority getOperationPriorityFromBytes(byte[] bytes) {
        if (bytes.length < 4) {
            throw new IllegalStateException("Incoming invocation request is not of known format, byte array length is too small - " + bytes.length);
        }
        byte flags = bytes[3];
        if ((flags & 8) != 0) {
            return OperationPriority.LIVENESS;
        }
        if ((flags & 0x10) != 0) {
            return OperationPriority.MONITORING;
        }
        if ((flags & 0x20) != 0) {
            return OperationPriority.CUSTOM;
        }
        return OperationPriority.REGULAR;
    }

    private static interface BitMap {
        public static final byte REQUEST_OBJECT = 1;
        public static final byte IS_ONEWAY = 2;
        public static final byte IS_CALLBACK = 4;
        public static final byte IS_LIVENESS_PRIORITY = 8;
        public static final byte IS_MONITORING_PRIORITY = 16;
        public static final byte IS_CUSTOM_PRIORITY = 32;
    }
}

