/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.lrmi.nio;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.lrmi.nio.ChannelEntry;
import com.gigaspaces.lrmi.nio.Pivot;
import com.gigaspaces.lrmi.nio.ReplyPacket;
import com.gigaspaces.lrmi.nio.SystemRequestHandler;
import com.gigaspaces.lrmi.nio.Writer;
import com.gigaspaces.time.SystemTime;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.logging.Level;
import java.util.logging.Logger;

@InternalApi
public class SystemRequestHandlerImpl
implements SystemRequestHandler {
    @Override
    public boolean handles(int requestCode) {
        switch (requestCode) {
            case -3: 
            case -2: {
                return true;
            }
        }
        return false;
    }

    @Override
    public SystemRequestHandler.SystemRequestContext getRequestContext(int requestCode) {
        switch (requestCode) {
            case -2: {
                return new WatchdogMonitorSystemRequestContextV950();
            }
            case -3: {
                return new WatchdogMonitorSystemRequestContext();
            }
        }
        throw new IllegalStateException("No handler for request code: " + requestCode);
    }

    public static class WatchdogMonitorSystemRequestContext
    extends AbstractWatchdogMonitorSystemRequestContext {
        @Override
        protected ReplyPacket<?> createReplyPacket(boolean found, ChannelEntry.State channelEntryState) {
            int channelEntryStateCode = channelEntryState != null ? channelEntryState.getCode() : 0;
            return new ReplyPacket<Integer>(channelEntryStateCode, null);
        }
    }

    public static class WatchdogMonitorSystemRequestContextV950
    extends AbstractWatchdogMonitorSystemRequestContext {
        @Override
        protected ReplyPacket<?> createReplyPacket(boolean found, ChannelEntry.State channelEntryState) {
            return new ReplyPacket<Boolean>(found, null);
        }
    }

    public static abstract class AbstractWatchdogMonitorSystemRequestContext
    implements SystemRequestHandler.SystemRequestContext {
        private static final Logger _logger = Logger.getLogger("com.gigaspaces.lrmi.watchdog");
        private int _monitoredClientSocketPort;

        @Override
        public int getRequestDataLength() {
            return 4;
        }

        @Override
        public void prepare(byte[] result) {
            this._monitoredClientSocketPort = ByteBuffer.wrap(result).order(ByteOrder.BIG_ENDIAN).getInt();
        }

        @Override
        public Runnable getResponseTask(final Pivot pivot, final ChannelEntry channelEntry, final long requestReadStartTimestamp) {
            final long taskCreationTimestamp = SystemTime.timeMillis();
            return new Runnable(){

                @Override
                public void run() {
                    boolean found = false;
                    ChannelEntry.State channelEntryState = null;
                    InetAddress clientAddress = null;
                    Socket socket = channelEntry.getSocketChannel().socket();
                    if (socket != null) {
                        clientAddress = socket.getInetAddress();
                    }
                    InetSocketAddress monitoredClient = null;
                    if (clientAddress != null) {
                        monitoredClient = new InetSocketAddress(clientAddress, _monitoredClientSocketPort);
                        channelEntryState = pivot.getChannelEntryState(monitoredClient);
                        found = channelEntryState == ChannelEntry.State.PROGRESS;
                    }
                    boolean reuseBuffer = false;
                    Writer.SystemResponseContext ctx = new Writer.SystemResponseContext();
                    String monitoringId = null;
                    ReplyPacket<?> replyPacket = this.createReplyPacket(found, channelEntryState);
                    if (_logger.isLoggable(Level.FINE)) {
                        _logger.fine("Writing watchdog monitor system response for client[" + monitoredClient + "], channelEntryState[ " + (Object)((Object)channelEntryState) + " ] watchdog request read at [ " + requestReadStartTimestamp + " ] watchdog response task creation at [ " + taskCreationTimestamp + " ] watchdog response task execution at [" + SystemTime.timeMillis() + " ]");
                    }
                    channelEntry.writeReply(replyPacket, reuseBuffer, ctx, monitoringId);
                }
            };
        }

        protected abstract ReplyPacket<?> createReplyPacket(boolean var1, ChannelEntry.State var2);
    }
}

