/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.lrmi.nio;

import com.gigaspaces.api.InternalApi;
import java.io.IOException;
import java.nio.channels.Selector;
import java.util.EmptyStackException;
import java.util.Stack;

@InternalApi
public class TemporarySelectorFactory {
    private static final int maxSelectors = Integer.getInteger("com.gs.lrmi.tmp.selector.pool.size", 20);
    private static final long timeout = Long.getLong("com.gs.lrmi.tmp.selector.pool.wait.timeout", 5000L);
    private static final Stack<Selector> selectors = new Stack();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final Selector getSelector() {
        Stack<Selector> stack = selectors;
        synchronized (stack) {
            Selector s = null;
            try {
                if (selectors.size() != 0) {
                    s = selectors.pop();
                }
            }
            catch (EmptyStackException emptyStackException) {
                // empty catch block
            }
            try {
                for (int attempts = 0; s == null && attempts < 2; ++attempts) {
                    selectors.wait(timeout);
                    try {
                        if (selectors.size() == 0) continue;
                        s = selectors.pop();
                        continue;
                    }
                    catch (EmptyStackException ex) {
                        break;
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return s;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void returnSelector(Selector s) {
        Stack<Selector> stack = selectors;
        synchronized (stack) {
            selectors.push(s);
            if (selectors.size() == 1) {
                selectors.notify();
            }
        }
    }

    static {
        try {
            for (int i = 0; i < maxSelectors; ++i) {
                selectors.add(Selector.open());
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

