/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.lrmi.nio;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.exception.lrmi.SlowConsumerException;
import com.gigaspaces.internal.backport.java.util.concurrent.atomic.LongAdder;
import com.gigaspaces.internal.io.GSByteArrayOutputStream;
import com.gigaspaces.internal.io.MarshalContextClearedException;
import com.gigaspaces.internal.io.MarshalOutputStream;
import com.gigaspaces.lrmi.LRMIInvocationContext;
import com.gigaspaces.lrmi.LRMIInvocationTrace;
import com.gigaspaces.lrmi.SmartByteBufferCache;
import com.gigaspaces.lrmi.nio.IChannelWriter;
import com.gigaspaces.lrmi.nio.IPacket;
import com.gigaspaces.lrmi.nio.IWriteInterestManager;
import com.gigaspaces.lrmi.nio.MarshallingException;
import com.gigaspaces.lrmi.nio.ProtocolValidation;
import com.gigaspaces.lrmi.nio.ReplyPacket;
import com.gigaspaces.lrmi.nio.RequestPacket;
import com.gigaspaces.lrmi.nio.TemporarySelectorFactory;
import com.gigaspaces.lrmi.nio.WriteExecutionPhaseListener;
import com.gigaspaces.lrmi.nio.filters.IOFilterException;
import com.gigaspaces.lrmi.nio.filters.IOFilterManager;
import java.io.IOException;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.LinkedList;
import java.util.Queue;
import java.util.logging.Level;
import java.util.logging.Logger;

@InternalApi
public class Writer
implements IChannelWriter {
    private static final Logger _logger = Logger.getLogger("com.gigaspaces.lrmi");
    private static final Logger _slowerConsumerLogger = Logger.getLogger("com.gigaspaces.lrmi.slow_consumer");
    private final SocketChannel _sockChannel;
    private static final int BUFFER_LIMIT = Integer.getInteger("com.gs.lrmi.maxBufferSize", 65536);
    private static final int LENGTH_SIZE = 4;
    private final MarshalOutputStream _oos;
    private final GSByteArrayOutputStream _baos;
    private static final int WRITE_DELAY_BEFORE_WARN = Integer.getInteger("com.gs.lrmi.maxWriteDelayBeforeWarn", 30000);
    private final SmartByteBufferCache _bufferCache = SmartByteBufferCache.getDefaultSmartByteBufferCache();
    private final int _slowConsumerThroughput;
    private final boolean _slowConsumer;
    private final int _slowConsumerLatency;
    private final int _slowConsumerRetries;
    private final int _slowConsumerSleepTime;
    private final int _slowConsumerBytes;
    private static final LongAdder generatedTraffic = new LongAdder();
    private long _generatedTraffic;
    private static final byte[] DUMMY_BUFFER = new byte[0];
    IOFilterManager _filterManager;
    private final Queue<Context> _contexts;
    private static final LongAdder pendingWrites = new LongAdder();
    private IWriteInterestManager _writeInterestManager;

    public static LongAdder getGeneratedTrafficCounter() {
        return generatedTraffic;
    }

    public static LongAdder getPendingWritesCounter() {
        return pendingWrites;
    }

    public Writer(SocketChannel sockChannel, IWriteInterestManager writeInterestManager) {
        this(sockChannel, 0, Integer.MAX_VALUE, Integer.MAX_VALUE, writeInterestManager);
    }

    public Writer(SocketChannel sockChannel, int slowConsumerThroughput, int slowConsumerLatency, int slowConsumerRetries, IWriteInterestManager writeInterestManager) {
        this._sockChannel = sockChannel;
        this._slowConsumerThroughput = slowConsumerThroughput;
        this._slowConsumerLatency = slowConsumerLatency;
        this._slowConsumerRetries = slowConsumerRetries;
        this._slowConsumer = this._slowConsumerThroughput > 0;
        this._slowConsumerSleepTime = this._slowConsumerLatency / this._slowConsumerRetries + 1;
        this._slowConsumerBytes = this._slowConsumerThroughput * this._slowConsumerLatency / 1000;
        this._contexts = new LinkedList<Context>();
        this._writeInterestManager = writeInterestManager;
        try {
            this._baos = new GSByteArrayOutputStream();
            this._baos.setSize(4);
            this._oos = new MarshalOutputStream(this._baos, true);
            this.initBuffer(this._baos);
        }
        catch (Exception e) {
            if (_logger.isLoggable(Level.SEVERE)) {
                _logger.log(Level.SEVERE, e.getMessage(), e);
            }
            throw new RuntimeException("Failed to initialize LRMI Writer stream: ", e);
        }
    }

    public void setWriteInterestManager(IWriteInterestManager writeInterestManager) {
        this._writeInterestManager = writeInterestManager;
    }

    public SocketAddress getEndPointAddress() {
        return this._sockChannel != null ? this._sockChannel.socket().getRemoteSocketAddress() : null;
    }

    public void writeRequest(RequestPacket packet, boolean reuseBuffer, Context ctx) throws IOException, IOFilterException {
        this.writePacket(packet, reuseBuffer, ctx);
    }

    public void writeRequest(RequestPacket packet, boolean reuseBuffer) throws IOException, IOFilterException {
        this.writePacket(packet, reuseBuffer, null);
    }

    public void writeRequest(RequestPacket packet) throws IOException, IOFilterException {
        this.writeRequest(packet, true);
    }

    public void writeReply(ReplyPacket packet, boolean reuseBuffer, Context ctx) throws IOException, IOFilterException {
        this.writePacket(packet, reuseBuffer, ctx);
    }

    public void writeReply(ReplyPacket packet, boolean reuseBuffer) throws IOException, IOFilterException {
        this.writePacket(packet, reuseBuffer, null);
    }

    public void writeReply(ReplyPacket packet) throws IOException, IOFilterException {
        this.writeReply(packet, true);
    }

    public boolean isOpen() {
        return this._sockChannel.isOpen();
    }

    private synchronized void writePacket(IPacket packet, boolean requestReuseBuffer, Context ctx) throws IOException, IOFilterException {
        ByteBuffer buffer;
        ByteBuffer byteBuffer;
        GSByteArrayOutputStream bos;
        MarshalOutputStream mos;
        boolean reuseBuffer;
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("--> Write Packet " + packet);
        }
        boolean bl = reuseBuffer = requestReuseBuffer && this._contexts.isEmpty();
        if (reuseBuffer) {
            mos = this._oos;
            bos = this._baos;
            byteBuffer = this.prepareStream();
        } else {
            bos = new GSByteArrayOutputStream();
            bos.setSize(4);
            mos = new MarshalOutputStream(bos, false);
            byteBuffer = this.wrap(bos);
        }
        try {
            packet.writeExternal(mos);
        }
        catch (MarshalContextClearedException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MarshallingException("Failed to marsh: " + packet, e);
        }
        finally {
            ByteBuffer buffer2 = this.prepareBuffer(mos, bos, byteBuffer);
            if (reuseBuffer) {
                bos.setBuffer(DUMMY_BUFFER);
                bos.reset();
                mos.reset();
                if (buffer2 != byteBuffer) {
                    this._bufferCache.set(buffer2);
                } else {
                    this._bufferCache.notifyUsedSize(buffer2.limit());
                }
            } else {
                mos.closeContext();
            }
        }
        this._generatedTraffic += (long)buffer.limit();
        generatedTraffic.add(buffer.limit());
        if (ctx != null) {
            ctx.setBuffer(buffer);
            this.writeBytesNonBlocking(ctx);
        } else {
            this.writeBytesBlocking(buffer);
        }
    }

    @Override
    public void setFilterManager(IOFilterManager filterManager) {
        this._filterManager = filterManager;
    }

    @Override
    public boolean isBlocking() {
        return this._sockChannel.isBlocking();
    }

    private void writeBytesNonBlocking(Context ctx) throws IOException, IOFilterException {
        if (this._filterManager != null && !ctx.isSystemResponse()) {
            this._filterManager.writeBytesNonBlocking(ctx);
        } else {
            this.writeBytesToChannelNoneBlocking(ctx, true);
        }
    }

    @Override
    public synchronized void writeBytesToChannelNoneBlocking(Context ctx, boolean restoreReadInterest) throws IOException {
        if (this._contexts.isEmpty()) {
            this.noneBlockingWrite(ctx);
            if (ctx.getPhase() != Context.Phase.FINISH) {
                this._contexts.offer(ctx);
                this.setWriteInterest();
                pendingWrites.increment();
            } else {
                this.removeWriteInterest(restoreReadInterest);
            }
        } else {
            this._contexts.offer(ctx);
            this.setWriteInterest();
            pendingWrites.increment();
        }
    }

    protected void noneBlockingWrite(Context ctx) throws IOException {
        if (ctx.getPhase() == Context.Phase.START) {
            int dataLength = ctx.getBuffer().remaining();
            ctx.setTotalLength(dataLength);
            ctx.setPhase(Context.Phase.WRITING);
        }
        if (ctx.getPhase() == Context.Phase.WRITING) {
            boolean useSlidingWindow;
            boolean bl = useSlidingWindow = ctx.getTotalLength() >= BUFFER_LIMIT;
            if (useSlidingWindow) {
                while (ctx.getTotalBytesWritten() < ctx.getTotalLength()) {
                    ctx.getBuffer().position(ctx.getCurrentPosition()).limit(Math.min(ctx.getTotalLength(), ctx.getCurrentPosition() + BUFFER_LIMIT));
                    ByteBuffer window = ctx.getBuffer().slice();
                    int windowSize = window.remaining();
                    int bytes = this._sockChannel.write(window);
                    ctx.setCurrentPosition(ctx.getCurrentPosition() + bytes);
                    ctx.setTotalBytesWritten(ctx.getTotalBytesWritten() + bytes);
                    if (bytes >= windowSize) continue;
                    return;
                }
            } else {
                int bytes = this._sockChannel.write(ctx.getBuffer());
                ctx.setTotalBytesWritten(ctx.getTotalBytesWritten() + bytes);
            }
            if (ctx.getTotalBytesWritten() == ctx.getTotalLength()) {
                ctx.setPhase(Context.Phase.FINISH);
            }
        }
    }

    private void writeBytesBlocking(ByteBuffer dataBuffer) throws IOException, IOFilterException {
        if (this._filterManager != null) {
            this._filterManager.writeBytesBlocking(dataBuffer);
        } else {
            this.writeBytesToChannelBlocking(dataBuffer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeBytesToChannelBlocking(ByteBuffer dataBuffer) throws IOException, ClosedChannelException, SlowConsumerException {
        block26: {
            int totalBytesWritten = 0;
            int bytesRetries = 0;
            int retries = this._slowConsumerRetries;
            int length = dataBuffer.remaining();
            boolean useSlidingWindow = length >= BUFFER_LIMIT;
            int currentPosision = 0;
            Selector tempSelector = null;
            SelectionKey tmpKey = null;
            block9: while (true) {
                while (true) {
                    int bytes;
                    if (useSlidingWindow) {
                        if (totalBytesWritten >= length) {
                            break block26;
                        }
                        dataBuffer.position(currentPosision).limit(Math.min(length, currentPosision + BUFFER_LIMIT));
                        ByteBuffer window = dataBuffer.slice();
                        int windowSize = window.remaining();
                        bytes = this._sockChannel.write(window);
                        currentPosision += bytes;
                        if (bytes == 0) {
                            if (tempSelector == null) {
                                tempSelector = TemporarySelectorFactory.getSelector();
                                tmpKey = this._sockChannel.register(tempSelector, 4);
                            }
                            tmpKey.interestOps(tmpKey.interestOps() | 4);
                            int res = tempSelector.select(1000L);
                            tmpKey.interestOps(tmpKey.interestOps() & 0xFFFFFFFB);
                            if (res == 1) {
                                continue;
                            }
                        } else if (bytes == windowSize) {
                            totalBytesWritten += bytes;
                            continue;
                        }
                    } else {
                        bytes = this._sockChannel.write(dataBuffer);
                    }
                    if ((totalBytesWritten += bytes) >= length) {
                        break block26;
                    }
                    if (this._slowConsumer && (bytesRetries += bytes) < this._slowConsumerBytes) {
                        if (retries-- == 0) {
                            String slowConsumerCloseMsg = this.prepareSlowConsumerCloseMsg(this.getEndPointAddress());
                            if (_slowerConsumerLogger.isLoggable(Level.WARNING)) {
                                _slowerConsumerLogger.warning(slowConsumerCloseMsg);
                            }
                            this._sockChannel.close();
                            throw new SlowConsumerException(slowConsumerCloseMsg);
                        }
                        try {
                            if (_slowerConsumerLogger.isLoggable(Level.FINE)) {
                                _slowerConsumerLogger.fine(this.prepareSlowConsumerSleepMsg(this.getEndPointAddress(), retries));
                            }
                            Thread.sleep(this._slowConsumerSleepTime);
                            continue block9;
                        }
                        catch (InterruptedException e) {
                            IOException ioe = new IOException("Interrupted while writing response.");
                            ioe.initCause(e);
                            throw ioe;
                        }
                    }
                    bytesRetries = 0;
                    retries = this._slowConsumerRetries;
                }
                break;
            }
            finally {
                if (tmpKey != null) {
                    tmpKey.cancel();
                }
                if (tempSelector != null) {
                    try {
                        tempSelector.selectNow();
                    }
                    catch (IOException iOException) {}
                    TemporarySelectorFactory.returnSelector(tempSelector);
                }
            }
        }
    }

    public synchronized void onWriteEvent() throws IOException {
        LRMIInvocationTrace trace = null;
        try {
            while (!this._contexts.isEmpty()) {
                Context current = this._contexts.peek();
                trace = current.getTrace();
                if (trace != null) {
                    LRMIInvocationContext.updateContext((LRMIInvocationTrace)trace, null, null, null, null, (boolean)false, null, null);
                }
                this.noneBlockingWrite(current);
                if (current.getPhase() != Context.Phase.FINISH) {
                    this.setWriteInterest();
                    break;
                }
                this.traceContextTotalWriteTime(current);
                this._contexts.poll();
                pendingWrites.decrement();
            }
            if (this._contexts.isEmpty()) {
                this.removeWriteInterest(true);
            }
        }
        finally {
            if (trace != null) {
                LRMIInvocationContext.resetContext();
            }
        }
    }

    private void traceContextTotalWriteTime(Context context) {
        long writeTime = System.currentTimeMillis() - context.getCreationTime();
        if ((long)WRITE_DELAY_BEFORE_WARN < writeTime) {
            String method = context.getTrace() != null ? context.getTrace().getTraceShortDisplayString() : "unknown";
            _logger.warning("write to " + this.getEndPointAddress() + " method " + method + " was fully performed only " + writeTime + " milliseconds after requested, the system may be overloaded or the network is bad.");
        }
    }

    private ByteBuffer prepareBuffer(MarshalOutputStream mos, GSByteArrayOutputStream bos, ByteBuffer byteBuffer) throws IOException {
        mos.flush();
        int length = bos.size();
        if (byteBuffer.array() != bos.getBuffer()) {
            byteBuffer = this.wrap(bos);
        } else {
            byteBuffer.clear();
        }
        byteBuffer.putInt(length - 4);
        byteBuffer.position(length);
        byteBuffer.flip();
        return byteBuffer;
    }

    private ByteBuffer wrap(GSByteArrayOutputStream bos) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(bos.getBuffer());
        byteBuffer.order(ByteOrder.BIG_ENDIAN);
        return byteBuffer;
    }

    private ByteBuffer initBuffer(GSByteArrayOutputStream bos) {
        ByteBuffer byteBuffer = this.wrap(bos);
        this._bufferCache.set(byteBuffer);
        return byteBuffer;
    }

    private ByteBuffer prepareStream() throws IOException {
        ByteBuffer byteBuffer = (ByteBuffer)this._bufferCache.get();
        byte[] streamBuffer = byteBuffer.array();
        this._baos.setBuffer(streamBuffer, 4);
        return byteBuffer;
    }

    private String prepareSlowConsumerSleepMsg(SocketAddress address, int retriesLeft) {
        return "Sleeping - waiting for slow consumer: " + address + " Retry=" + (this._slowConsumerRetries - retriesLeft) + " SlowConsumerThroughput=" + this._slowConsumerThroughput + " SlowConsumerRetries=" + this._slowConsumerRetries + " SlowConsumerLatency=" + this._slowConsumerLatency;
    }

    private String prepareSlowConsumerCloseMsg(SocketAddress address) {
        return "Closed slow consumer: " + address + " SlowConsumerThroughput=" + this._slowConsumerThroughput + " SlowConsumerRetries=" + this._slowConsumerRetries + " SlowConsumerLatency=" + this._slowConsumerLatency;
    }

    private void removeWriteInterest(boolean restoreReadInterest) {
        if (this._writeInterestManager != null) {
            this._writeInterestManager.removeWriteInterest(restoreReadInterest);
        }
    }

    private void setWriteInterest() {
        if (this._writeInterestManager != null) {
            this._writeInterestManager.setWriteInterest();
        }
    }

    public void closeContext() {
        this._oos.closeContext();
    }

    public void resetContext() {
        this._oos.resetContext();
    }

    public long getGeneratedTraffic() {
        return this._generatedTraffic;
    }

    public void writeProtocolValidationHeader() throws IOException {
        ProtocolValidation.writeProtocolValidationHeader(this._sockChannel, Long.MAX_VALUE);
    }

    public static class ChannelEntryContext
    extends Context {
        private final WriteExecutionPhaseListener executionPhaseListener;

        public ChannelEntryContext(LRMIInvocationTrace trace, WriteExecutionPhaseListener listener) {
            super(trace);
            this.executionPhaseListener = listener;
        }

        @Override
        public void setPhase(Context.Phase phase) {
            super.setPhase(phase);
            this.executionPhaseListener.onPhase(phase);
        }

        @Override
        protected Context createContextForDuplication() {
            return new ChannelEntryContext(this.getTrace(), this.executionPhaseListener);
        }
    }

    public static class SystemResponseContext
    extends Context {
        public SystemResponseContext() {
            super(null);
        }

        @Override
        public boolean isSystemResponse() {
            return true;
        }

        @Override
        protected Context createContextForDuplication() {
            return new SystemResponseContext();
        }
    }

    public static class Context {
        private Phase phase = Phase.START;
        private ByteBuffer buffer;
        private int totalBytesWritten = 0;
        private int currentPosition = 0;
        private int totalLength;
        private final LRMIInvocationTrace trace;
        private final long creationTime;

        public Context(LRMIInvocationTrace trace) {
            this.trace = trace;
            this.creationTime = System.currentTimeMillis();
        }

        public void setBuffer(ByteBuffer buffer) {
            this.buffer = buffer;
        }

        public ByteBuffer getBuffer() {
            return this.buffer;
        }

        public void setTotalBytesWritten(int totalBytesWritten) {
            this.totalBytesWritten = totalBytesWritten;
        }

        public int getTotalBytesWritten() {
            return this.totalBytesWritten;
        }

        public void setCurrentPosition(int currentPosition) {
            this.currentPosition = currentPosition;
        }

        public int getCurrentPosition() {
            return this.currentPosition;
        }

        public void setTotalLength(int totalLength) {
            this.totalLength = totalLength;
        }

        public int getTotalLength() {
            return this.totalLength;
        }

        public void setPhase(Phase phase) {
            this.phase = phase;
        }

        public Phase getPhase() {
            return this.phase;
        }

        public LRMIInvocationTrace getTrace() {
            return this.trace;
        }

        public boolean isSystemResponse() {
            return false;
        }

        public long getCreationTime() {
            return this.creationTime;
        }

        public Context duplicate() {
            Context res = this.createContextForDuplication();
            res.setPhase(this.phase);
            res.setTotalLength(this.totalLength);
            res.setCurrentPosition(this.currentPosition);
            res.setTotalBytesWritten(this.totalBytesWritten);
            res.setBuffer(this.buffer);
            return res;
        }

        protected Context createContextForDuplication() {
            return new Context(this.trace);
        }

        public static enum Phase {
            START,
            WRITING,
            FINISH;

        }
    }
}

