/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.lrmi.nio.async;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.exception.lrmi.LRMIUnhandledException;
import com.gigaspaces.internal.io.MarshalContextClearedException;
import com.gigaspaces.internal.io.MarshalInputStream;
import com.gigaspaces.internal.stubcache.MissingCachedStubException;
import com.gigaspaces.internal.utils.concurrent.ContextClassLoaderRunnable;
import com.gigaspaces.internal.version.PlatformLogicalVersion;
import com.gigaspaces.lrmi.ConnectionPool;
import com.gigaspaces.lrmi.LRMIInvocationContext;
import com.gigaspaces.lrmi.LRMIInvocationTrace;
import com.gigaspaces.lrmi.LRMIRuntime;
import com.gigaspaces.lrmi.classloading.ClassProviderRequest;
import com.gigaspaces.lrmi.classloading.IRemoteClassProviderProvider;
import com.gigaspaces.lrmi.classloading.LRMIRemoteClassLoaderIdentifier;
import com.gigaspaces.lrmi.classloading.protocol.lrmi.LRMIConnection;
import com.gigaspaces.lrmi.nio.CPeer;
import com.gigaspaces.lrmi.nio.ClientPeerWatchedObjectsContext;
import com.gigaspaces.lrmi.nio.Reader;
import com.gigaspaces.lrmi.nio.RemoteClassLoaderContext;
import com.gigaspaces.lrmi.nio.ReplyPacket;
import com.gigaspaces.lrmi.nio.RequestPacket;
import com.gigaspaces.lrmi.nio.Writer;
import com.gigaspaces.lrmi.nio.async.LRMIFuture;
import com.gigaspaces.lrmi.nio.selector.handler.client.ClientHandler;
import com.gigaspaces.lrmi.nio.selector.handler.client.Context;
import java.io.IOException;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.rmi.ConnectException;
import java.rmi.ConnectIOException;
import java.rmi.RemoteException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;

@InternalApi
public class AsyncContext
implements Context {
    private static final Logger _logger = Logger.getLogger("com.gigaspaces.lrmi");
    private static final Logger _contextLogger = Logger.getLogger("com.gigaspaces.lrmi.context");
    private final ConnectionPool connectionPool;
    private final ClientHandler handler;
    private final LRMIFuture result;
    private final ClassLoader contextClassLoader;
    private final LRMIRemoteClassLoaderIdentifier remoteClassLoaderIdentifier;
    private volatile boolean reuseBuffer = true;
    private volatile SelectionKey selectionKey;
    private volatile RequestPacket requestPacket;
    private volatile Reader.Context readerCtx;
    private volatile Writer.Context writerCtx;
    private final CPeer cpeer;
    private final IRemoteClassProviderProvider remoteConnection;
    private final AtomicBoolean finished = new AtomicBoolean();
    private final LRMIInvocationTrace invocationTrace;
    private final PlatformLogicalVersion sourceLogicalVersion;
    private final PlatformLogicalVersion targetLogicalVersion;
    private final boolean useStubCache;
    private final String monitoringId;
    private volatile LRMIInvocationContext.ProxyWriteType proxyWriteType;
    private final ClientPeerWatchedObjectsContext watchedObjectContext;

    public AsyncContext(ConnectionPool connPool, ClientHandler handler, RequestPacket packet, LRMIFuture result, CPeer cpeer, IRemoteClassProviderProvider remoteConnection, ClassLoader contextClassLoader, LRMIRemoteClassLoaderIdentifier remoteClassLoaderIdentifier, String monitoringId, ClientPeerWatchedObjectsContext watchedObjectContext) {
        this.connectionPool = connPool;
        this.handler = handler;
        this.result = result;
        this.requestPacket = packet;
        this.cpeer = cpeer;
        this.remoteConnection = remoteConnection;
        this.contextClassLoader = contextClassLoader;
        this.remoteClassLoaderIdentifier = remoteClassLoaderIdentifier;
        this.monitoringId = monitoringId;
        this.watchedObjectContext = watchedObjectContext;
        LRMIInvocationContext invocationContext = LRMIInvocationContext.getCurrentContext();
        this.invocationTrace = _contextLogger.isLoggable(Level.FINE) ? invocationContext.getTrace() : null;
        this.sourceLogicalVersion = invocationContext.getSourceLogicalVersion();
        this.targetLogicalVersion = invocationContext.getTargetLogicalVersion();
        this.proxyWriteType = invocationContext.getProxyWriteType();
        this.useStubCache = invocationContext.isUseStubCache();
    }

    @Override
    public void setSelectionKey(SelectionKey key) {
        this.selectionKey = key;
    }

    @Override
    public SelectionKey getSelectionKey() {
        return this.selectionKey;
    }

    @Override
    public void handleRead() {
        if (this.finished.get()) {
            return;
        }
        if (this.readerCtx == null) {
            this.readerCtx = new Reader.Context(this.selectionKey);
        }
        try {
            if (this.invocationTrace != null) {
                LRMIInvocationContext.updateContext((LRMIInvocationTrace)this.invocationTrace, null, null, null, null, (boolean)false, null, null);
            }
            final MarshalInputStream replyStream = this.cpeer.getReader().readReply(this.readerCtx);
            if (this.readerCtx.phase != Reader.Context.Phase.FINISH) {
                this.handler.setReadInterest(this);
                return;
            }
            this.readerCtx = null;
            LRMIRuntime.getRuntime().getThreadPool().execute(new ContextClassLoaderRunnable(this.contextClassLoader){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                protected void execute() {
                    LRMIConnection.setConnection(AsyncContext.this.remoteConnection);
                    LRMIRemoteClassLoaderIdentifier previousIdentifier = RemoteClassLoaderContext.set(AsyncContext.this.remoteClassLoaderIdentifier);
                    try {
                        LRMIInvocationContext.updateContext((LRMIInvocationTrace)AsyncContext.this.invocationTrace, (LRMIInvocationContext.ProxyWriteType)AsyncContext.this.proxyWriteType, (LRMIInvocationContext.InvocationStage)LRMIInvocationContext.InvocationStage.CLIENT_RECEIVE_REPLY, (PlatformLogicalVersion)AsyncContext.this.sourceLogicalVersion, (PlatformLogicalVersion)AsyncContext.this.targetLogicalVersion, (boolean)false, null, null);
                        ReplyPacket replyPacket = AsyncContext.this.cpeer.getReader().unmarshallReply(replyStream);
                        Exception exception = replyPacket.getException();
                        if (exception instanceof LRMIUnhandledException && ((LRMIUnhandledException)exception).getStage() == LRMIUnhandledException.Stage.DESERIALIZATION) {
                            AsyncContext.this.cpeer.getWriter().resetContext();
                        }
                        if (AsyncContext.this.proxyWriteType == LRMIInvocationContext.ProxyWriteType.CACHED_LIGHT && exception instanceof MissingCachedStubException) {
                            AsyncContext.this.proxyWriteType = LRMIInvocationContext.ProxyWriteType.CACHED_FULL;
                            AsyncContext.this.setWriteInterest();
                        } else if (replyPacket.getResult() instanceof ClassProviderRequest) {
                            long clientClassLoaderId = AsyncContext.this.cpeer.getClassProvider().putClassLoader(AsyncContext.this.contextClassLoader);
                            AsyncContext.this.requestPacket = new RequestPacket(AsyncContext.this.cpeer.getClassProvider());
                            AsyncContext.this.reuseBuffer = false;
                            AsyncContext.this.setWriteInterest();
                        } else {
                            AsyncContext.this.finishExecution(replyPacket, true);
                        }
                    }
                    catch (ClassNotFoundException e) {
                        AsyncContext.this.disconnectAndFinish(e, true);
                    }
                    catch (MarshalContextClearedException e) {
                        AsyncContext.this.disconnectAndFinish(e, true);
                    }
                    catch (RemoteException e) {
                        AsyncContext.this.disconnectAndFinish(e, true);
                    }
                    catch (Exception e) {
                        AsyncContext.this.finishExecution(new ReplyPacket<Object>(null, e), true);
                    }
                    finally {
                        LRMIInvocationContext.resetContext();
                        RemoteClassLoaderContext.set(previousIdentifier);
                    }
                }
            });
            LRMIConnection.clearConnection();
        }
        catch (IOException e) {
            this.disconnectAndFinish(e, true);
        }
        catch (Throwable t) {
            Exception e = t instanceof Exception ? (Exception)t : new ExecutionException(t);
            this.finishExecution(new ReplyPacket<Object>(null, e), true);
        }
        finally {
            if (this.invocationTrace != null) {
                LRMIInvocationContext.resetContext();
            }
        }
    }

    private void disconnect() {
        this.cpeer.disconnect();
    }

    private void disconnectAndFinish(Throwable e, boolean initiatedFinish) {
        if (initiatedFinish && !this.finished.compareAndSet(false, true)) {
            return;
        }
        this.disconnect();
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "LRMI transport protocol over NIO broken connection with ServerEndPoint: [" + this.cpeer.getConnectionURL() + "]", e);
        }
        this.finishExecution(new ReplyPacket<Object>(null, this.convertException(e)), false);
    }

    private Exception convertException(Throwable e) {
        if (e instanceof IOException) {
            if (this.watchedObjectContext.requestWatchHasException()) {
                return new ConnectIOException(e.getMessage(), this.watchedObjectContext.getAndClearRequestWatchException());
            }
            if (this.watchedObjectContext.responseWatchHasException()) {
                return new ConnectIOException(e.getMessage(), this.watchedObjectContext.getAndClearResponseWatchException());
            }
            return new ConnectException(e.getMessage(), (Exception)e);
        }
        if (e instanceof MarshalContextClearedException) {
            return new RemoteException(e.getMessage(), e);
        }
        if (e instanceof Exception) {
            return (Exception)e;
        }
        return new ExecutionException(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finishExecution(ReplyPacket replyPacket, boolean initiatedFinish) {
        if (initiatedFinish && !this.finished.compareAndSet(false, true)) {
            return;
        }
        try {
            LRMIConnection.clearConnection();
            this.cpeer.clearAsyncContext();
            this.cpeer.getMonitoringModule().monitorActivity(this.monitoringId, this.cpeer.getWriter(), this.cpeer.getReader());
            this.cpeer.afterInvoke();
            Writer writer = this.cpeer.getWriter();
            if (writer != null) {
                writer.setWriteInterestManager(null);
            }
            this.result.setResultPacket(replyPacket);
        }
        finally {
            SelectionKey currentSelectionKey = this.selectionKey;
            if (currentSelectionKey != null) {
                this.handler.removeChannel((SocketChannel)currentSelectionKey.channel(), this);
            }
        }
    }

    @Override
    public void handleWrite() {
        block9: {
            if (this.finished.get()) {
                return;
            }
            try {
                if (this.writerCtx == null) {
                    try {
                        LRMIInvocationContext.updateContext((LRMIInvocationTrace)this.invocationTrace, (LRMIInvocationContext.ProxyWriteType)this.proxyWriteType, (LRMIInvocationContext.InvocationStage)LRMIInvocationContext.InvocationStage.CLIENT_SEND_REQUEST, (PlatformLogicalVersion)this.sourceLogicalVersion, (PlatformLogicalVersion)this.targetLogicalVersion, (boolean)false, (Boolean)this.useStubCache, null);
                        this.writerCtx = new Writer.Context(this.invocationTrace);
                        this.cpeer.getWriter().writeRequest(this.requestPacket, this.reuseBuffer, this.writerCtx);
                        break block9;
                    }
                    finally {
                        LRMIInvocationContext.resetContext();
                    }
                }
                this.cpeer.getWriter().onWriteEvent();
            }
            catch (IOException e) {
                this.disconnectAndFinish(e, true);
            }
            catch (MarshalContextClearedException e) {
                this.disconnectAndFinish(e, true);
            }
            catch (Throwable t) {
                Exception e = t instanceof Exception ? (Exception)t : new ExecutionException(t);
                this.finishExecution(new ReplyPacket<Object>(null, e), true);
            }
        }
    }

    @Override
    public void handleSetReadInterest() {
        this.watchedObjectContext.watchResponse(this.monitoringId);
    }

    @Override
    public void removeWriteInterest(boolean restoreReadInterest) {
        if (this.writerCtx.getPhase() == Writer.Context.Phase.FINISH) {
            this.writerCtx = null;
            this.handler.setReadInterest(this);
        }
    }

    @Override
    public void setWriteInterest() {
        this.watchedObjectContext.watchRequest(this.monitoringId);
        this.handler.setWriteInterest(this);
    }

    @Override
    public void close(Throwable exception) {
        if (!this.finished.compareAndSet(false, true)) {
            return;
        }
        this.disconnectAndFinish(exception, false);
        this.close();
    }

    @Override
    public void closeAndDisconnect() {
        this.disconnect();
        this.close();
    }

    @Override
    public void close() {
        this.connectionPool.freeConnection(this.cpeer);
    }
}

