/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.lrmi.nio.async;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.async.AsyncFutureListener;
import com.gigaspaces.lrmi.nio.async.IExceptionHandler;
import com.gigaspaces.lrmi.nio.async.IFuture;
import com.gigaspaces.lrmi.nio.async.IResultTransformer;

@InternalApi
public class FutureContext {
    private static final ThreadLocal<FutureParams> _context = new ThreadLocal();

    public static void clear() {
        _context.set(null);
    }

    public static void setFutureListener(AsyncFutureListener listener) {
        FutureParams futureParams = _context.get();
        if (futureParams == null) {
            futureParams = new FutureParams();
            _context.set(futureParams);
        }
        futureParams.listener = listener;
    }

    public static void setResultTransformator(IResultTransformer transformator) {
        FutureParams futureParams = _context.get();
        if (futureParams == null) {
            futureParams = new FutureParams();
            _context.set(futureParams);
        }
        futureParams.transformator = transformator;
    }

    public static void setExceptionHandler(IExceptionHandler exceptionHandler) {
        FutureParams futureParams = _context.get();
        if (futureParams == null) {
            futureParams = new FutureParams();
            _context.set(futureParams);
        }
        futureParams.exceptionHandler = exceptionHandler;
    }

    public static void setFutureResult(IFuture result) {
        FutureParams futureParams = _context.get();
        if (futureParams == null) {
            futureParams = new FutureParams();
            _context.set(futureParams);
        }
        futureParams.result = result;
    }

    public static IFuture getFutureResult() {
        FutureParams ctx = _context.get();
        if (ctx == null) {
            return null;
        }
        return ctx.result;
    }

    public static AsyncFutureListener getFutureListener() {
        FutureParams ctx = _context.get();
        if (ctx == null) {
            return null;
        }
        return ctx.listener;
    }

    public static IResultTransformer getResultTransformer() {
        FutureParams ctx = _context.get();
        if (ctx == null) {
            return null;
        }
        return ctx.transformator;
    }

    public static IExceptionHandler getExceptionhandler() {
        FutureParams ctx = _context.get();
        if (ctx == null) {
            return null;
        }
        return ctx.exceptionHandler;
    }

    public static FutureParams getFutureParams() {
        return _context.get();
    }

    public static class FutureParams {
        private AsyncFutureListener listener;
        private IResultTransformer transformator;
        private IExceptionHandler exceptionHandler;
        private IFuture result;

        private FutureParams() {
        }

        public AsyncFutureListener getListener() {
            return this.listener;
        }

        public IResultTransformer getTransformator() {
            return this.transformator;
        }

        public IExceptionHandler getExceptionHandler() {
            return this.exceptionHandler;
        }

        public IFuture getResult() {
            return this.result;
        }
    }
}

