/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.lrmi.nio.async;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.async.AsyncFutureListener;
import com.gigaspaces.async.internal.DefaultAsyncResult;
import com.gigaspaces.exception.lrmi.ApplicationException;
import com.gigaspaces.exception.lrmi.ProtocolException;
import com.gigaspaces.internal.utils.concurrent.ContextClassLoaderRunnable;
import com.gigaspaces.lrmi.LRMIRuntime;
import com.gigaspaces.lrmi.nio.ReplyPacket;
import com.gigaspaces.lrmi.nio.async.FutureContext;
import com.gigaspaces.lrmi.nio.async.IExceptionHandler;
import com.gigaspaces.lrmi.nio.async.IFuture;
import com.gigaspaces.lrmi.nio.async.IResultTransformer;
import com.j_spaces.kernel.ClassLoaderHelper;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

@InternalApi
public class LRMIFuture<T>
implements IFuture<T> {
    private volatile boolean canceled = false;
    private volatile ReplyPacket<T> replyPacket = null;
    private final Lock _lock = new ReentrantLock();
    private final Condition _resultCondition = this._lock.newCondition();
    private volatile AsyncFutureListener<T> listener = null;
    private final IResultTransformer<T> transformer;
    private final IExceptionHandler exceptionHandler;
    private final AtomicBoolean triggeredEvent = new AtomicBoolean();
    private final boolean embedded;
    private volatile ClassLoader contextClassLoader;

    public LRMIFuture(boolean embedded, ClassLoader contextClassLoader) {
        this.embedded = embedded;
        this.contextClassLoader = contextClassLoader;
        FutureContext.FutureParams futureParams = FutureContext.getFutureParams();
        if (futureParams != null) {
            this.transformer = futureParams.getTransformator();
            this.exceptionHandler = futureParams.getExceptionHandler();
            this.listener = futureParams.getListener();
        } else {
            this.transformer = null;
            this.exceptionHandler = null;
            this.listener = null;
        }
        FutureContext.clear();
    }

    public LRMIFuture(ClassLoader contextClassLoader) {
        this(false, contextClassLoader);
    }

    @Override
    public void setListener(AsyncFutureListener<T> listener) {
        this.listener = listener;
        if (this.isDone()) {
            LRMIRuntime.getRuntime().getThreadPool().execute(new ContextClassLoaderRunnable(this.contextClassLoader){

                @Override
                protected void execute() {
                    LRMIFuture.this.sendEvent();
                }
            });
        }
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        this.canceled = true;
        if (mayInterruptIfRunning && !this.isDone()) {
            try {
                this._lock.lock();
                this._resultCondition.signalAll();
            }
            finally {
                this._lock.unlock();
            }
        }
        return true;
    }

    @Override
    public boolean isCancelled() {
        return this.canceled;
    }

    @Override
    public boolean isDone() {
        return this.replyPacket != null;
    }

    @Override
    public T get() throws InterruptedException, ExecutionException {
        try {
            this._lock.lock();
            this.checkState();
            if (this.isDone()) {
                T t = this.getResult();
                return t;
            }
            this._resultCondition.await();
            this.checkState();
            T t = this.getResult();
            return t;
        }
        finally {
            this._lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        try {
            this._lock.lock();
            this.checkState();
            if (this.isDone()) {
                T t = this.getResult();
                return t;
            }
            if (!this._resultCondition.await(timeout, unit)) {
                throw new TimeoutException("Timeout waiting for result for [" + timeout + "]");
            }
            this.checkState();
            T t = this.getResult();
            return t;
        }
        finally {
            this._lock.unlock();
        }
    }

    protected T getResult() throws ExecutionException {
        if (this.replyPacket.getException() != null) {
            throw new ExecutionException(this.replyPacket.getException());
        }
        T result = this.replyPacket.getResult();
        if (this.transformer != null) {
            result = this.transformer.transform(result);
        }
        return result;
    }

    public void reset(ClassLoader contextClassLoader) {
        this.contextClassLoader = contextClassLoader;
        this.replyPacket = null;
        this.triggeredEvent.set(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setResultPacket(final ReplyPacket<T> replyPacket) {
        if (!this.needsSpawning(replyPacket)) {
            boolean changeClassLoader;
            ClassLoader currentClassLoader = Thread.currentThread().getContextClassLoader();
            boolean bl = changeClassLoader = currentClassLoader != this.contextClassLoader;
            if (changeClassLoader) {
                ClassLoaderHelper.setContextClassLoader(this.contextClassLoader, true);
            }
            try {
                this.setResultPacketInternal(replyPacket);
            }
            finally {
                if (changeClassLoader) {
                    ClassLoaderHelper.setContextClassLoader(currentClassLoader, true);
                }
            }
        } else {
            LRMIRuntime.getRuntime().getThreadPool().execute(new ContextClassLoaderRunnable(this.contextClassLoader){

                @Override
                protected void execute() {
                    LRMIFuture.this.setResultPacketInternal(replyPacket);
                }
            });
        }
    }

    private boolean needsSpawning(ReplyPacket<T> replyPacket) {
        return this.embedded && (replyPacket.getException() != null || this.listener != null);
    }

    private void setResultPacketInternal(ReplyPacket<T> replyPacket) {
        if (replyPacket.getException() != null) {
            Throwable newException = replyPacket.getException();
            while (newException instanceof ExecutionException || newException instanceof ProtocolException || newException instanceof ApplicationException) {
                newException = newException.getCause();
            }
            if (this.exceptionHandler != null && (newException = this.exceptionHandler.handleException(newException, this)) == null) {
                return;
            }
            replyPacket.setException(newException instanceof Exception ? newException : new ExecutionException(newException));
        }
        this.replyPacket = replyPacket;
        try {
            this._lock.lock();
            this._resultCondition.signalAll();
        }
        finally {
            this._lock.unlock();
        }
        this.sendEvent();
    }

    private void sendEvent() {
        if (this.listener != null && this.triggeredEvent.compareAndSet(false, true)) {
            DefaultAsyncResult<Object> res;
            if (this.replyPacket.getException() != null) {
                res = new DefaultAsyncResult<Object>(null, this.replyPacket.getException());
            } else {
                T result = this.replyPacket.getResult();
                ExecutionException exp = null;
                if (this.transformer != null) {
                    try {
                        result = this.transformer.transform(result);
                    }
                    catch (ExecutionException e) {
                        exp = e;
                    }
                }
                res = new DefaultAsyncResult<T>(result, exp);
            }
            this.listener.onResult(res);
        }
    }

    @Override
    public void setResult(Object result) {
        if (result instanceof Exception) {
            this.setResultPacket(new ReplyPacket<Object>(null, (Exception)result));
        } else {
            this.setResultPacket(new ReplyPacket<Object>(result, null));
        }
    }

    private void checkState() {
        if (this.isCancelled()) {
            throw new CancellationException("task was cancelled");
        }
    }
}

