/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.lrmi.nio.async;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.lrmi.nio.ReplyPacket;
import com.gigaspaces.lrmi.nio.async.FutureContext;
import com.gigaspaces.lrmi.nio.async.IFuture;
import com.gigaspaces.lrmi.nio.async.LRMIFuture;
import com.gigaspaces.start.SystemBoot;
import com.j_spaces.kernel.threadpool.DynamicExecutors;
import com.j_spaces.kernel.threadpool.DynamicThread;
import com.j_spaces.kernel.threadpool.DynamicThreadPoolExecutor;
import com.j_spaces.kernel.threadpool.policy.TimedBlockingPolicy;
import com.j_spaces.kernel.threadpool.queue.DynamicQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import org.jini.rio.boot.CommonClassLoader;

@InternalApi
public class LRMIThreadPoolExecutor
extends DynamicThreadPoolExecutor {
    private static final Logger _warnLogger = Logger.getLogger("com.gigaspaces.lrmi.resources");
    private static final double _warnFactor = Double.parseDouble(System.getProperty("com.gs.lrmi.resources.warn-threshold-factor", "10.0"));

    public LRMIThreadPoolExecutor(int min, int max, long keepAliveTime, int capacity, long waitTime, int priority, String poolName, boolean preStart, boolean warnOnQueueUsage) {
        super(min, max, keepAliveTime, TimeUnit.MILLISECONDS, new DynamicQueue<Runnable>(capacity));
        final ThreadFactory threadFactory = DynamicExecutors.priorityThreadFactory(priority, poolName);
        this.setThreadFactory(new ThreadFactory(){

            @Override
            public Thread newThread(Runnable runnable) {
                DynamicThread t = (DynamicThread)((Object)threadFactory.newThread(runnable));
                if (SystemBoot.isRunningWithinGSC()) {
                    t.setAllThreadContextClassLoader((ClassLoader)CommonClassLoader.getInstance());
                }
                return t;
            }
        });
        TimedBlockingPolicy timedBlockingPolicy = warnOnQueueUsage ? new TimedBlockingPolicy(waitTime, poolName, warnOnQueueUsage, (int)((double)max * _warnFactor), _warnLogger) : new TimedBlockingPolicy(waitTime);
        this.setRejectedExecutionHandler(timedBlockingPolicy);
        ((DynamicQueue)this.getQueue()).setThreadPoolExecutor(this);
        if (preStart) {
            this.prestartAllCoreThreads();
        }
    }

    public <T> IFuture<T> submit(Callable<T> task) {
        if (task == null) {
            throw new NullPointerException("Can't execute null task.");
        }
        LRMIFuture future = (LRMIFuture)FutureContext.getFutureResult();
        if (future == null) {
            future = new LRMIFuture(Thread.currentThread().getContextClassLoader());
        } else {
            future.reset(Thread.currentThread().getContextClassLoader());
        }
        this.execute(new FutureTask(future, task));
        return future;
    }

    private static class FutureTask<T>
    implements Runnable {
        private final LRMIFuture<T> _future;
        private final Callable<T> _task;

        private FutureTask(LRMIFuture<T> future, Callable<T> task) {
            this._future = future;
            this._task = task;
        }

        @Override
        public void run() {
            Object result = null;
            Exception exception = null;
            try {
                result = this._task.call();
            }
            catch (Exception e) {
                exception = e;
            }
            this._future.setResultPacket(new ReplyPacket<Object>(result, exception));
        }
    }
}

