/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.lrmi.nio.filters;

import com.gigaspaces.lrmi.nio.filters.IOFilter;
import com.gigaspaces.lrmi.nio.filters.IOFilterFactory;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.InetSocketAddress;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class AddressMatcherFilterFactoryDelegator
implements IOFilterFactory {
    private static final Logger _logger = Logger.getLogger("com.gigaspaces.lrmi.filters");
    private final IOFilterFactory _filterFactory;
    private final List<Pattern> _addresMatchers;

    public AddressMatcherFilterFactoryDelegator(IOFilterFactory filterFactory, String addressMatchersFile) {
        this._filterFactory = filterFactory;
        this._addresMatchers = new LinkedList<Pattern>();
        InputStream resourceAsStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(addressMatchersFile);
        if (resourceAsStream == null) {
            throw new IllegalArgumentException("Could not locate lrmi filter factory address matchers file " + addressMatchersFile + " in the classpath");
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("Loading address matcher configuration file from " + addressMatchersFile);
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(resourceAsStream));
        String line = null;
        try {
            while ((line = reader.readLine()) != null) {
                if (line.startsWith("#")) continue;
                this._addresMatchers.add(Pattern.compile(line));
            }
        }
        catch (PatternSyntaxException e) {
            throw new IllegalStateException("Error while parsing lrmi filter factory address matchers file " + addressMatchersFile, e);
        }
        catch (IOException e) {
            throw new IllegalStateException("Error while parsing lrmi filter factory address matchers file " + addressMatchersFile, e);
        }
    }

    @Override
    public IOFilter createClientFilter(InetSocketAddress remoteAddress) throws Exception {
        for (Pattern addressMatcher : this._addresMatchers) {
            remoteAddress.getHostName();
            if (!addressMatcher.matcher(remoteAddress.toString()).matches()) continue;
            if (_logger.isLoggable(Level.FINER)) {
                _logger.finer("Created lrmi filter for a connection to " + remoteAddress);
            }
            return this._filterFactory.createClientFilter(remoteAddress);
        }
        if (_logger.isLoggable(Level.FINER)) {
            _logger.finer("No address matcher found for connection to " + remoteAddress + ", no filter created");
        }
        return null;
    }

    @Override
    public IOFilter createServerFilter(InetSocketAddress remoteAddress) throws Exception {
        for (Pattern addressMatcher : this._addresMatchers) {
            remoteAddress.getHostName();
            if (!addressMatcher.matcher(remoteAddress.toString()).matches()) continue;
            if (_logger.isLoggable(Level.FINER)) {
                _logger.finer("Created lrmi filter for a connection to " + remoteAddress);
            }
            return this._filterFactory.createServerFilter(remoteAddress);
        }
        if (_logger.isLoggable(Level.FINER)) {
            _logger.finer("No address matcher found for connection to " + remoteAddress + ", no filter created");
        }
        return null;
    }
}

