/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.lrmi.nio.filters;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.lrmi.LRMIInvocationContext;
import com.gigaspaces.lrmi.LRMIInvocationTrace;
import com.gigaspaces.lrmi.nio.IChannelWriter;
import com.gigaspaces.lrmi.nio.Reader;
import com.gigaspaces.lrmi.nio.Writer;
import com.gigaspaces.lrmi.nio.filters.IOBlockFilter;
import com.gigaspaces.lrmi.nio.filters.IOFilterContext;
import com.gigaspaces.lrmi.nio.filters.IOFilterException;
import com.gigaspaces.lrmi.nio.filters.IOFilterResult;
import com.gigaspaces.lrmi.nio.filters.UnwrapAllocationStrategy;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.ClosedChannelException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.space.InternalSpaceException;

@InternalApi
public class IOBlockFilterContainer {
    private static final Logger logger = Logger.getLogger(IOBlockFilterContainer.class.getName());
    private static final Logger _contextLogger = Logger.getLogger("com.gigaspaces.lrmi.context");
    public static final byte MESSAGE_SUFFIX = 0;
    public static final byte PREFIX_PART = 1;
    private static final int HUNDRED_M = 0x6400000;
    private final IChannelWriter writer;
    private final Reader reader;
    private boolean newContent;
    private static final ByteBuffer empty = ByteBuffer.wrap(new byte[0]);
    private static final UnwrapAllocationStrategy UNWRAP_ALLOCATION_STRATEGY = UnwrapAllocationStrategy.fromString(System.getProperty("com.gs.lrmi.filter.unrap.buffer.allocation.strategy", "CONSTANT"));

    public IOBlockFilterContainer(Reader reader, IChannelWriter writer) {
        this.reader = reader;
        this.writer = writer;
    }

    public void wrap(IOFilterContext context) throws IOFilterException {
        context.getDst().putInt(0);
        context.getDst().put((byte)0);
        context.filter.wrap(context.getSrc(), context.getDst());
        if (context.getSrc().hasRemaining()) {
            context.getDst().put(4, (byte)1);
            context.result.setStatus(IOFilterResult.Status.BUFFER_OVERFLOW);
        } else {
            context.result.setStatus(IOFilterResult.Status.OK);
        }
        context.getDst().flip();
        context.getDst().putInt(0, context.getDst().remaining() - 4);
    }

    public void unwrap(IOFilterContext context) throws IOFilterException {
        if (context.getSrc().remaining() < context.applicationBufferSize) {
            this.enlargeSourceBuffer(context);
        }
        boolean isLastMessage = context.getDst().get() == 0;
        context.filter.unwrap(context.getDst(), context.getSrc());
        if (context.result.getStatus() == IOFilterResult.Status.CLOSED) {
            throw new InternalSpaceException("IOFilter closed");
        }
        while (context.getDst().hasRemaining()) {
            if (context.getSrc().remaining() < context.applicationBufferSize) {
                this.enlargeSourceBuffer(context);
            }
            context.filter.unwrap(context.getDst(), context.getSrc());
            if (context.result.getStatus() != IOFilterResult.Status.CLOSED) continue;
            throw new InternalSpaceException("IOFilter closed");
        }
        if (isLastMessage) {
            context.result.setStatus(IOFilterResult.Status.OK);
            context.getSrc().flip();
        } else {
            context.result.setStatus(IOFilterResult.Status.BUFFER_UNDERFLOW);
        }
    }

    private void enlargeSourceBuffer(IOFilterContext context) {
        switch (UNWRAP_ALLOCATION_STRATEGY) {
            case CONSTANT: {
                context.setSrc(this.enlargeBuffer(context.getSrc(), context.applicationBufferSize - context.getSrc().remaining()));
                break;
            }
            case EXPONENTIAL: {
                int additionalSize = Math.min(context.getSrc().capacity(), 0x6400000);
                context.setSrc(this.enlargeBuffer(context.getSrc(), additionalSize));
            }
        }
    }

    private ByteBuffer enlargeBuffer(ByteBuffer src, int additionalSize) {
        ByteBuffer res = ByteBuffer.allocate(src.limit() + additionalSize);
        src.flip();
        res.put(src);
        res.position(src.position());
        return res;
    }

    public IOFilterContext createContext(IOBlockFilter filter) {
        IOFilterContext ctx = new IOFilterContext();
        ctx.filter = filter;
        ctx.setSrc(ByteBuffer.allocate(filter.getApplicationBufferSize()));
        ctx.setDst(ByteBuffer.allocate(filter.getPacketBufferSize() + 5));
        ctx.applicationBufferSize = filter.getApplicationBufferSize();
        ctx.packetBufferSize = filter.getPacketBufferSize();
        ctx.result = new IOFilterResult(IOFilterResult.Status.OK, IOFilterResult.HandshakeStatus.NOT_HANDSHAKING, 0, 0);
        return ctx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void writeBytesNonBlocking(Writer.Context ctx, IOFilterContext filterContext) throws IOFilterException, IOException {
        if (filterContext.result.getHandshakeStatus() != IOFilterResult.HandshakeStatus.NOT_HANDSHAKING) {
            throw new IOFilterException("Request to write bytes while handshake " + (Object)((Object)filterContext.result.getHandshakeStatus()));
        }
        ctx.getBuffer().getInt();
        Writer.Context context = ctx.duplicate();
        ByteBuffer orig = filterContext.getSrc();
        try {
            filterContext.setSrc(context.getBuffer());
            this.wrap(filterContext);
            context = this.createWriteContext(ctx, filterContext);
            context.setBuffer(this.copy(filterContext.getDst()));
            filterContext.getDst().clear();
            context.setCurrentPosition(0);
            context.setPhase(Writer.Context.Phase.START);
            boolean finished = filterContext.result.getStatus() == IOFilterResult.Status.OK;
            this.writer.writeBytesToChannelNoneBlocking(context, finished);
            while (!finished) {
                this.wrap(filterContext);
                context = this.createWriteContext(ctx, filterContext);
                context.setBuffer(this.copy(filterContext.getDst()));
                filterContext.getDst().clear();
                context.setCurrentPosition(0);
                context.setPhase(Writer.Context.Phase.START);
                finished = filterContext.result.getStatus() == IOFilterResult.Status.OK;
                this.writer.writeBytesToChannelNoneBlocking(context, finished);
            }
        }
        finally {
            filterContext.setSrc(orig);
        }
        if (filterContext.result.getHandshakeStatus() != IOFilterResult.HandshakeStatus.NOT_HANDSHAKING) {
            throw new IOFilterException("Request to write bytes while handshake " + (Object)((Object)filterContext.result.getHandshakeStatus()));
        }
    }

    private Writer.Context createWriteContext(Writer.Context ctx, IOFilterContext filterContext) {
        Writer.Context context;
        if (filterContext.result.getStatus() == IOFilterResult.Status.OK) {
            context = ctx;
        } else {
            LRMIInvocationTrace trace = _contextLogger.isLoggable(Level.FINE) ? LRMIInvocationContext.getCurrentContext().getTrace() : null;
            context = new Writer.Context(trace);
        }
        return context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized byte[] handleNoneBlockingContent(Reader.Context ctx, byte[] bytes, IOFilterContext filterContext) throws IOFilterException {
        try {
            if (filterContext.result.getHandshakeStatus() != IOFilterResult.HandshakeStatus.NOT_HANDSHAKING) {
                this.newContent = true;
                this.copy(filterContext.getDst(), bytes);
                this.processHandshake(filterContext);
                ctx.reset();
                return null;
            }
        }
        catch (Exception e) {
            throw new IOFilterException(e);
        }
        ByteBuffer old = filterContext.getDst();
        filterContext.setDst(ByteBuffer.wrap(bytes));
        try {
            this.unwrap(filterContext);
            if (filterContext.result.getStatus() == IOFilterResult.Status.OK) {
                filterContext.getDst().clear();
                byte[] byArray = IOBlockFilterContainer.toBytes(filterContext.getSrc());
                return byArray;
            }
            ctx.phase = Reader.Context.Phase.START;
            ctx.bytesRead = 0;
        }
        finally {
            filterContext.setDst(old);
        }
        return null;
    }

    private void copy(ByteBuffer buf, byte[] bytes) {
        buf.clear();
        buf.put(bytes);
        buf.flip();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized byte[] handleBlockingContant(byte[] bytes, IOFilterContext filterContext, int slowConsumerTimeout) throws ClosedChannelException, IOFilterException {
        try {
            if (filterContext.result.getHandshakeStatus() != IOFilterResult.HandshakeStatus.NOT_HANDSHAKING) {
                this.newContent = true;
                this.copy(filterContext.getDst(), bytes);
                this.processHandshake(filterContext);
                return null;
            }
        }
        catch (Exception e) {
            throw new IOFilterException(e);
        }
        ByteBuffer source = ByteBuffer.wrap(bytes);
        ByteBuffer old = filterContext.getDst();
        try {
            filterContext.result.setStatus(IOFilterResult.Status.BUFFER_UNDERFLOW);
            while (filterContext.result.getStatus() != IOFilterResult.Status.OK) {
                filterContext.setDst(source);
                this.unwrap(filterContext);
                if (filterContext.result.getStatus() != IOFilterResult.Status.BUFFER_UNDERFLOW) continue;
                source = this.reader.readBytesFromChannelBlocking(true, slowConsumerTimeout, 0);
            }
            filterContext.getDst().flip();
            byte[] byArray = IOBlockFilterContainer.toBytes(filterContext.getSrc());
            return byArray;
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Failed to handle blocking content", e);
            byte[] byArray = bytes;
            return byArray;
        }
        finally {
            filterContext.setDst(old);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void writeBytesBlocking(ByteBuffer dataBuffer, IOFilterContext filterContext) throws IOFilterException, IOException {
        if (filterContext.result.getHandshakeStatus() != IOFilterResult.HandshakeStatus.NOT_HANDSHAKING) {
            throw new IOFilterException("Request to write bytes while handshake " + (Object)((Object)filterContext.result.getHandshakeStatus()));
        }
        dataBuffer.getInt();
        ByteBuffer originalSrcBuf = filterContext.getSrc();
        try {
            filterContext.setSrc(dataBuffer);
            this.wrap(filterContext);
            this.writer.writeBytesToChannelBlocking(filterContext.getDst());
            filterContext.getDst().clear();
            while (filterContext.result.getStatus() != IOFilterResult.Status.OK) {
                this.wrap(filterContext);
                this.writer.writeBytesToChannelBlocking(filterContext.getDst());
                filterContext.getDst().clear();
            }
        }
        finally {
            filterContext.setSrc(originalSrcBuf);
        }
        if (filterContext.result.getHandshakeStatus() != IOFilterResult.HandshakeStatus.NOT_HANDSHAKING) {
            throw new IOFilterException("Request to write bytes while handshake " + (Object)((Object)filterContext.result.getHandshakeStatus()));
        }
    }

    public void beginHandshake(IOFilterContext filterContext) throws IOFilterException, IOException {
        filterContext.filter.beginHandshake();
        filterContext.result.setHandshakeStatus(filterContext.filter.getHandshakeStatus());
        this.processHandshake(filterContext);
    }

    private void processHandshake(IOFilterContext filterContext) throws IOFilterException, IOException {
        boolean isBlocking = this.writer.isBlocking();
        while (filterContext.result.getHandshakeStatus() != IOFilterResult.HandshakeStatus.NOT_HANDSHAKING) {
            this.handshakeOneStep(filterContext, isBlocking);
            if (!this.needToWaitForMoreBytes(filterContext, isBlocking)) continue;
            return;
        }
    }

    private boolean needToWaitForMoreBytes(IOFilterContext filterContext, boolean isBlocking) {
        return !isBlocking && filterContext.result.getHandshakeStatus() == IOFilterResult.HandshakeStatus.NEED_UNWRAP;
    }

    private void handshakeOneStep(IOFilterContext filterContext, boolean isBlocking) throws IOFilterException, IOException {
        if (filterContext.result.getStatus() == IOFilterResult.Status.CLOSED) {
            throw new InternalSpaceException("IOFilter closed");
        }
        switch (filterContext.result.getHandshakeStatus()) {
            case FINISHED: {
                filterContext.result.setHandshakeStatus(filterContext.filter.getHandshakeStatus());
                filterContext.getDst().clear();
                filterContext.getSrc().clear();
                return;
            }
            case NEED_TASK: {
                this.handleNeedTask(filterContext);
                filterContext.result.setHandshakeStatus(filterContext.filter.getHandshakeStatus());
                return;
            }
            case NEED_UNWRAP: {
                this.handleNeedUnwrap(filterContext, isBlocking);
                filterContext.result.setHandshakeStatus(filterContext.filter.getHandshakeStatus());
                return;
            }
            case NEED_WRAP: {
                this.handleNeedWrap(filterContext, isBlocking);
                filterContext.result.setHandshakeStatus(filterContext.filter.getHandshakeStatus());
                return;
            }
            case NOT_HANDSHAKING: {
                filterContext.result.setHandshakeStatus(filterContext.filter.getHandshakeStatus());
                return;
            }
        }
        throw new IllegalStateException(String.valueOf((Object)filterContext.result.getHandshakeStatus()));
    }

    private void handleNeedWrap(IOFilterContext filterContext, boolean isBlocking) throws IOFilterException, IOException {
        ByteBuffer buf = ByteBuffer.allocate(filterContext.packetBufferSize + 4);
        buf.order(ByteOrder.BIG_ENDIAN);
        buf.putInt(0);
        filterContext.filter.wrap(empty, buf);
        buf.flip();
        buf.putInt(0, buf.remaining() - 4);
        if (isBlocking) {
            this.writer.writeBytesToChannelBlocking(buf);
        } else {
            LRMIInvocationTrace trace = _contextLogger.isLoggable(Level.FINE) ? LRMIInvocationContext.getCurrentContext().getTrace() : null;
            Writer.Context ctx = new Writer.Context(trace);
            ctx.setTotalLength(buf.remaining());
            ctx.setBuffer(buf);
            this.writer.writeBytesToChannelNoneBlocking(ctx, false);
        }
    }

    private void handleNeedUnwrap(IOFilterContext filterContext, boolean isBlocking) throws IOFilterException, IOException {
        if (isBlocking) {
            this.handleBlokingNeedUnwrap(filterContext);
        } else {
            this.handleNoneBlokingNeedUnwrap(filterContext);
        }
    }

    private void handleNoneBlokingNeedUnwrap(IOFilterContext filterContext) throws IOFilterException {
        if (this.newContent) {
            filterContext.filter.unwrap(filterContext.getDst(), filterContext.getSrc());
            filterContext.getDst().clear();
            this.newContent = false;
        }
    }

    private void handleBlokingNeedUnwrap(IOFilterContext filterContext) throws IOFilterException, IOException {
        ByteBuffer bytes = this.reader.readBytesFromChannelBlocking(true, 0, 0);
        filterContext.filter.unwrap(bytes, filterContext.getSrc());
    }

    private void handleNeedTask(IOFilterContext filterContext) {
        filterContext.filter.getDelegatedTask().run();
    }

    private ByteBuffer copy(ByteBuffer buffer) {
        ByteBuffer res = ByteBuffer.allocate(buffer.remaining());
        for (int i = buffer.position(); i < buffer.limit(); ++i) {
            res.put(i, buffer.get(i));
        }
        return res;
    }

    public static byte[] toBytes(ByteBuffer buf) {
        byte[] res = new byte[buf.remaining()];
        buf.get(res);
        buf.clear();
        return res;
    }

    public static List<Byte> toList(byte[] array) {
        if (array == null) {
            return Collections.emptyList();
        }
        ArrayList<Byte> res = new ArrayList<Byte>(array.length);
        for (int i = 0; i < array.length; ++i) {
            res.add(i, array[i]);
        }
        return res;
    }
}

