/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.lrmi.nio.filters;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.lrmi.nio.IChannelWriter;
import com.gigaspaces.lrmi.nio.Reader;
import com.gigaspaces.lrmi.nio.Writer;
import com.gigaspaces.lrmi.nio.filters.AddressMatcherFilterFactoryDelegator;
import com.gigaspaces.lrmi.nio.filters.IOBlockFilter;
import com.gigaspaces.lrmi.nio.filters.IOBlockFilterContainer;
import com.gigaspaces.lrmi.nio.filters.IOFilter;
import com.gigaspaces.lrmi.nio.filters.IOFilterContext;
import com.gigaspaces.lrmi.nio.filters.IOFilterException;
import com.gigaspaces.lrmi.nio.filters.IOFilterFactory;
import com.gigaspaces.lrmi.nio.filters.IOFilterManager;
import com.gigaspaces.lrmi.nio.filters.IOInternalFilter;
import com.gigaspaces.lrmi.nio.filters.IOInternalFilterManager;
import com.gigaspaces.lrmi.nio.filters.IOStreamFilter;
import com.gigaspaces.lrmi.nio.filters.IOStreamFilterManager;
import com.gigaspaces.start.XapModules;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SocketChannel;
import java.util.logging.Level;
import java.util.logging.Logger;

@InternalApi
public class IOBlockFilterManager
implements IOFilterManager {
    private final IOBlockFilterContainer filterContainer;
    private final IOFilterContext filterContext;
    private static IOFilterFactory _filterFactory;

    public IOBlockFilterManager(Reader reader, IChannelWriter writer, IOBlockFilter filter) {
        writer.setFilterManager(this);
        reader.setFilterManager(this);
        this.filterContainer = new IOBlockFilterContainer(reader, writer);
        this.filterContext = this.filterContainer.createContext(filter);
    }

    @Override
    public void writeBytesNonBlocking(Writer.Context writeContext) throws IOException, IOFilterException {
        this.filterContainer.writeBytesNonBlocking(writeContext, this.filterContext);
    }

    @Override
    public byte[] handleNoneBlockingContant(Reader.Context ctx, byte[] bytes) throws IOException, IOFilterException {
        return this.filterContainer.handleNoneBlockingContent(ctx, bytes, this.filterContext);
    }

    @Override
    public byte[] handleBlockingContant(byte[] bytes, int slowConsumerTimeout) throws ClosedChannelException, IOException, IOFilterException {
        return this.filterContainer.handleBlockingContant(bytes, this.filterContext, slowConsumerTimeout);
    }

    @Override
    public void writeBytesBlocking(ByteBuffer dataBuffer) throws IOException, IOFilterException {
        this.filterContainer.writeBytesBlocking(dataBuffer, this.filterContext);
    }

    public static IOFilterManager createFilter(Reader reader, Writer writer, boolean mode, SocketChannel channel) throws Exception {
        SocketAddress remoteAddress = null;
        try {
            remoteAddress = channel.socket().getRemoteSocketAddress();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (IOBlockFilterManager.getFilterFactory() != null) {
            IOFilter filter = IOBlockFilterManager.createfilter(mode, IOBlockFilterManager.getFilterFactory(), (InetSocketAddress)remoteAddress);
            if (filter == null) {
                return null;
            }
            if (filter instanceof IOBlockFilter) {
                IOBlockFilterManager blockFilterManager = new IOBlockFilterManager(reader, writer, (IOBlockFilter)filter);
                return blockFilterManager;
            }
            if (filter instanceof IOStreamFilter) {
                IOStreamFilterManager streamFilterManager = new IOStreamFilterManager(reader, writer, (IOStreamFilter)filter);
                return streamFilterManager;
            }
            if (filter instanceof IOInternalFilter) {
                IOInternalFilterManager internalFilterManager = new IOInternalFilterManager(reader, writer, (IOInternalFilter)filter);
                return internalFilterManager;
            }
            throw new IllegalArgumentException("Filter should implements " + IOStreamFilter.class.getName() + " or " + IOBlockFilter.class.getName() + (filter == null ? "" : ", actual: " + filter.getClass()));
        }
        return null;
    }

    private static IOFilter createfilter(boolean mode, IOFilterFactory filterFactory, InetSocketAddress remoteAddress) throws Exception {
        IOFilter filter = mode ? filterFactory.createClientFilter(remoteAddress) : filterFactory.createServerFilter(remoteAddress);
        return filter;
    }

    private static IOFilterFactory loadFilterFactoryFromSystemProperty() throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        String className = System.getProperty("com.gs.lrmi.filter.factory");
        if (className == null) {
            return null;
        }
        Class<?> c = IOBlockFilterManager.class.getClassLoader().loadClass(className);
        IOFilterFactory filterFactory = (IOFilterFactory)c.newInstance();
        Logger.getLogger("com.gigaspaces.lrmi.filters").info("Created LRMI filter factory: " + className);
        String addressMatcherFile = System.getProperty("com.gs.lrmi.filter.address-matchers-file");
        if (addressMatcherFile != null) {
            filterFactory = new AddressMatcherFilterFactoryDelegator(filterFactory, addressMatcherFile);
        }
        return filterFactory;
    }

    @Override
    public void beginHandshake() throws IOFilterException, IOException {
        this.filterContainer.beginHandshake(this.filterContext);
    }

    public static void setFilterFactory(IOFilterFactory _filterFactory) {
        IOBlockFilterManager._filterFactory = _filterFactory;
    }

    public static IOFilterFactory getFilterFactory() {
        return _filterFactory;
    }

    static {
        try {
            _filterFactory = IOBlockFilterManager.loadFilterFactoryFromSystemProperty();
        }
        catch (ClassNotFoundException e) {
            Logger.getLogger("com.gigaspaces.lrmi.filters").log(Level.SEVERE, "Error while creating LRMI filter factory, make sure the filter class is available in the classpath (lib/ext for service grid components, or the same classpath of the classloader that loaded " + XapModules.DATA_GRID.getJarFileName() + " for remote clients): " + e, e);
        }
        catch (Exception e) {
            Logger.getLogger("com.gigaspaces.lrmi.filters").log(Level.SEVERE, "Error while creating LRMI filter factory: " + e, e);
        }
    }
}

