/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.lrmi.nio.filters;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.exception.lrmi.SlowConsumerException;
import com.gigaspaces.lrmi.nio.Reader;
import com.gigaspaces.lrmi.nio.Writer;
import com.gigaspaces.lrmi.nio.filters.IOFilterException;
import com.gigaspaces.lrmi.nio.filters.IOFilterManager;
import com.gigaspaces.lrmi.nio.filters.IOInternalFilter;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;

@InternalApi
public class IOInternalFilterManager
implements IOFilterManager {
    private final IOInternalFilter delegate;

    public IOInternalFilterManager(Reader reader, Writer writer, IOInternalFilter filter) {
        reader.setFilterManager(this);
        writer.setFilterManager(this);
        this.delegate = filter;
        this.delegate.setWriter(writer);
        this.delegate.setReader(reader);
    }

    @Override
    public void writeBytesNonBlocking(Writer.Context ctx) throws IOException, IOFilterException {
        this.delegate.writeBytesNonBlocking(ctx);
    }

    @Override
    public byte[] handleNoneBlockingContant(Reader.Context ctx, byte[] bytes) throws IOException, IOFilterException {
        return this.delegate.handleNoneBlockingContant(ctx, bytes);
    }

    @Override
    public byte[] handleBlockingContant(byte[] buffer, int slowConsumerTimeout) throws ClosedChannelException, IOException, IOFilterException {
        return this.delegate.handleBlockingContant(buffer, slowConsumerTimeout);
    }

    @Override
    public void writeBytesBlocking(ByteBuffer dataBuffer) throws ClosedChannelException, SlowConsumerException, IOException, IOFilterException {
        this.delegate.writeBytesBlocking(dataBuffer);
    }

    @Override
    public void beginHandshake() throws IOFilterException, IOException {
        this.delegate.beginHandshake();
    }
}

