/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.lrmi.nio.filters;

import com.gigaspaces.lrmi.nio.filters.IOBlockFilter;
import com.gigaspaces.lrmi.nio.filters.IOBlockFilterContainer;
import com.gigaspaces.lrmi.nio.filters.IOFilterException;
import com.gigaspaces.lrmi.nio.filters.IOFilterResult;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;

public class IOSSLFilter
implements IOBlockFilter {
    private static final Logger logger = Logger.getLogger(IOBlockFilterContainer.class.getName());
    private final SSLEngine _sslEngine;
    private final SSLContext _sslContext;
    private final String _uid;
    private final SocketAddress _remoteAddress;

    public IOSSLFilter(SSLContext sslContext, SocketAddress remoteAddress) {
        this._sslContext = sslContext;
        this._remoteAddress = remoteAddress;
        this._sslEngine = this._sslContext.createSSLEngine();
        this._uid = UUID.randomUUID().toString();
    }

    @Override
    public void beginHandshake() throws IOFilterException {
        if (logger.isLoggable(Level.FINE)) {
            if (this.getUseClientMode()) {
                logger.fine("Client IOSSLFilter with uid " + this._uid + " connected to " + this._remoteAddress + " starting handshake");
            } else {
                logger.fine("Server IOSSLFilter with uid " + this._uid + " connected to " + this._remoteAddress + " starting handshake");
            }
        }
        try {
            this._sslEngine.beginHandshake();
        }
        catch (SSLException e) {
            throw new IOFilterException(e);
        }
    }

    @Override
    public int getApplicationBufferSize() {
        return this._sslEngine.getSession().getApplicationBufferSize();
    }

    @Override
    public Runnable getDelegatedTask() {
        return this._sslEngine.getDelegatedTask();
    }

    @Override
    public IOFilterResult.HandshakeStatus getHandshakeStatus() {
        return this.translate(this._sslEngine.getHandshakeStatus());
    }

    @Override
    public int getPacketBufferSize() {
        return this._sslEngine.getSession().getPacketBufferSize();
    }

    public boolean getUseClientMode() {
        return this._sslEngine.getUseClientMode();
    }

    public void setUseClientMode(boolean mode) {
        this._sslEngine.setUseClientMode(mode);
    }

    @Override
    public IOFilterResult unwrap(ByteBuffer src, ByteBuffer dst) throws IOFilterException {
        try {
            SSLEngineResult res = this._sslEngine.unwrap(src, dst);
            if (res.getStatus().equals((Object)SSLEngineResult.Status.CLOSED)) {
                throw new IOFilterException("Engine closed");
            }
            return this.translate(res);
        }
        catch (SSLException e) {
            throw new IOFilterException(e);
        }
    }

    @Override
    public IOFilterResult wrap(ByteBuffer src, ByteBuffer dst) throws IOFilterException {
        try {
            SSLEngineResult res = this._sslEngine.wrap(src, dst);
            return this.translate(res);
        }
        catch (SSLException e) {
            throw new IOFilterException(e);
        }
    }

    private IOFilterResult.HandshakeStatus translate(SSLEngineResult.HandshakeStatus handshakeStatus) {
        switch (handshakeStatus) {
            case FINISHED: {
                if (logger.isLoggable(Level.FINE)) {
                    if (this.getUseClientMode()) {
                        logger.info("Client IOSSLFilter with uid " + this._uid + " connected to " + this._remoteAddress + " finished handshake");
                    } else {
                        logger.info("Server IOSSLFilter with uid " + this._uid + " connected to " + this._remoteAddress + " finished handshake");
                    }
                }
                return IOFilterResult.HandshakeStatus.FINISHED;
            }
            case NEED_TASK: {
                return IOFilterResult.HandshakeStatus.NEED_TASK;
            }
            case NEED_UNWRAP: {
                return IOFilterResult.HandshakeStatus.NEED_UNWRAP;
            }
            case NEED_WRAP: {
                return IOFilterResult.HandshakeStatus.NEED_WRAP;
            }
            case NOT_HANDSHAKING: {
                return IOFilterResult.HandshakeStatus.NOT_HANDSHAKING;
            }
        }
        throw new IllegalArgumentException(String.valueOf((Object)handshakeStatus));
    }

    private IOFilterResult translate(SSLEngineResult sslEngineResult) {
        return new IOFilterResult(this.translate(sslEngineResult.getStatus()), this.translate(sslEngineResult.getHandshakeStatus()), sslEngineResult.bytesConsumed(), sslEngineResult.bytesProduced());
    }

    private IOFilterResult.Status translate(SSLEngineResult.Status status) {
        switch (status) {
            case BUFFER_OVERFLOW: {
                return IOFilterResult.Status.BUFFER_OVERFLOW;
            }
            case BUFFER_UNDERFLOW: {
                return IOFilterResult.Status.BUFFER_UNDERFLOW;
            }
            case CLOSED: {
                return IOFilterResult.Status.CLOSED;
            }
            case OK: {
                return IOFilterResult.Status.OK;
            }
        }
        throw new IllegalArgumentException(String.valueOf((Object)status));
    }

    public String toString() {
        return "IOSSLFilter " + this._uid + " " + (this._sslEngine.getUseClientMode() ? "client" : "server") + " " + (Object)((Object)this._sslEngine.getHandshakeStatus());
    }
}

