/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.lrmi.nio.filters;

import com.gigaspaces.lrmi.nio.filters.IOStreamFilter;
import java.io.ByteArrayOutputStream;
import java.nio.ByteBuffer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;

public class IOStreamCompressionFilter
implements IOStreamFilter {
    private static final Logger logger = Logger.getLogger(IOStreamCompressionFilter.class.getName());
    private final Algo algo;
    private Deflater _compressor;
    private Inflater _decompressor;

    public IOStreamCompressionFilter(Algo algo) {
        this.algo = algo;
        this._compressor = new Deflater();
        this._compressor.setLevel(9);
        this._decompressor = new Inflater();
    }

    public void setCompressionLevel(int compressionLevel) {
        this._compressor.setLevel(compressionLevel);
    }

    @Override
    public byte[] unrwap(ByteBuffer buf) throws DataFormatException {
        this._decompressor = new Inflater();
        int size = buf.remaining();
        this._decompressor.setInput(this.toByteArray(buf));
        ByteArrayOutputStream bos = new ByteArrayOutputStream(size);
        byte[] b = new byte[1024];
        while (!this._decompressor.finished()) {
            int count = this._decompressor.inflate(b);
            bos.write(b, 0, count);
        }
        this._decompressor.reset();
        byte[] res = bos.toByteArray();
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Uncompress message of " + size + " bytes to " + res.length + " bytes, ratio [" + (int)Math.ceil((double)size * 100.0 / (double)res.length) + "%]");
        }
        return res;
    }

    private byte[] toByteArray(ByteBuffer buf) {
        byte[] res = new byte[buf.remaining()];
        buf.get(res, 0, res.length);
        return res;
    }

    @Override
    public byte[] wrap(ByteBuffer buf) throws Exception {
        int size = buf.remaining();
        this._compressor.setInput(this.toByteArray(buf));
        this._compressor.finish();
        ByteArrayOutputStream bos = new ByteArrayOutputStream(size);
        byte[] b = new byte[1024];
        while (!this._compressor.finished()) {
            int count = this._compressor.deflate(b);
            bos.write(b, 0, count);
        }
        bos.close();
        this._compressor.reset();
        byte[] res = bos.toByteArray();
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Compress message of " + size + " bytes to " + res.length + " bytes, ratio [" + (int)Math.ceil((double)res.length * 100.0 / (double)size) + "%]");
        }
        return res;
    }

    public static enum Algo {
        ZIP;

    }
}

