/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.lrmi.nio.filters;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.lrmi.nio.Reader;
import com.gigaspaces.lrmi.nio.Writer;
import com.gigaspaces.lrmi.nio.filters.IOFilterException;
import com.gigaspaces.lrmi.nio.filters.IOFilterManager;
import com.gigaspaces.lrmi.nio.filters.IOStreamFilter;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.logging.Logger;

@InternalApi
public class IOStreamFilterManager
implements IOFilterManager {
    private static final Logger logger = Logger.getLogger(IOStreamFilterManager.class.getName());
    private final Writer writer;
    private final IOStreamFilter filter;

    public IOStreamFilterManager(Reader reader, Writer writer, IOStreamFilter filter) {
        this.writer = writer;
        this.filter = filter;
        writer.setFilterManager(this);
        reader.setFilterManager(this);
    }

    @Override
    public byte[] handleBlockingContant(byte[] bytes, int slowConsumerTimeout) throws IOException, IOFilterException {
        try {
            return this.filter.unrwap(ByteBuffer.wrap(bytes));
        }
        catch (Exception e) {
            throw new IOFilterException(e.getMessage(), e);
        }
    }

    @Override
    public byte[] handleNoneBlockingContant(Reader.Context ctx, byte[] bytes) throws IOException, IOFilterException {
        try {
            return this.filter.unrwap(ByteBuffer.wrap(bytes));
        }
        catch (Exception e) {
            throw new IOFilterException(e.getMessage(), e);
        }
    }

    @Override
    public void writeBytesBlocking(ByteBuffer dataBuffer) throws IOException, IOFilterException {
        dataBuffer.getInt();
        try {
            byte[] bytes = this.filter.wrap(dataBuffer);
            this.writer.writeBytesToChannelBlocking(this.toByteBuffer(bytes));
        }
        catch (Exception e) {
            throw new IOFilterException(e.getMessage(), e);
        }
    }

    @Override
    public void writeBytesNonBlocking(Writer.Context ctx) throws IOException {
        ctx.getBuffer().getInt();
        try {
            byte[] bytes = this.filter.wrap(ctx.getBuffer());
            ctx.setBuffer(this.toByteBuffer(bytes));
        }
        catch (Exception e) {
            throw new IOException(String.valueOf(e));
        }
        this.writer.writeBytesToChannelNoneBlocking(ctx, true);
    }

    @Override
    public void beginHandshake() {
    }

    public void setUseClientMode(boolean mode) {
    }

    private ByteBuffer toByteBuffer(byte[] bytes) {
        ByteBuffer res = ByteBuffer.allocate(bytes.length + 4);
        res.order(ByteOrder.BIG_ENDIAN);
        res.putInt(bytes.length);
        res.put(bytes);
        res.flip();
        return res;
    }
}

