/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.lrmi.nio.filters;

import com.gigaspaces.lrmi.nio.filters.BouncyCastleSelfSignedCertificate;
import com.gigaspaces.lrmi.nio.filters.IOFilter;
import com.gigaspaces.lrmi.nio.filters.IOFilterFactory;
import com.gigaspaces.lrmi.nio.filters.IOSSLFilter;
import com.gigaspaces.lrmi.nio.filters.SelfSignedCertificate;
import com.gigaspaces.lrmi.nio.filters.TrustManagers;
import com.j_spaces.kernel.ResourceLoader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.URL;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;

public class SSLFilterFactory
implements IOFilterFactory {
    private static final Logger _logger = Logger.getLogger(SSLFilterFactory.class.getName());
    private final String PROTOCOL;
    private final String keystore;
    private final String password;
    private KeyStore ks;
    private boolean autoGenerateCertificate = false;

    public SSLFilterFactory() {
        this(System.getProperty("com.gs.lrmi.filter.security.keystore"), System.getProperty("com.gs.lrmi.filter.security.password"));
    }

    public SSLFilterFactory(String keystore, String password) {
        if (keystore == null || password == null) {
            this.createSelfSignedCertificate();
            this.autoGenerateCertificate = true;
        }
        if (this.ks == null && keystore == null) {
            throw new IllegalArgumentException("SSL keystore cannot be null (com.gs.lrmi.filter.security.keystore)");
        }
        if (this.ks == null && password == null) {
            throw new IllegalArgumentException("SSL password cannot be null (com.gs.lrmi.filter.security.password)");
        }
        this.keystore = keystore;
        this.password = password;
        this.PROTOCOL = System.getProperty("com.gs.lrmi.filter.security.protocol", "TLS");
    }

    private void createSelfSignedCertificate() {
        try {
            this.ks = SelfSignedCertificate.keystore();
        }
        catch (Throwable e) {
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.log(Level.FINEST, "Failed to create self signed certificate using sun classes will try Bouncy Castle.", e);
            } else if (_logger.isLoggable(Level.INFO)) {
                _logger.log(Level.INFO, "Could not create self signed certificate using sun classes - trying Bouncy Castle");
            }
            try {
                this.ks = BouncyCastleSelfSignedCertificate.keystore();
            }
            catch (Throwable t) {
                _logger.log(Level.WARNING, "Failed to create self signed certificate using Bouncy Castle classes.\n please add Bouncy Castle jars to classpath (or add the artifact org.bouncycastle.bcpkix-jdk15on to maven)", t);
            }
        }
    }

    @Override
    public IOFilter createClientFilter(InetSocketAddress remoteAddress) throws Exception {
        return this.createFilter(true, remoteAddress);
    }

    @Override
    public IOFilter createServerFilter(InetSocketAddress remoteAddress) throws Exception {
        return this.createFilter(false, remoteAddress);
    }

    private IOFilter createFilter(boolean clientMode, InetSocketAddress remoteAddress) throws Exception {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("Create a new SSL filter clientMode=" + clientMode);
        }
        SSLContext sslContext = this.createSSLContext(clientMode, this.keystore, this.password);
        IOSSLFilter filter = new IOSSLFilter(sslContext, remoteAddress);
        filter.setUseClientMode(clientMode);
        return filter;
    }

    protected SSLContext createSSLContext(boolean clientMode, String keystore, String password) throws Exception {
        char[] passphrase = password == null ? "foo".toCharArray() : password.toCharArray();
        KeyStore ks = this.loadKeyStore(keystore, passphrase);
        SSLContext sslContext = SSLContext.getInstance(this.PROTOCOL);
        if (clientMode) {
            if (!this.autoGenerateCertificate) {
                TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                tmf.init(ks);
                sslContext.init(null, tmf.getTrustManagers(), null);
            } else {
                sslContext.init(null, new TrustManager[]{TrustManagers.TRUST_ALL}, null);
            }
        } else {
            KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            kmf.init(ks, passphrase);
            sslContext.init(kmf.getKeyManagers(), null, null);
        }
        return sslContext;
    }

    protected synchronized KeyStore loadKeyStore(String keystore, char[] passphrase) throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException {
        if (this.ks == null) {
            KeyStore ks = KeyStore.getInstance("JKS");
            URL url = ResourceLoader.getResourceURL(keystore);
            if (url == null) {
                File f = new File(keystore);
                if (f.exists()) {
                    FileInputStream in = new FileInputStream(f);
                    ks.load(in, passphrase);
                    ((InputStream)in).close();
                    return ks;
                }
                throw new KeyStoreException("Could not find SSL keystore file " + keystore + " in classpath or as a direct path");
            }
            InputStream is = url.openStream();
            ks.load(is, passphrase);
            is.close();
            return ks;
        }
        return this.ks;
    }
}

