/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.lrmi.nio.info;

import com.gigaspaces.config.lrmi.nio.NIOConfiguration;
import com.gigaspaces.lrmi.LRMIMonitoringDetails;
import com.gigaspaces.lrmi.LRMIRuntime;
import com.gigaspaces.lrmi.nio.filters.SSLFilterFactory;
import com.gigaspaces.lrmi.nio.info.NIODetails;
import com.gigaspaces.lrmi.nio.info.NIOStatistics;
import com.gigaspaces.start.SystemInfo;
import com.j_spaces.core.service.ServiceConfigLoader;
import com.j_spaces.kernel.threadpool.DynamicThreadPoolExecutor;
import java.util.concurrent.ThreadPoolExecutor;

public abstract class NIOInfoHelper {
    private static NIODetails details;
    private static final String localHostAddress;
    private static final String localHostName;

    public static String getLocalHostAddress() {
        return localHostAddress;
    }

    public static String getLocalHostName() {
        return localHostName;
    }

    public static NIODetails getDetails() {
        if (details == null) {
            NIOConfiguration nioConfiguration = (NIOConfiguration)ServiceConfigLoader.getTransportConfiguration();
            details = new NIODetails(LRMIRuntime.getRuntime().getID(), localHostAddress, localHostName, nioConfiguration.getBindHostName(), LRMIRuntime.getRuntime().getPort(nioConfiguration), nioConfiguration.getMinThreads(), nioConfiguration.getMaxThreads(), SSLFilterFactory.class.getName().equals(System.getProperty("com.gs.lrmi.filter.factory")));
        }
        return details;
    }

    public static NIOStatistics getNIOStatistics() {
        LRMIRuntime lrmiRuntime = LRMIRuntime.getRuntime();
        DynamicThreadPoolExecutor threadPoolExecutor = lrmiRuntime.getThreadPool();
        return new NIOStatistics(System.currentTimeMillis(), threadPoolExecutor.getCompletedTaskCount(), ((ThreadPoolExecutor)threadPoolExecutor).getActiveCount(), threadPoolExecutor.getQueue().size());
    }

    public static LRMIMonitoringDetails fetchMonitoringDetails() {
        NIOConfiguration nioConfiguration = (NIOConfiguration)ServiceConfigLoader.getTransportConfiguration();
        return LRMIRuntime.getRuntime().getMonitoringDetails(nioConfiguration);
    }

    public static void enableMonitoring() {
        LRMIRuntime.getRuntime().setMonitorActivity(true);
    }

    public static void disableMonitoring() {
        LRMIRuntime.getRuntime().setMonitorActivity(false);
    }

    static {
        localHostAddress = SystemInfo.singleton().network().getHost().getHostAddress();
        localHostName = SystemInfo.singleton().network().getHost().getHostName();
    }
}

