/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.lrmi.nio.info;

import com.gigaspaces.api.InternalApi;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

@InternalApi
public class NIOStatistics
implements Externalizable {
    private static final long serialVersionUID = -2757963460329854081L;
    private static long NA_TIMESTAMP = -1L;
    private long timestamp = NA_TIMESTAMP;
    private long completedTaskCount = -1L;
    private int activeThreadsCount = -1;
    private int queueSize = -1;

    public NIOStatistics() {
    }

    public NIOStatistics(long timestamp, long completedTaskCount, int activeThreadsCount, int queueSize) {
        this.timestamp = timestamp;
        this.completedTaskCount = completedTaskCount;
        this.activeThreadsCount = activeThreadsCount;
        this.queueSize = queueSize;
    }

    public boolean isNA() {
        return this.timestamp == NA_TIMESTAMP;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public long getCompletedTaskCount() {
        return this.completedTaskCount;
    }

    public int getActiveThreadsCount() {
        return this.activeThreadsCount;
    }

    public int getQueueSize() {
        return this.queueSize;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeLong(this.timestamp);
        out.writeLong(this.completedTaskCount);
        out.writeInt(this.activeThreadsCount);
        out.writeInt(this.queueSize);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.timestamp = in.readLong();
        this.completedTaskCount = in.readLong();
        this.activeThreadsCount = in.readInt();
        this.queueSize = in.readInt();
    }
}

