/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.lrmi.nio.selector;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.utils.concurrent.GSThread;
import com.gigaspaces.lrmi.nio.Pivot;
import com.gigaspaces.lrmi.nio.selector.handler.AbstractSelectorThread;
import com.gigaspaces.lrmi.nio.selector.handler.AcceptSelectorThread;
import com.gigaspaces.lrmi.nio.selector.handler.ReadSelectorThread;
import com.gigaspaces.lrmi.nio.selector.handler.WriteSelectorThread;
import com.j_spaces.kernel.ManagedRunnable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.SelectableChannel;

@InternalApi
public class SelectorManager
extends ManagedRunnable {
    private final Pivot _pivot;
    private final ReadSelectorThread[] _readSelectorThread;
    private final WriteSelectorThread[] _writeSelectorThread;
    private final AcceptSelectorThread _acceptSelectorThread;
    private final String _port;
    private final String _hostName;

    public SelectorManager(Pivot pivot, String hostName, String port, int readSelectorThreads) throws IOException {
        this._pivot = pivot;
        this._hostName = hostName;
        this._port = port;
        this._readSelectorThread = new ReadSelectorThread[readSelectorThreads];
        this._writeSelectorThread = new WriteSelectorThread[readSelectorThreads];
        try {
            for (int i = 0; i < readSelectorThreads; ++i) {
                this._readSelectorThread[i] = new ReadSelectorThread(this._pivot);
                GSThread readThread = new GSThread((Runnable)this._readSelectorThread[i], "LRMI-Selector-Read-Thread-" + i);
                readThread.setDaemon(true);
                readThread.start();
                this._writeSelectorThread[i] = new WriteSelectorThread(this._pivot);
                GSThread writeThread = new GSThread((Runnable)this._writeSelectorThread[i], "LRMI-Selector-Write-Thread-" + i);
                writeThread.setDaemon(true);
                writeThread.start();
            }
            this._acceptSelectorThread = new AcceptSelectorThread(this._pivot, this._readSelectorThread, this._hostName, this._port);
            GSThread acceptThread = new GSThread((Runnable)this._acceptSelectorThread, "LRMI-Selector-Accept-Thread-" + this._port);
            acceptThread.setDaemon(true);
            acceptThread.start();
        }
        catch (IOException e) {
            this.waitWhileFinish();
            throw e;
        }
    }

    @Override
    protected void waitWhileFinish() {
        if (this._acceptSelectorThread != null) {
            this._acceptSelectorThread.requestShutdown();
        }
        for (ReadSelectorThread readSelectorThread : this._readSelectorThread) {
            if (readSelectorThread == null) continue;
            readSelectorThread.requestShutdown();
        }
        for (AbstractSelectorThread abstractSelectorThread : this._writeSelectorThread) {
            if (abstractSelectorThread == null) continue;
            abstractSelectorThread.requestShutdown();
        }
    }

    public InetSocketAddress getBindInetSocketAddress() {
        return this._acceptSelectorThread.getBindInetSocketAddress();
    }

    public WriteSelectorThread getWriteHandler(SelectableChannel channel) {
        return this._writeSelectorThread[Math.abs(System.identityHashCode(channel) % this._writeSelectorThread.length)];
    }

    public int getPort() {
        return this._acceptSelectorThread.getPort();
    }

    public String getHostName() {
        return this._acceptSelectorThread.getHostName();
    }
}

