/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.lrmi.nio.selector.handler;

import com.gigaspaces.lrmi.nio.Pivot;
import com.gigaspaces.lrmi.nio.selector.handler.AcceptSelectorThread;
import com.gigaspaces.time.SystemTime;
import com.j_spaces.kernel.ManagedRunnable;
import java.io.IOException;
import java.net.Socket;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ClosedSelectorException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class AbstractSelectorThread
extends ManagedRunnable
implements Runnable {
    private static final long SELECT_TIMEOUT = 10000L;
    protected static final Logger _logger = Logger.getLogger("com.gigaspaces.lrmi");
    private final Selector _selector = Selector.open();
    protected final Pivot _pivot;
    private long lastCleanup = 0L;
    protected volatile Thread ownerThread;

    protected AbstractSelectorThread(Pivot pivot) throws IOException {
        this._pivot = pivot;
    }

    @Override
    public void run() {
        this.ownerThread = Thread.currentThread();
        while (!this.shouldShutdown() && this._selector.isOpen()) {
            this.doSelect();
        }
    }

    private void doSelect() {
        block12: {
            SelectionKey key = null;
            try {
                this.enableSelectionKeys();
                this.checkForDeadConnections();
                this._selector.select(10000L);
                Set<SelectionKey> readyKeys = this._selector.selectedKeys();
                if (readyKeys == null) {
                    return;
                }
                Iterator<SelectionKey> iterator = readyKeys.iterator();
                while (iterator.hasNext()) {
                    key = iterator.next();
                    iterator.remove();
                    if (key.isValid() && key.channel().isOpen()) {
                        this.handleConnection(key);
                        continue;
                    }
                    this.cancelKey(key);
                }
            }
            catch (ClosedSelectorException ex) {
                _logger.log(Level.FINER, "Selector was closed.", ex);
                if (key != null) {
                    key.cancel();
                }
            }
            catch (IOException e) {
                if (key != null) {
                    if (this instanceof AcceptSelectorThread) {
                        _logger.log(Level.SEVERE, "exception in main selection loop, delay selector for 1 second", e);
                        this.delay(e);
                    } else {
                        _logger.log(Level.SEVERE, "exception in main selection loop, canceling key", e);
                        key.cancel();
                    }
                } else {
                    _logger.log(Level.SEVERE, "exception in main selection loop", e);
                }
            }
            catch (Throwable t) {
                _logger.log(Level.SEVERE, "exception in main selection loop", t);
                if (key == null) break block12;
                key.cancel();
            }
        }
    }

    private void delay(IOException ex) {
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            _logger.log(Level.SEVERE, "Interrupted while delaying accept selector because of exception " + ex, e);
        }
    }

    protected SelectionKey register(SocketChannel channel, int requestOps) throws ClosedChannelException {
        Exception failureReason = null;
        for (int i = 0; i < 3; ++i) {
            try {
                return channel.register(this.getSelector(), requestOps);
            }
            catch (CancelledKeyException cke) {
                try {
                    failureReason = cke;
                    if (_logger.isLoggable(Level.FINE)) {
                        _logger.log(Level.FINE, "caught CancelledKeyException while registering socket interest [" + channel.toString() + "] at attempt " + (i + 1) + ", retrying...", cke);
                    }
                    this._selector.selectNow();
                    continue;
                }
                catch (IOException ioe) {
                    failureReason = ioe;
                    if (!_logger.isLoggable(Level.FINE)) break;
                    _logger.log(Level.FINE, "caught IOException while registering socket interest [" + channel.toString() + "] at attempt " + (i + 1), ioe);
                    break;
                }
            }
        }
        if (_logger.isLoggable(Level.WARNING)) {
            _logger.log(Level.WARNING, "failed all attempts of registering socket interest, closing socket [" + channel.toString() + "]", failureReason);
        }
        this.closeChannel(channel);
        throw new ClosedChannelException();
    }

    private void checkForDeadConnections() {
        long now = SystemTime.timeMillis();
        if (now > this.lastCleanup + 30000L) {
            this.lastCleanup = now;
            Set<SelectionKey> keys = this._selector.keys();
            for (SelectionKey key : keys) {
                if (key.channel().isOpen()) continue;
                this.cancelKey(key);
            }
        }
    }

    protected abstract void enableSelectionKeys();

    protected abstract void handleConnection(SelectionKey var1) throws IOException, InterruptedException;

    protected void cancelKey(SelectionKey key) {
        if (key == null || !key.isValid()) {
            return;
        }
        this.closeChannel((SocketChannel)key.channel());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeChannel(SocketChannel channel) {
        if (channel == null) {
            return;
        }
        Socket socket = channel.socket();
        try {
            socket.shutdownInput();
            socket.shutdownOutput();
            socket.close();
        }
        catch (IOException ex) {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "error while closing a key", ex);
            }
        }
        finally {
            block14: {
                try {
                    channel.close();
                }
                catch (IOException ex) {
                    if (!_logger.isLoggable(Level.FINE)) break block14;
                    _logger.log(Level.FINE, "error while closing a channel", ex);
                }
            }
        }
    }

    @Override
    protected void waitWhileFinish() {
        block2: {
            try {
                this._selector.close();
            }
            catch (IOException ex) {
                if (!_logger.isLoggable(Level.FINE)) break block2;
                _logger.log(Level.FINE, "error while closing the selector", ex);
            }
        }
    }

    protected Selector getSelector() {
        return this._selector;
    }
}

