/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.lrmi.nio.selector.handler;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.lrmi.LRMIUtilities;
import com.gigaspaces.lrmi.nio.Pivot;
import com.gigaspaces.lrmi.nio.selector.handler.AbstractSelectorThread;
import com.gigaspaces.lrmi.nio.selector.handler.ReadSelectorThread;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.nio.channels.SelectionKey;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.StringTokenizer;
import java.util.logging.Level;

@InternalApi
public class AcceptSelectorThread
extends AbstractSelectorThread {
    private final ReadSelectorThread[] _readHandlers;
    private final ServerSocket _serverSocket;
    private final int port;
    private final String _hostName;

    public AcceptSelectorThread(Pivot pivot, ReadSelectorThread[] readHandlers, String hostName, String port) throws IOException {
        super(pivot);
        this._readHandlers = readHandlers;
        this._hostName = hostName;
        ServerSocketChannel serverSocketChannel = ServerSocketChannel.open();
        this._serverSocket = serverSocketChannel.socket();
        int backlog = Integer.getInteger("com.gs.transport_protocol.lrmi.accpet-backlog", 1024);
        int portNumber = -1;
        boolean bounded = false;
        StringTokenizer st = new StringTokenizer(port, ",");
        block4: while (st.hasMoreTokens() && !bounded) {
            String portToken = st.nextToken().trim();
            int index = portToken.indexOf(45);
            if (index == -1) {
                portNumber = Integer.parseInt(portToken.trim());
                try {
                    this._serverSocket.bind(new InetSocketAddress(hostName, portNumber), backlog);
                    bounded = true;
                }
                catch (IOException e) {
                    if (!_logger.isLoggable(Level.FINE)) continue;
                    _logger.log(Level.FINE, "Failed to bind to port [" + portNumber + "] on host [" + hostName + "]", e);
                }
                continue;
            }
            int startPort = Integer.parseInt(portToken.substring(0, index).trim());
            int endPort = Integer.parseInt(portToken.substring(index + 1).trim());
            if (endPort < startPort) {
                throw new IllegalArgumentException("Start port [" + startPort + "] must be greater than end port [" + endPort + "]");
            }
            for (int i = startPort; i <= endPort; ++i) {
                portNumber = i;
                try {
                    this._serverSocket.bind(new InetSocketAddress(hostName, portNumber), backlog);
                    bounded = true;
                    continue block4;
                }
                catch (IOException ex) {
                    if (!_logger.isLoggable(Level.FINE)) continue;
                    _logger.log(Level.FINE, "Failed to bind to port [" + portNumber + "] on host [" + hostName + "]", ex);
                    continue;
                }
            }
        }
        if (!bounded) {
            throw new IOException("Failed to bind to port [" + port + "] on host [" + hostName + "]");
        }
        this.port = this._serverSocket.getLocalPort();
        serverSocketChannel.configureBlocking(false);
        serverSocketChannel.register(this.getSelector(), 16);
    }

    public int getPort() {
        return this.port;
    }

    public String getHostName() {
        return this._hostName;
    }

    @Override
    protected void handleConnection(SelectionKey key) throws IOException, InterruptedException {
        if (key.isAcceptable()) {
            this.handleAccept(key);
        }
    }

    private void handleAccept(SelectionKey key) throws IOException {
        ServerSocketChannel server = (ServerSocketChannel)key.channel();
        SocketChannel channel = server.accept();
        if (channel != null) {
            channel.configureBlocking(false);
            LRMIUtilities.initNewSocketProperties(channel);
            ReadSelectorThread handler = this._readHandlers[Math.abs(System.identityHashCode(channel) % this._readHandlers.length)];
            handler.createKey(channel);
        }
    }

    @Override
    protected void enableSelectionKeys() {
    }

    @Override
    protected void waitWhileFinish() {
        block2: {
            super.waitWhileFinish();
            try {
                this._serverSocket.close();
            }
            catch (IOException ex) {
                if (!_logger.isLoggable(Level.FINE)) break block2;
                _logger.log(Level.FINE, "Error while closing the server socket.", ex);
            }
        }
    }

    public InetSocketAddress getBindInetSocketAddress() {
        return (InetSocketAddress)this._serverSocket.getLocalSocketAddress();
    }
}

