/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.lrmi.nio.selector.handler;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.lrmi.nio.ChannelEntry;
import com.gigaspaces.lrmi.nio.Pivot;
import com.gigaspaces.lrmi.nio.Reader;
import com.gigaspaces.lrmi.nio.selector.handler.AbstractSelectorThread;
import java.io.IOException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;

@InternalApi
public class ReadSelectorThread
extends AbstractSelectorThread {
    private final Queue<SelectionKey> _keysToEnable = new ConcurrentLinkedQueue<SelectionKey>();
    private final AtomicInteger _keysToEnableCounter = new AtomicInteger();
    private final Queue<SocketChannel> _keysToCreate = new ConcurrentLinkedQueue<SocketChannel>();
    private final AtomicInteger _keysToCreateCounter = new AtomicInteger();

    public ReadSelectorThread(Pivot pivot) throws IOException {
        super(pivot);
    }

    @Override
    protected void handleConnection(SelectionKey key) throws IOException, InterruptedException {
        if (key.isReadable()) {
            this.handleRead(key);
        }
    }

    private void handleRead(SelectionKey key) throws IOException {
        key.interestOps(key.interestOps() & 0xFFFFFFFE);
        SocketChannel channel = (SocketChannel)key.channel();
        ChannelEntry channelEntry = this._pivot.getChannelEntryFromChannel(channel);
        if (channelEntry != null) {
            if (this._pivot.isProtocolValidationEnabled() && !channelEntry.isProtocolValidated()) {
                Reader.ProtocolValidationContext ctx = (Reader.ProtocolValidationContext)key.attachment();
                if (ctx == null) {
                    ctx = new Reader.ProtocolValidationContext(key);
                    key.attach(ctx);
                }
                this._pivot.handleProtocolValidation(channelEntry, ctx, this);
            } else {
                Reader.Context ctx = (Reader.Context)key.attachment();
                if (ctx == null) {
                    channelEntry.setChannelState(ChannelEntry.State.PROGRESS);
                    ctx = new Reader.Context(key);
                    key.attach(ctx);
                }
                this._pivot.handleReadRequest(channelEntry, ctx, this);
            }
        }
    }

    @Override
    protected void enableSelectionKeys() {
        int i;
        int size = this._keysToEnableCounter.get();
        for (i = 0; i < size; ++i) {
            SelectionKey selectionKey = this._keysToEnable.poll();
            this._keysToEnableCounter.decrementAndGet();
            if (!selectionKey.isValid()) continue;
            selectionKey.interestOps(selectionKey.interestOps() | 1);
        }
        size = this._keysToCreateCounter.get();
        for (i = 0; i < size; ++i) {
            SelectionKey readKey;
            SocketChannel channel = this._keysToCreate.poll();
            this._keysToCreateCounter.decrementAndGet();
            try {
                readKey = this.register(channel, 1);
            }
            catch (ClosedChannelException e) {
                continue;
            }
            this._pivot.newConnection(this, readKey);
        }
    }

    public void registerKey(SelectionKey key) {
        if (key == null) {
            return;
        }
        this._keysToEnable.add(key);
        this._keysToEnableCounter.incrementAndGet();
        this.getSelector().wakeup();
    }

    public void createKey(SocketChannel channel) {
        this._keysToCreate.add(channel);
        this._keysToCreateCounter.incrementAndGet();
        this.getSelector().wakeup();
    }
}

