/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.lrmi.nio.selector.handler;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.lrmi.nio.ChannelEntry;
import com.gigaspaces.lrmi.nio.Pivot;
import com.gigaspaces.lrmi.nio.selector.handler.AbstractSelectorThread;
import java.io.IOException;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;

@InternalApi
public class WriteSelectorThread
extends AbstractSelectorThread {
    private final Queue<ChannelEntry> _keysToCreate = new ConcurrentLinkedQueue<ChannelEntry>();
    private final AtomicInteger _keysToCreateCounter = new AtomicInteger();

    public WriteSelectorThread(Pivot pivot) throws IOException {
        super(pivot);
    }

    @Override
    protected void enableSelectionKeys() {
        int size = this._keysToCreateCounter.get();
        for (int i = 0; i < size; ++i) {
            ChannelEntry channelEntry = this._keysToCreate.poll();
            this._keysToCreateCounter.decrementAndGet();
            SocketChannel channel = channelEntry.getSocketChannel();
            try {
                channelEntry._writeSelectionKey = this.register(channel, 4);
                continue;
            }
            catch (ClosedChannelException closedChannelException) {
                // empty catch block
            }
        }
    }

    @Override
    protected void handleConnection(SelectionKey key) throws IOException, InterruptedException {
        if (key.isWritable()) {
            this.handleWrite(key);
        }
    }

    private void handleWrite(SelectionKey key) throws IOException {
        key.interestOps(key.interestOps() & 0xFFFFFFFB);
        SocketChannel channel = (SocketChannel)key.channel();
        ChannelEntry channelEntry = this._pivot.getChannelEntryFromChannel(channel);
        if (channelEntry != null) {
            channelEntry.onWriteEvent();
        }
    }

    public void setWriteInterest(ChannelEntry channelEntry) {
        if (channelEntry != null) {
            if (channelEntry._writeSelectionKey == null) {
                this._keysToCreate.add(channelEntry);
                this._keysToCreateCounter.incrementAndGet();
                this.getSelector().wakeup();
            } else {
                SelectionKey key = channelEntry._writeSelectionKey;
                try {
                    key.interestOps(key.interestOps() | 4);
                }
                catch (CancelledKeyException e) {
                    if (_logger.isLoggable(Level.WARNING)) {
                        _logger.log(Level.WARNING, "exception caught while setting write interest", e);
                    }
                    this.closeChannel(channelEntry.getSocketChannel());
                }
            }
        }
    }

    public void removeWriteInterest(SelectionKey key) {
        if (key != null) {
            key.cancel();
        }
    }
}

