/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.lrmi.nio.selector.handler.client;

import com.gigaspaces.lrmi.nio.selector.handler.client.Conversation;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;

public abstract class AbstractChat<T> {
    protected Conversation conversation;

    public abstract boolean init(Conversation var1, SelectionKey var2);

    public abstract boolean process(SelectionKey var1);

    public abstract T result();

    protected void removeInterest(SelectionKey key, int op) {
        if (!key.isValid()) {
            return;
        }
        int interestOps = key.interestOps();
        if ((interestOps & op) != 0) {
            key.interestOps(interestOps & ~op);
        }
    }

    protected void addInterest(SelectionKey key, int op) {
        if (!key.isValid()) {
            return;
        }
        int interestOps = key.interestOps();
        if ((interestOps & op) == 0) {
            key.interestOps(interestOps | op);
        }
    }

    public byte write(SelectionKey key, ByteBuffer msg) {
        SocketChannel channel = (SocketChannel)key.channel();
        try {
            channel.write(msg);
        }
        catch (Throwable t) {
            key.cancel();
            this.conversation.close(t);
            return -1;
        }
        if (msg.remaining() == 0) {
            this.removeInterest(key, 4);
            return 1;
        }
        this.addInterest(key, 4);
        return 0;
    }
}

